/*
 * synchro.c
 *	Definitions for base synchro class SynchroObject,
 *	and non inlineable code for the derived synchro classes
 *	(locks and monitors)
 *
 *	Last modified:		1/2/88
 *	by:			bnb
 *	reason:			Remove necessary for named objects
 *
 *	Last modified:		12/21/87
 *	by:			bnb
 *	reason:			add these comments
 *
 */


#define _SYNCHRO_C

#include "presto.h"



//
// Can not be defined in-line cuz it needs to know about ThreadQ's
//

SynchroObject::SynchroObject(int t, char *name=0)	: (t,name)
{
	so_waiting = new ThreadQUnlocked(TS_BLOCKED);
	so_lock = new Spinlock;
}


SynchroObject::~SynchroObject()
{
	Thread *t;
	lock();
	if (so_waiting->empty())	{
		delete so_waiting;
	}
	else	{
		cerr << "ERROR:" << thisproc << "\nUnsatisfied synchro object [" <<
		     this->name() << "]\n";
		while (t = so_waiting->get())	{
			t->print(cerr);
			cerr << "\n";
		}
		error("Cannot delete synchronization object");
		delete so_waiting;
	}
	unlock();
	delete so_lock;
}


void
SynchroObject::print(ostream &s)
{
	s << form("(SynchroObject)this=0x%x", this) << name() <<
	     "so_lock=" << so_lock << " so_waiting= " << so_waiting;
}
