//
// Stack maintenance
//
//


#define MINSTACKSIZEXP	(10)
#define ONEK		(1<<10)
#define MINSTACKSIZ	(1<<MINSTACKSIZEXP)		/* 1k */
#define DEFSTACKSIZ	(MINSTACKSIZ << 3)		/* 4k */
#define MAXSTACKSIZ	(MINSTACKSIZ << 10)		/* 1Mb */

//
// Return how many integral chunks of MINSTACKSIZES fit in the 
// requested stacksize
//
#define STACKSIZTOMINCHUNKS(sz)	(sz >> MINSTACKSIZEXP)

class Stack;
//
// We keep a stack of free stacks.  When we need a new stack, we
// move downward, trying to find the right size (or bigger).  The intention
// is that what we need will be near the top, since we are likely to be
// asking for something that we asked for before.  This won't always
// hold, but its just as cheap to use a stack as anything else.
// 


#define MAXFREESTACKS		100		

class FreeStacks	{
	Stack* fs_free[MAXFREESTACKS];
	int   fs_sp;
	Spinlock *fs_lock;
public:
	FreeStacks();
	~FreeStacks();
	Stack *find(int sz);
	void free(Stack*);
};

		
class Stack	{
	int *st_base;		// bottom of stack
	int st_size;		// what user thinks
	int st_limit;		// what we really are
public:
	Stack(int size);
	~Stack();
	int size()
		{ return st_size; }		
	int limit()
		{ return st_limit;}
/* XX machdep */		
	int *top()
		{ return  (int*)(((int)st_base + st_limit - 4) & ~03);}
	void destroy()
		{ delete st_base; }
	int numstacksbuilt();
};


