#include "presto.h"

FreeStacks::FreeStacks()
{
	fs_lock = new Spinlock();
	fs_sp = 0;
}


FreeStacks::~FreeStacks()
{

	fs_lock->lock();

	register int end = fs_sp - 1;

	while (end >= 0)	{
		fs_free[end]->destroy();
		end--;
	}		
	fs_lock->unlock();
	delete fs_lock;
}
	
	
//
// find a stack having the right size (or greater)
//
Stack*
FreeStacks::find(int sz)
{
	Stack *s = 0;
	register int end;
	
	fs_lock->lock();

	end = fs_sp - 1;
	while (end >= 0)	{
		if (fs_free[end]->limit() >= sz)	{
			s = fs_free[end];
			fs_free[end] = fs_free[--fs_sp];
			break;
		}
		end--;
	}
	fs_lock->unlock();
	return s;
}

void
FreeStacks::free(Stack *s)
{
	fs_lock->lock();
	
	if (fs_sp == MAXFREESTACKS)	{
		fs_lock->unlock();
		s->destroy();
	}
	else	{
		fs_free[fs_sp++] = s;
		fs_lock->unlock();
	}
}


static shared_t stackcnt = 0;
static shared_t FreeStacks freestacks;
//
// freestacks really belongs as a static member of Stack, but we can't
// have static members with constructors.
//

Stack::Stack(int sz)
{
	register Stack *s = 0;

	if (this)	{
		error("Can only allocate a stack on the heap");
	}
	
	if (sz)	{
		sz = sz &(~0x200);		// force page size boundaries
		s = freestacks.find(sz);
	} 
	if (s)	{
		this = s;
	} else {
		this = (Stack*)new char[sizeof(Stack)];
		stackcnt++;
		st_base = (int*)new char[sz];
		st_size = sz;
		st_limit = sz;
	};
}

#ifdef notdef
#define DONTREUSESTACKS
#endif
Stack::~Stack()
{
	freestacks.free(this);
	this = 0;		// prevent regular dealloc
}
	
int
Stack::numstacksbuilt()
{ 
	return stackcnt;
}		
	


	

			
			
