//
// Spinlocks should be used when the caller expects to need to touch
// a piece of data for only a very short time.  Interference on that
// data will cause the later thread to spin (his processor does not
// become available!)
//
//	USE WITH CAUTION
//
//

//
// If compiling presto kernel, or compiling with preemption 
// included, then include code to make threads not preemptable
// inside spinlock.  Else, omit for speed.
//

#define DO_SPINLOCK_INLINE

#ifdef DO_SPINLOCK_INLINE
#define SPINLOCK_INLINE 	inline
#else
#define SPINLOCK_INLINE
#endif

#ifdef sequent
#include "parallel.h"
#endif sequent
#ifdef sun
#include "parallel.h"
#endif sun

#ifdef vax 
typedef	int slock_t;
#define L_UNLOCKED 0

#define S_LOCK s_lock
#define S_UNLOCK s_unlock

//
// For the vax, the underlying lock functions are in vax_lock.s and
// spinlock.c.  The s_lock and s_unlock functions do not return a
// meaningful result.
//
#endif vax
#ifdef sun
#define S_LOCK s_lock
#endif sun

extern void s_init_lock(slock_t*);
extern void s_lock(slock_t*);
extern void s_unlock(slock_t*);
extern int s_clock(slock_t*);

class Thread;

class Spinlock	: public Object  {	
	slock_t		sl_lock;
public:
	Spinlock()
		{ s_init_lock(&sl_lock); }
	SPINLOCK_INLINE ~Spinlock();

	//
	// Acquire lock, spinning until it is free.
	//
	SPINLOCK_INLINE void lock();

	//
	// Acquire lock and return true iff lock is free, else return
	// false immediately without spinning.
	//
	int trylock()
		{ return  s_clock(&sl_lock); }

	//
	// Old name for trylock().
	//
	int checklock()
		{ return  s_clock(&sl_lock); }

	//
	// Return true iff locked, else false.
	//
	int testlock()
		{ return  sl_lock; }

	//
	// Release lock.
	//
	SPINLOCK_INLINE void unlock();
	virtual void print(ostream& = cout);
};
     


