//
// spinlock.c
//	non-inlined functions for spinlocks
//

#include <stream.h>
#include "presto.h"

void
Spinlock::print(ostream& s)
{
	s << form("(Spinlock)this=0x%x, sl_lock=0x%x", this, this->sl_lock);
}


#ifdef vax

//
// These are the functions that eventually get called for operations on
// spinlocks on a VAX.
//

void
s_init_lock(slock_t* l)
{
     *l  = 0;
}

/*
 * s_lock, s_unlock and s_clock are defined in asm code in vax_lock.s
 * XXX asm versions of s_lock and s_unlock don't return a value, should
 * be void.
 *
 * s_clock acquires the spinlock iff it is free, else returns immediately
 * without spinning.
 *
 * The asm versions of these functions assume that a lock is a longword.
 * The low-order bit of the word is used as the lock bit.  The other bits
 * are unused.
 */

/*

int
*s_lock(slock_t *l)
{
    while (*l)
	 ;
    return(*l++);
}


int
s_unlock(slock_t* l)
{
     *l = 0;
     return(1);
}


int
s_clock(slock_t* l)
{
     return((*l) ? 0 : (*l)++);
}

*/

#endif vax
#ifdef sun
#ifdef DO_SPINLOCK_INLINE
        //
        // s_lock, s_unlock and s_clock are defined in sun_lock.s
        //
        void s_init_lock(slock_t* l) {
		*l  = 0; 
	}

        void s_lock(slock_t *l) { 
		while (*l) ; *l =  1; 
	}
        void s_unlock(slock_t* l) { 
		*l = 0; 
	}
        int s_clock(slock_t* l) { 
		return((*l) ? 0 : (*l)++);
	}
#else
        void Spinlock::~Spinlock() {
                if (sl_lock)
                        unlock();
        }

        void Spinlock::unlock() {
                (void) S_UNLOCK(&sl_lock);
#   ifndef NO_PREEMPT
                thisthread->releasingspinlock();
#   endif  NO_PREEMPT
        }

        void Spinlock::lock() {
#   ifndef NO_PREEMPT
                thisthread->holdingspinlock();

#   endif NO_PREEMPT
                (void) S_LOCK(&sl_lock);
        }
#endif DO_SPINLOCK_INLINE
#endif sun
