/* $Copyright:	$
 * Copyright (c) 1984, 1985, 1986 Sequent Computer Systems, Inc.
 * All rights reserved
 *  
 * This software is furnished under a license and may be used
 * only in accordance with the terms of that license and with the
 * inclusion of the above copyright notice.   This software may not
 * be provided or otherwise made available to, or used by, any
 * other person.  No title to or ownership of the software is
 * hereby transferred.
 */

/* $Header: /crg2/bruces2/rbk/C++/Presto/src/RCS/parallel.h,v 1.2 88/03/24 09:52:47 rbk Exp $
 *
 * parallel.h
 *	Definitions for use in parallel, shared-memory programs.
 */

/* $Log:	parallel.h,v $
 * Revision 1.2  88/03/24  09:52:47  rbk
 * #ifdef ns32000 around ALM fuss.  Can't use system version of this file
 * since C++ doesn't understand asm-functions yet.
 * 
 * Revision 1.1  88/03/22  15:26:42  rbk
 * Initial revision
 * 
 */

/*
 * A "lock" is a byte of memory, initialized to zero (unlocked).
 */

typedef unsigned char	slock_t;		/* 's' for "spin"-lock */

#define	L_UNLOCKED	0
#define	L_LOCKED	1

/*
 * Was a conditional lock request granted (L_SUCCESS) or denied (L_FAILED)
 */
#define L_FAILED	0
#define L_SUCCESS	1

/*
 * A "barrier" allows multiple processes to synchronize by having
 * all of them exit the barrier construct simultaneously.
 *
 * This version assumes <= 255 processes, fits in one 4-byte integer,
 * and is based on spin-locks.
 */

typedef struct	{
	slock_t		b_mutex;	/* mutual exclusion */
	unsigned char	b_limit;	/* number participants */
	unsigned char	b_count;	/* state counter */
	unsigned char	b_useno;	/* current use # (state flag) */
} sbarrier_t;				/* 's' for "spin"-barrier */


#ifndef c_plusplus
/*
 * Other useful declarations.
 */

extern	char	*sbrk(), *shsbrk();
extern	char	*shmalloc();

#endif

#ifdef	ns32000
/*
 * ALM_HASH() is used to hash an address to an ALM offset.
 */

#define	ALM_HASH(x)	((int)(&(x)) & (0xFF << 2))

/*
 * S_LOCK() and S_UNLOCK() provide in-line access to locks for C-programs;
 * these can be used in time-criticial situations, at a cost in code size.
 *
 * CAREFUL using S_LOCK(): cc -O -i doesn't do S_LOCK(&x) correctly; need
 * to pass pointer to lock, not address of lock.
 */

#define	S_LOCK(lp)	{ \
	register char	*lock_alm = &_alm_base[ALM_HASH(*(lp))]; \
	for (;;) { \
		/* Wait for lock to be available */ \
		while (*(lp) == L_LOCKED) \
			continue; \
		/* Grab ALM gate for atomic access to lock */ \
		while (*lock_alm & ALM_LOCKED) \
			continue; \
		/* Can race with others trying to get the lock */ \
		if (*(lp) == L_UNLOCKED) { \
			/* No race (or won it) -- grab the lock */ \
			*(lp) = L_LOCKED; \
			*lock_alm = ALM_UNLOCKED; \
			break; \
		} \
		/* Lost race, try again */ \
		*lock_alm = ALM_UNLOCKED; \
	} \
}

#define	S_UNLOCK(lp)	(*(lp) = L_UNLOCKED)

/*
 * Various implementation dependent parameters.
 */

#define	NBALM		4		/* number bytes per ALM */
#define	ALMSIZE		1024		/* size of our portion of ALMs */

#define	ALM_UNLOCKED	0
#define	ALM_LOCKED	1

#define	NALMDEVS	64		/* # different ALM's to try for */

#define	ADDR_RND	0x800		/* boundary round (text/data/end) */

#endif	ns32000

/*
 * Convenience definitions.
 */

#ifndef	NULL
#define	NULL		0
#endif

/*
 * Various globally used data.
 */

extern	int	errno;

extern	int	_shm_fd;		/* fd for shared data mapped file */
#ifdef	ns32000
extern	char	*_alm_base;		/* virt addr of mapped ALM's */
#endif	ns32000
extern	int	_pgoff;			/* getpagesize() - 1 */

/*
 * PGRND() rounds up a value to next page boundary.
 */

#define	PGRND(x)	(char *) (((int)(x) + _pgoff) & ~_pgoff)
