
//
// Scheduler object where all the grungy details
// are kept.
//





//
// All ops on base ThreadPool are "does-not-understand"
//
class ThreadPool	{
public:
	ThreadPool();
	virtual ~ThreadPool();
	virtual Thread*	get();
	virtual void	insert(Thread*);
	virtual int	size();
	int		empty()
		{ return size() == 0; }
};



//
// Derive public to allow coersion
//
class ThreadPoolQueue : public ThreadPool	{	
	ThreadQ	*tp_tq;
public:
	ThreadPoolQueue();
	~ThreadPoolQueue();
	Thread	*get();
	void	insert(Thread*);
	int	size();
};




class Processor;
struct sigcontext;


#define DEFQUANTUM	0		/* milliseconds */

class Scheduler  : public Object	{
protected:
	ThreadPool	*sc_t_ready;		// threads wanting to run
	Process*	sc_p_procs[NUMPROCS];	// workers live here
	int		sc_p_numschedulers;	// max# which can be active
	int		sc_p_activeschedulers;	// # which are active
	int		sc_p_busybits;		// 32 is the proc limit
	Spinlock	*sc_lock;		// Lock busybits
	inline int      busybits(int on);	// atomic set
	int		sc_quantum;		// in ms. if 0, no preemption
public:
	Scheduler(int nschedulers, int quantum = DEFQUANTUM);
	virtual ~Scheduler();
	virtual Thread* getreadythread();	
	virtual void resume(Thread* t);			// put t back on ready q
	virtual int invoke();				// yeah yeah yeah...
	void begin(Thread* t)			// start t running somewhere
		{ resume(t); }
	virtual void halt();			// come to a crashing stop! nicely
	virtual void abort(int sigself);      // not so nicely (may core dump)
//	virtual void kill(Thread* t);			// nuke t
	virtual void	error(char *s);		
	virtual void	print(ostream& = cout);
	int	readyqlen()
		{ return sc_t_ready->size(); }
	int	quantum()
		{ return sc_quantum; }
	int	pidtoprocnum(int p);
	void	storecore(int pnum);		// rename a core file
	virtual ThreadPool*	getreadypool();
	virtual ThreadPool*	setreadypool(ThreadPool*);// use new, return old
	virtual void initsighandlers(int setupdefaults);
friend	sigpreempt_alrm(int sig, int code, sigcontext *scp);
friend  schedulerSigHandler(int sig, int code, sigcontext *scp);
friend  schedulerReapChild(int sig, int code, sigcontext *scp);
};


//
// Keep track of who's busy and who's not.  Access routine must do
// the locking.
//
inline int
Scheduler::busybits(int on)
{
	register int procmask = 1<<(thisproc->id());
	register int shadowbits;
	
//	sc_lock->lock();	
	if (on)
		shadowbits = sc_p_busybits |= procmask;
	else
		shadowbits = sc_p_busybits &= ~procmask;
//	sc_lock->unlock();		
	return shadowbits;
}

extern Scheduler	*sched;


