#ifndef STREAMH
#include <stream.h>
#endif

#include "defs.h"
#include "pstream.h"

#include "objects.h"
#include "spinlock.h"
#include "timer.h"
#include "callstate.h"
#include "stack.h"
#include "threads.h"
#include "spinlock_impl.h"
#include "threadq.h"
#include "process.h"
#include "scheduler.h"
#include "synchro.h"
#include "main.h"
#include "debug.h"

//
// locks should not be implemented run default runtime
//
#include "locks.h"


//
// PRESTO states
//
#define STATIC_CTOR	0		/* static construction */
#define MAIN_INIT	1		/* in Main::init()	*/
#define MAIN_MAIN	2		/* in Main::main()	*/
#define MAIN_DONE	3		/* in Main::done()	*/
#define STATIC_DTOR	4		/* static destructors	*/

extern shared_t int prestoState;
#define MULTITHREADED()		(prestoState == MAIN_MAIN)
#define SINGLETHREADED()	(!MULTITHREADED())
