class Oqueue;

//
// Basic Object struct: Attack at will
//	Objects expect to live in linked lists.  Whatever data
//	actually needs to comprise the object lives in the derivation
// Warning:  the offsets of fields in Thread and Process objects are dependent
//	upon the length of the Object structure; some of these offsets are
//	known to swtch.  If you change the length of Object, you must fix the
//	offsets used in swtch.
//

#define OBJ_ANY		0
#define OBJ_THREAD	1
#define OBJ_PROCESS	2
#define OBJ_MONITOR	3
#define OBJ_CONDVAR	4
#define OBJ_LOCK	5
#define OBJ_END		99		/* free to use after here */

struct Object	{
	int 	o_type;
	char	*o_name;
	Object	*o_next;
	Object	*o_prev;		// unused in base impls
	Object(int t=0, char* n=0)
		{ o_type = t; o_name = n; o_next = o_prev = 0;}
	int& type()
		{ return o_type; }
	char* name()
		{ return o_name; }
	virtual void error(char* s);	// all objects must handle their own errors
	virtual void print(ostream& = cout);
};
ostream& operator<<(ostream&s, Object*o);



struct Oqueue : public Object {
	Object	*oq_head;
	Object	*oq_tail;
	int	oq_state;
	Oqueue(Object* head = 0);
	inline Object*	get();			// from head of queue
	inline Object* lookat();		// return non-destructively
	inline void append(Object* ol);		// to end of queue
	inline void prepend(Object* ol);		// to head of queue
	inline void remove(Object* ol);	// remove middle element
	int&	state()
		{return oq_state;}
	int	empty()
		{return oq_head == 0;}
	virtual void print(ostream& = cout);
};


//
// queue states
//

#define OQ_FREE		0x00		// nothing going on
#define OQ_BUSY		0x01		// someone's got us
#define OQ_EMPTY	0x02		// nothing here
#define OQ_ERROR	0x04		// something amiss


inline
Object*
Oqueue::get()
{
	register Object *o = oq_head;
	if (o)	{
		oq_head = o->o_next;
	}
	return o;
}

inline
Object*
Oqueue::lookat()
{
	return oq_head;
}


inline
void
Oqueue::append(register Object* o)
{
	if (oq_head)	{
		oq_tail->o_next = o;
		oq_tail = o;
	} else
		oq_head = oq_tail = o;
	o->o_next = 0;
}

inline
void
Oqueue::prepend(register Object* o)
{
	o->o_next = oq_head;
	oq_head = o;
}

inline
void
Oqueue::remove(register Object* o)
{
	o->error("Oqueue remove not implemented for single linked lists (yet)");
	abort();
}


