/*
 *	objects.c
 *		implementation code for generic objects.  Objects live
 *		on queues.  These queues can have multiple readers and
 *		one writer (not yet).
 *
 *	Last mod:		1/2/88
 *	By:			bnb
 *	Reason:			add print functions
 *
 *	Last mod:		10/18/87
 *	By:			bnb
 *	Reason:			inline cleanups...
 */



#define _OBJECT_C

#include "presto.h"

void
Object::error(char *s)
{
	cerr << "ERROR: " << s << "\nin Object ";
	this->print(cerr);
	fatalerror();
}

	   
void
Object::print(ostream& s)
{
	s << form("this = 0x%x, o_name = %10s, o_type = %3d, o_next = 0x%x",
		this, o_name, o_type, o_next);
}
	
ostream& operator<<(ostream& s, Object* o)
{
	if (o)
		o->print(s);
	else
		s << "nil";
	return s;
}


Oqueue::Oqueue(Object *head)
{
	if (head)	{
		head->o_next = 0;
	}
	oq_head = head;
	oq_tail = head;
}


void
Oqueue::print(ostream& s)
{
	Object*	o = oq_head;
	while (o)	{
		s << form("--> 0x%x [0x%x] -", o, o->o_next);
		o = o->o_next;
	}
}


