/*
 *	misc.c
 *
 * 	General mishmash that doesn't belong anywhere else
 *	- fatalerror()		-- abort and die horribly
 *	- overloaded new and delete
 */ 

#define _MISC_C

#include <stream.h>
#include <osfcn.h>
#include "presto.h"

void
error(char *s)
{
	cerr << s << "\n";
	fatalerror();
}

void
fatalerror()
{
	cerr << "Aborting....\n";
	cout.flush();
	cerr.flush();
	abort();
}

//
// We have to redefine the new and delete functions so they malloc
// in shared memory.
//

typedef void (*PFVV)();

extern PFVV _new_handler;

typedef char*	(*PFUC)(unsigned);		// for malloc
typedef void	(*PFVC)(char*);			// for free

extern char* malloc(unsigned);
extern void  free(char*);

//
// The memory allocator should be called "malloc" in all
// Presto versions.  That prevents the c-library malloc from being
// linked in and called accidentally.  A call to the c-library
// malloc will cause Topaz Presto to get blown out of the water.
//
#define MALLOC(x)		malloc(x)
#define FREE(x)			free(x)
PFUC	mallocf = malloc;
PFVC	freef = free;

extern void* operator new(long size)
{
	char* p;

	while ( (p=MALLOC(unsigned(size)))==0 ) {
		if(_new_handler)
			(*_new_handler)();
		else	
			return 0;
	}
	return (void*)p;
}


extern void operator delete(void* p)
{
	if (p) FREE( (char*)p );
}

//
// Dangerous: If you do a set_{malloc/free}_agent from shared to non-shared
// or the other way around, anything which has been malloced in one
// form might get demalloced in another.  Of course, the classes
// can remember this for themselves and make sure to set the
// types correctly.

PFUC
set_malloc_agent(PFUC nmalloc)
{
	PFUC omalloc = mallocf;

	mallocf = nmalloc;
	return omalloc;
}

PFVC
set_free_agents(PFVC nfree)
{
	PFVC ofree = freef;
	freef = nfree;
	return ofree;
}

void failed_malloc()
{
	cerr << "operator new failed: out of store\n";
	fatalerror();
}

void
thisthread_holdingspinlock()
{
	thisthread->holdingspinlock();
}

void
thisthread_releasingspinlock()
{
	thisthread->releasingspinlock();
}


#ifdef sun
int cpus_online() { return 1; }
char* shmalloc(long s) { return malloc(s); }
void shfree(char* x) { free(x); }
#endif sun

#ifdef vax

int
cpus_online()
{
	return 1;
}

char*
shmalloc(long s)
{
	return malloc(s);
}

void
shfree(char* x)
{
	free(x);
}

#endif vax
