

#ifndef _LOCKS_H


#define _LOCKS_H
//
// Locks and monitors
//

class Lock : public SynchroObject	{
	Thread	*lo_owner;
	void	lock2();			// looping lock
public:
	Lock(char *name=0);
	Lock(char *name, int locktype);
	~Lock();
	void lock();		// no competition
	void unlock();
	Thread *owner()
		{ return  lo_owner; }
	virtual void print(ostream& = cout);
};

class Monitor : public Lock 		{
public:
	Monitor(char* name=0);
	~Monitor();
	inline void entry()
		{ Lock::lock(); }
	inline void exit()
		{ Lock::unlock(); }
	Thread *owner()
		{ return Lock::owner(); }
	virtual void print(ostream& = cout);
};

//
// Syntactic sugaring for automatically releasing monitors on
// subroutine exit.  Should only be built on the stack.
//
class MONITOR	{
	Monitor *mo_mon;
public:
	MONITOR(Monitor *m)
		{ mo_mon = m; m->entry(); }
	inline MONITOR(Monitor& m)
		{ mo_mon = &m; m.entry(); }
	inline ~MONITOR()
		{ register Monitor* m = mo_mon; m->exit(); }
};



class MonitorQ : public Oqueue	{
public:
	MonitorQ(Monitor* m = 0) : ( m )
		{;}
	~MonitorQ()
		{ cerr << "monitorq destructor called\n"; }
	Monitor*	get()
		{ return (Monitor*)Oqueue::get(); }
	Monitor*	lookat()
		{ return (Monitor*)Oqueue::lookat(); }
	void		append(Monitor *m)
		{ Oqueue::append(m); }
	void		prepend(Monitor *m)
		{ Oqueue::prepend(m); }
	void		remove(Monitor *m)
		{ Oqueue::remove(m); }
};


class Condition : public SynchroObject	{
	Monitor*	co_monitor;		// bound monitor
public:
	Condition(char* name=0);	// unbound
	Condition(Monitor* boundmon);	// bound, no name
	Condition(Monitor& boundmon);
	Condition(Monitor* boundmon, char* name);
	Condition(Monitor& boundmon, char* name);
	Monitor* monitor()
		{ return co_monitor; }
	int threadok()				// is cond user legit
		{ return ((!co_monitor) || 	// unbound is free4all
			 (thisthread == co_monitor->owner()));}  
	~Condition();
	void signal();			// wakeup one
	void broadcast();		// wakeup all
	void wait();			// wait for signal (could pickup old)
	virtual void print(ostream& = cout);
};





#endif _LOCKS_H
