//
// Atomic ints are good for counters, etc...  All integer operations
// on them are defined.
//
//


//
// Binary op
//
//
// return the value at the time of the lock
// acquisition
//
#define AIOP(op)\
	int operator/**/op/**/(int x)	\
	{register int tmp;ai_lock.lock();tmp = ai_val op x;ai_lock.unlock();return tmp;}

// 
// Unary op
//
#define AIUNOP(op)\
	int operator/**/op/**/()	\
	{register int tmp;ai_lock.lock();tmp = ai_val/**/op;ai_lock.unlock();return tmp;}




class AtomicInt	{
	int 		ai_val;
	Spinlock	ai_lock;
public:
	AtomicInt()
		{ ai_val = 0; }
	AtomicInt(int x)
		{ ai_val = x; }
	AtomicInt(AtomicInt& x)		// should we lock x?
		{ ai_val = x.ai_val;}
	~AtomicInt()
		{ ai_lock.unlock(); }
	operator int()
		{ return ai_val; }	// we should probably get locked
	void lock()
		{ ai_lock.lock(); }	// Careful....
	void unlock()
		{ ai_lock.unlock(); }
	int&	val()			// use at your own risk
		{ return ai_val; }
	AIOP(=)
	AIOP(+=)
	AIOP(*=)
	AIOP(/=)	
	AIOP(%=)
	AIOP(^=)
	AIOP(&=)
	AIOP(|=)
	AIOP(<<=)
	AIOP(>>=)
	AIUNOP(++)		/* pre inc only */
	AIUNOP(--)		/* post inc only */
	int	preinc()
		{register int tmp; ai_lock.lock();
		 tmp = ++ai_val; ai_lock.unlock(); return tmp;}
	int	postinc()
		{register int tmp; ai_lock.lock();
		 tmp = ai_val++; ai_lock.unlock(); return tmp;}
	int	predec()
		{register int tmp; ai_lock.lock();
		 tmp = --ai_val; ai_lock.unlock(); return tmp;}
	int	postdec()
		{register int tmp; ai_lock.lock();
		 tmp = ai_val--; ai_lock.unlock(); return tmp;}		 
	// Should probably have the rest of the operators here too...
};

