/*
 * id.c -- system V id(1) lookalike for SunOS
 *
 * Author: Jyrki Kuoppala (jkp@hutcs.hut.fi)
 *
 * This program is in the public domain
 *
 * Created: Tue Aug 23 01:27:44 1988
 * Last modified: Tue Aug 23 21:25:43 1988
 */

#include <ctype.h>
#include <sys/types.h>
#include <grp.h>
#include <stdio.h>
#include <pwd.h>

#ifdef SUNOS
typedef int uid_t;
typedef int gid_t;
#endif /* SUNOS */

struct passwd *getpwuid();
struct group *getgrent();

extern uid_t getuid();
extern gid_t getgid();

int
main()
{
     uid_t uid, euid;
     gid_t gid, egid;
     struct passwd *p;
     struct group *g;

     uid = getuid ();
     euid = geteuid ();
     gid = getgid ();
     egid = getegid ();
     
     (void) printf ("uid=%d", uid);
     if (p = getpwuid ((int) uid))
	  (void) printf ("(%s)", p->pw_name);

     (void) printf (" gid=%d", gid);
     if (g = getgrgid ((int) gid))
	  (void) printf ("(%s)", g->gr_name);

     if (euid != uid) {
	  (void) printf (" euid=%d", euid);
	  if (p = getpwuid ((int) euid))
	       (void) printf ("(%s)", p->pw_name);
     }
     if (egid != gid) {
	  (void) printf (" egid=%d", egid);
	  if (g = getgrgid ((int) egid))
	       (void) printf ("(%s)", g->gr_name);
     }
     (void) printf ("\n");
     return (0);
}
