/* File: /u1/oystr/HRPC/HRpcRTS/tcpTransp.c  Date:  5-Mar-1986  */

/*
 * $Header$
 * INTERFACE:	Dummy interface for now
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * $Log$
 *
 * Revision 1.1  87/08/20  ??:??:?? mss
 * Changes for lightweight process support.
 *
 *  5-Mar-1986:	Initial implementation, Jan Sanislo
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
/* #include <sys/time.h> */
#include <errno.h>
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <HRPC/hrpcErrCodes.h>
#include <HRPC/LWP/kEvents.h>
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include "../Transports/connDefs.h"
#include <sys/ioctl.h>
#define TCPMAXBUFFERSIZE 1020

extern int AllocateBuffer();
extern int DeallocateBuffer();
extern int errno;

int TcpMaxBufferSize( fBptr )
    HRPCBinding *fBptr;
{
    return( TCPMAXBUFFERSIZE );
}

/*
 * Create a TCP socket for ourselves and
 * attempt connection to remote entity.
 * Close only via associated socket file descriptor.
 */
int TcpOpenLink( fBptr )
    HRPCBinding *fBptr;
{
    struct sockaddr_in myAddr;
    struct sockaddr_in *destAddr;
    register TransControl *tcptr;
    register ConnDescr *connptr;
    int spktyp = (int) fBptr->speaking;
    STMconnDescr *stmconnptr = &STMconnStates[spktyp];
    HRPCBinding *STMfBptr;
    extern void setConnReadProc();
    extern int HRPC_AddToREADFDS();
    extern int HRPC_SetSocketAsync();
    extern int HRPC_SetSocketNdelay();
    extern int HRPC_LWPcreateSTM();
    lwpPROCESS STMpid;
    int sigsheldprevious;
    
    destAddr = (struct sockaddr_in *) &(fBptr->transDescr.netAddr);
    if ( (destAddr->sin_family != AF_INET) ||
	 (destAddr->sin_addr.s_addr == 0)  ||
	 (destAddr->sin_port <= 0) )
	fatalerr("TcpOpenLink: netAddr not initialized.\n");

    tcptr = &(fBptr->transDescr);

    /*
     * check state.
     */
    if ( tcptr->sockfd > 0 ) {
	/* already open so return */
	/* tcptr->packetArrived = 0; */
	return;
    }
    
    /*
     * Create connection -
     * make socket and create SpeakTypeMgr
     */
    tcptr->sockfd = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
    if ( tcptr->sockfd < 0 )
	fatalperr("TcpOpenLink: create socket.\n");

    /* connect to remote */
    if ( connect(tcptr->sockfd, destAddr, sizeof(struct sockaddr_in) ) < 0 ) {
	errmsg("TcpOpenLink: can't connect to remote: x%08x.%d\n",
		   destAddr->sin_addr.s_addr,ntohs(destAddr->sin_port));
	tcptr->sockfd = 0;
	/* what about deleting STM ??? */
	longjmp(fBptr->unwindTo,
		NewHRPCErrRec(HRPC_NOSERVER, 0) );
    }

    if ( HRPC_lwpType != SingleThread ) {
	HRPC_SetSocketAsync(tcptr->sockfd,0);
	if ( stmconnptr->connCount == 0 ) {
	    HRPC_LWPcreateSTM(fBptr, &STMfBptr, &STMpid);
	}
        HRPC_SetSocketNdelay(tcptr->sockfd);
    }

    connptr = &connStates[tcptr->sockfd];
    fBptr->connState = CONN_IDLE;
    tcptr->packetArrived = 0;
    DISABLE_SignalHandler
    connptr->masterfd = connptr->connfd = tcptr->sockfd;
    connptr->connbptr = fBptr;
    setConnReadProc(tcptr->sockfd,fBptr);
    connptr->connCount = 1;
    ENABLE_SignalHandler
    connptr->selmask = (1 << tcptr->sockfd);
    if ( HRPC_lwpType != SingleThread ) {
	if ( stmconnptr->connCount == 0 ) {
	    stmconnptr->STMpid = STMpid;
		/* sanity checks */
	    if ( stmconnptr->BindingQ != (struct BindingQelement *) 0 ) {
		printf("TcpOpenLink: warning non-empty BindingQ\n");
	        stmconnptr->BindingQ = (struct BindingQelement *) 0;
	    }
	    DISABLE_SignalHandler
	    if ( stmconnptr->BufferQ != (struct BufferQelement *) 0 ) {
		printf("TcpOpenLink: warning non-empty BufferQ\n");
	        stmconnptr->BufferQ = (struct BufferQelement *) 0;
	    }
	    if ( stmconnptr->TaskQ != (struct PacketQelement *) 0 ) {
		printf("TcpOpenLink: warning non-empty TaskQ\n");
	        stmconnptr->TaskQ = (struct PacketQelement *) 0;
	    }
	    stmconnptr->BufferQsize = 0;
	    stmconnptr->STMbptr = STMfBptr;
	    ENABLE_SignalHandler
	}
	DISABLE_SignalHandler
	HRPC_AddToREADFDS(tcptr->sockfd);
	(stmconnptr->connCount)++;
	ENABLE_SignalHandler
    } else {
	DISABLE_SignalHandler
	if ( stmconnptr->connCount == 0 ) {
		/* sanity check */
	    if ( stmconnptr->BufferQ != (struct BufferQelement *) 0 ) {
                printf("TcpOpenLink: warning non-empty BufferQ\n");
	        stmconnptr->BufferQ = (struct BufferQelement *) 0;
	    }
	    stmconnptr->BufferQsize = 0;
            stmconnptr->STMbptr = fBptr;
	}
	(stmconnptr->connCount)++;
        ENABLE_SignalHandler
    }
}

TcpCloseLink( fBptr )
    HRPCBinding *fBptr;
{
    register struct sockaddr_in *destAddr;
    register TransControl *tcptr;
    register ConnDescr *connptr;
    int		ConnStateFD, sigsheldprevious;
    extern struct BindingQelement *CleanUpBindingQ();
    
    /* Make sure it is actually open */
    destAddr = (struct sockaddr_in *) (&fBptr->transDescr.netAddr);
    tcptr = &fBptr->transDescr;
    if ( (destAddr->sin_port == 0) || (tcptr->sockfd == 0) ) {
	/* fatalerr("TcpCloseLink: link not open.\n"); */
	return;
    }

    connptr = &connStates[tcptr->sockfd];
    DISABLE_SignalHandler
    --(connptr->connCount);
    ENABLE_SignalHandler
    if ( connptr->connCount > 0 ) {
		/* connection still in use */
	DISABLE_SignalHandler
        --(STMconnStates[(int)fBptr->speaking].connCount);
	ENABLE_SignalHandler
	CleanUpBindingQ(fBptr,1);
	destAddr->sin_port = destAddr->sin_addr.s_addr = 0;
	fBptr->connState = CONN_CLOSED;
        tcptr->packetArrived = 0;
	tcptr->sockfd = 0;
	DeallocateBuffer( fBptr );
        return;
    }
    ConnStateFD = tcptr->sockfd;
    
    DISABLE_SignalHandler
    if ( close( tcptr->sockfd ) < 0 ) {
	/* fatalperr("TcpCloseLink: cannot close link.\n"); */
	errmsg("TcpCloseLink: cannot close link, errno: %d.\n",errno);
	errmsg("   sockfd is: %d.\n",tcptr->sockfd);
    }
    if ( HRPC_lwpType != SingleThread ) HRPC_RmFromREADFDS(ConnStateFD);
    ENABLE_SignalHandler

    destAddr->sin_port = destAddr->sin_addr.s_addr = 0;
    HRPC_LWPcloseSocket(fBptr, ConnStateFD);
}

/*
 * Actually send a segment over the link to whatever
 * is on the other side.
 *		>>>> WARNING <<<<
 * No record marking of the stream is done here.  This
 * is the province of the higher level RPC protocol.
 * Arguably, it would be more efficient to do it here.
 */
int TcpSendPacket( fBptr )
    register HRPCBinding *fBptr;
{
    register int cnt, sent, nbytes;
    register memory buf;
    ConnDescr *currConn;
    int sigsheldprevious;
    nbytes = (int) (fBptr->maxBufSize - fBptr->curBufSize);
    buf = fBptr->currentBuffer;

    /* Must be loop due to possible interrupts of "slow" write */
    for ( cnt = nbytes; cnt > 0; cnt -= sent, buf += sent ) {
	if ( (sent = write(fBptr->transDescr.sockfd, buf, cnt)) < 0 ) {
	    HRPCErrRec *errRec;

	    errmsg("TcpSendPacket: can't send, sockfd: %d, errno: %d\n",
		   fBptr->transDescr.sockfd, errno);
	    errRec = NewHRPCErrRec(
			 (errno == EPIPE ) ? HRPC_PEERDIED : errno,
			 0);
	    /*
	     * Assume everything describing this connection is
	     * stone bogus.  The guy on the other end of this
	     * longjmp had better take a hint.  It is arguable
	     * whether we should tidy up here since value of sockfd
	     * maybe pure garbage -- in that case, hope for core dump
	     * and more info.
	     */
	    currConn = &connStates[fBptr->transDescr.sockfd];
	    DISABLE_SignalHandler
	    currConn->connCount = 0;
	    if ( HRPC_lwpType != SingleThread ) {
		(STMconnStates[(int)fBptr->speaking].connCount)--;
		HRPC_RmFromREADFDS(fBptr->transDescr.sockfd);
	    }
	    ENABLE_SignalHandler
	    close(fBptr->transDescr.sockfd);
	    connStates[currConn->masterfd].selmask
			&= ~(1 << fBptr->transDescr.sockfd);
	    DeallocateBuffer( fBptr );
	    fBptr->transDescr.sockfd = 0;
	    /*
	     * Just for grins...
	     */
#ifdef sun
#define PC 0
#endif
#ifdef vax
#define PC 4
#endif
#ifdef ibm032
#define PC 10
#endif
/*
	    errmsg("  Longjmp to pc: %08x.\n", ((int *)fBptr->unwindTo)[PC]);
 */
#undef PC
	    longjmp( fBptr->unwindTo, errRec );
	}
    }
    /* reset buffer info */
    fBptr->curBufMark = fBptr->currentBuffer;
    fBptr->curBufSize = fBptr->maxBufSize;
}

/*
 * Try to receive a chunk of data.  Timeout period is
 * wired to SUN default.  This is where NOT implementing
 * record marking at this level really hurts us.  The
 * higher level routines will really get themselves in a knot.
 *
 * Return values:
 *	 1: packet received
 *	 0: time out
 *	-1: other error
 *
 * Unwarranted assumptions:
 *   The memory buffer in the binding is "free".
 */

int TcpRecvPacket( fBptr )
    register HRPCBinding *fBptr;
{
    struct timeval tmo;
    int readmask, readables;
    int selectStatus, readStatus, sigsheldprevious;
    char *ME = "TcpRecvPacket:";
    register ConnDescr *currConn;
    struct BindingQIdTableEntry idTable[BindingQIdTableMax];
    extern int	AddToBindingQ();
    readmask = 1 << fBptr->transDescr.sockfd;
    tmo.tv_sec  = 30;
    tmo.tv_usec = 0;

loop:
    readables = readmask;
    if ( HRPC_lwpType != SingleThread ) {
	/* construct BindingQelement & add to connStates[fd].BindingQ */
	    /* first, set IdTable */
	/* nothing needs to be set for TCPTRANSP since dedicated connection */
	AddToBindingQ(fBptr,idTable,0,0);
    }
    (*HRPC_lwpDescr.SelectAndReadPacket)(fBptr, &tmo, &readables,
						&selectStatus, &readStatus);
    if ( selectStatus < 0 ) {
	    /* should not happen in env with multiple threads */
	if ( errno == EINTR ) goto loop;
	else
	    fatalperr("%s select error.\n",ME);
    }
    if ( selectStatus == 0 ) return( HRPC_REPLYTMO ) /* timed out */;
    
	/* check status of read */
    if ( readStatus <= 0 ) {
	/* connection closed */
	currConn = &connStates[fBptr->transDescr.sockfd];
	DISABLE_SignalHandler
	currConn->connCount = 0;
	if ( HRPC_lwpType != SingleThread ) {
	    (STMconnStates[(int)fBptr->speaking].connCount)--;
	    HRPC_RmFromREADFDS(fBptr->transDescr.sockfd);
	}
	ENABLE_SignalHandler
	connStates[currConn->masterfd].selmask &= ~(1<<fBptr->transDescr.sockfd);
	close(fBptr->transDescr.sockfd);
	fBptr->transDescr.sockfd = currConn->masterfd;
	longjmp( fBptr->unwindTo,
		NewHRPCErrRec(HRPC_PEERDIED,0) );
    }
    
    return( 0 );
}

/*
 * Low-level buffer allocation/deallocation routines.
 */
memory TcpBufAlloc()
{
    memory newmem;

    newmem = (memory) malloc(TCPMAXBUFFERSIZE);
    if ( newmem == (memory) 0 ) {
	fatalerr("TcpBufAlloc: no memory.\n");
    }

    return( newmem );
}

TcpBufDealloc( buffer )
    memory buffer;
{
    if ( (int) buffer > 0 )
	free( buffer );
    else
	fatalerr("TcpBufDealloc: bad buffer.\n");
}

/*
 * These routines should be split into their own file.
 * No sense loading these up if we don't need them.
 * They are called exclusively by RPC protocol routines.
 */

/*ARGSUSED*/
static sigPipeIgn;

int TcpInitSend( fBptr, fDirec )
    HRPCBinding *fBptr;
    int fDirec;
{
    fBptr->connState = fDirec;

    if ( !sigPipeIgn ) {
	signal(13, 1);
	++sigPipeIgn;
    }
}

/*ARGSUSED*/
int TcpFinishSend( fBptr, fDirec )
    register HRPCBinding *fBptr;
    register int fDirec;
{
    int i;

    fBptr->connState = fDirec;

    TcpSendPacket( fBptr );

    if ( fDirec != CONN_SRVREPLY ) return;
    
    /*
     * Replace current socket in binding we are using
     * with the masterfd.
     */
    i = fBptr->transDescr.sockfd;
    fBptr->transDescr.sockfd = connStates[i].masterfd;
}

/*ARGSUSED*/
int TcpInitRecv( fBptr, fDirec )
    HRPCBinding *fBptr;
    int fDirec;
{
    int j, newfd;
    register ConnDescr *curConn;
    register ConnDescr *newConn;
    register TransControl *tcptr = &(fBptr->transDescr);
    struct sockaddr replyAddr;
    char *ME = "TcpInitRecv";
    extern int	HRPC_AddToREADFDS();
    extern int	HRPC_RmFromREADFDS();
    int		sigsheldprevious;

    fBptr->connState = fDirec;

    AllocateBuffer( fBptr );

    curConn = &connStates[tcptr->sockfd];
    if ( (curConn->masterfd != tcptr->sockfd) || (fDirec == CONN_WREPLY) ) {
	DISABLE_SignalHandler
	curConn->connfd = 0;
	ENABLE_SignalHandler
	return( TcpRecvPacket( fBptr ) );
    }
    
    if ( HRPC_lwpType == SingleThread ) {
        /*
         * Assume new connection, do accept
         */
        j = sizeof( struct sockaddr );
        newfd = accept( curConn->masterfd, &replyAddr, &j );
        if ( newfd < 0 ) {
	    fatalperr("TcpInitRecv: can't do accept");
	    /*NOTREACHED*/
        }

        /*
         * Make a copy of the master connection
         * descriptor in the new connection.
         */
        newConn = &connStates[newfd];
        /* STRUCTURE ASSIGNMENT NEXT TWO LINES */
        *newConn = *curConn;
        tcptr->replyTo = replyAddr;
        curConn->selmask |= (1 << newfd);
        newConn->connCount = 1;
        newConn->connfd = newfd;
    } else {
	/*
	 * Assume new connection; accept was done in TcpReadProc
	 */
	newfd = tcptr->tmp_sockfd;
	if ( newfd < 0 ) {
	    fatalerr("TcpInitRecv: bad new connection");
	    /*NOTREACHED*/
	}
    }

    /*
     * Set up to read from new connection and then
     * force signal handler to run in case packet already arrived
     */
    tcptr->packetArrived = 0;
    tcptr->sockfd = newfd;
    if ( HRPC_lwpType != SingleThread ) {
	DISABLE_SignalHandler
        HRPC_SignalHandler(0);
	ENABLE_SignalHandler
    }

    /*
     * Grab a packet.
     */
    return( TcpRecvPacket( fBptr ) );
}

/*ARGSUSED*/
int TcpFinishRecv( fBptr,  fDirec )
    register HRPCBinding *fBptr;
    int fDirec;
{
}
