/* File: /u1/oystr/HRPC/Transports/ReadProcs.c  Date:  4-Sep-1987  */

/*
 * $Header$
 * These procedures implement reading a single packet from a file descriptor,
 * for each of the transport types.  The code was stolen from other HRPC
 * routines.
 *
 * $Log$
 *
 *  4-Sep-1987: Initial implementation, Mark Squillante
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <errno.h>
#include <HRPC/basicRpc.h>
#include "../Transports/connDefs.h"
#include <HRPC/LWP/kEvents.h>
#include <HRPC/LWP/LWPtypes.h>

extern int      errno;
extern int	UdpMaxBufferSize();
extern int	TcpMaxBufferSize();
 
#include "../HRpcRTS/sysSpecific.h"
#ifdef HAS_XNS43
#include <netns/ns.h>
#include <netns/sp.h>
#include <HRPC/CCS.h>
extern int	SPPMaxBufferSize();

int
SPPReadProc(fd,bufptr,bufmark,notUsed)
    int			fd;
    memory		bufptr, *bufmark;
    struct sockaddr	*notUsed;
{
	int	byteCnt;
	HRPCBinding		*temptr = connStates[fd].connbptr;

	byteCnt = read(fd, bufptr, sizeof(struct sphdr) + SPPMaxBufferSize(temptr));
	*bufmark = bufptr + sizeof(struct sphdr);
	if ( byteCnt <= 0 )
	    return( byteCnt );
	else
	    return( byteCnt - sizeof(struct sphdr) );
}
#endif HAS_XNS43

int
UdpReadProc(fd,bufptr,bufmark,sourceAddr)
    int			fd;
    memory		bufptr, *bufmark;
    struct sockaddr	*sourceAddr;
{
	struct sockaddr		from;
	int			fromlen, byteCnt;
	HRPCBinding		*temptr = connStates[fd].connbptr;

	fromlen = sizeof(struct sockaddr);
	byteCnt = recvfrom(fd, bufptr, UdpMaxBufferSize(temptr), 0,
					&from, &fromlen);
	*bufmark = bufptr;
		/* struct assignment follows */
	*sourceAddr = from;
	return(byteCnt);
}

int
TcpReadProc(fd,bufptr,bufmark,from)
    int			fd;
    memory		bufptr, *bufmark;
    struct sockaddr	*from;
{
	int			byteCnt, j, newfd;
	int			sigsheldprevious;
	ConnDescr		*curConn;
	ConnDescr		*newConn;
	struct sockaddr		replyAddr;
	HRPCBinding		*temptr = connStates[fd].connbptr;
	extern int		HRPC_AddToREADFDS();

	curConn = &connStates[fd];
	if ( curConn->masterfd == curConn->connfd  &&
			temptr->connState != CONN_WREPLY ) {
	    if ( HRPC_lwpType == SingleThread ) {
		    /* don't read from masterfds */
		byteCnt = CONN_CNTLPACK;
	    } else {
	        /*
	         * Assume new connection, do accept
	         */
	        j = sizeof( struct sockaddr );
	        newfd = accept( fd, &replyAddr, &j );
	        if ( newfd < 0 ) {
		    fatalperr("TcpReadProc: can't do accept");
		    /*NOTREACHED*/
	        }
	        /*
	         * Make a copy of the master connection
	         * descriptor in the new connection.
	         */
	        newConn = &connStates[newfd];
	        DISABLE_SignalHandler
		    /* struct assignment follows */
	        *newConn = *curConn;
	        ENABLE_SignalHandler
	        curConn->selmask |= (1 << newfd);
		HRPC_SetSocketAsync(newfd,1);
	        DISABLE_SignalHandler
	        newConn->connCount = 1;
		HRPC_AddToREADFDS(newfd);
		(STMconnStates[(int)temptr->speaking].connCount)++;
	        newConn->connfd = newfd;
	        ENABLE_SignalHandler
	        byteCnt = CONN_CNTLPACK - newfd;
		    /* struct assignment follows */
	        *from = replyAddr;
	    }
	} else {
	    byteCnt = read(fd, bufptr, TcpMaxBufferSize(temptr));
	}
	*bufmark = bufptr;
	return(byteCnt);
}

void
setConnReadProc(fd,fBptr)
    int		fd;
    HRPCBinding	*fBptr;
{
	switch (fBptr->transType) {
	    case TCPTRANSP:
		connStates[fd].ReadProc = TcpReadProc;
		break;
	    case UDPTRANSP:
		connStates[fd].ReadProc = UdpReadProc;
		break;
	    case XNSTRANSP:
#ifdef HAS_XNS43
		connStates[fd].ReadProc = SPPReadProc;
#else
		fatalerr("setConnReadProc: SPPReadProc undefined\n");
#endif HAS_XNS43
		break;
	}
}
