
/****************************************************************
 * Client for remote users operation.				*
 ****************************************************************/

#include "/u1/mss/LWP/HRPC/LWP/lwp.h"
#include <HRPC/basicRpc.h>
#include "RemoteUsers.h"
#include <stdio.h>

RemoteUsers_UserList results;

main( argc, argv )
    int  argc;
    char *argv[];
{
	int	xwho();
	int	i, j, count;
	char	*cptr, name[20];
	PROCESS	pid[10], mypid; 

	setbuf(stdout,NULL);
	i = LWP_InitializeProcessSupport(3,&mypid);
	if ( i != LWP_SUCCESS ) {
		printf("\terror initializing support: code=%d\n",i);
		exit(1);
	}
	if ( argc <= 1 )
		count = 1;
	else
		count = atoi(argv[1]);

	printf("create processes\n");
	for ( i = 0; i < count; i++ ) {
		sprintf(name,"xwho%d",i);
		j = LWP_CreateProcess(xwho,16384,LWP_NORMAL_PRIORITY,0,name,&(pid[i]));
		if ( j != LWP_SUCCESS ) {
			printf("\terror starting up process %d: code=%d\n",i,j);
			exit(1);
		}
	}
	pid[count] = 0;

	cptr = (char *) pid;
	LWP_MwaitProcess(count,cptr);

	LWP_TerminateProcessSupport();
}

int
xwho()
{
    HRPCBinding *bptr = (HRPCBinding *) NULL;
    char machine[80];
    char oldmachine[80];
    char linebuf[80];
    int i, j;
    register RemoteUsers_User *rp;
    register RemoteUsers_User *rp2;
	char	*name;
    PROCESS mypid;
    
    strcpy(oldmachine,"Big piece of junk");
    mypid = LWP_ActiveProcess;
    name = mypid->name;

    while ( 1 ) {
	printf("%s: machine? ",name);
	gets(linebuf);
	sscanf(linebuf,"%s",machine);
	if ( !strcmp(machine,"quit") ) break;
	if ( strcmp(machine,oldmachine) ) {
	    strcpy(oldmachine,machine);
	    printf("%s: Importing another remote interface..\n",name);
	    /*bptr = (HRPCBinding *) */ RemoteUsers_Import(oldmachine, &bptr);
	}
	results.sequence = (RemoteUsers_User *) 0;
	RemoteUsers_Who( bptr, &results );
	rp = results.sequence;
	printf("%s: results of remote who\n",name);
	for ( i = 0; i < results.length; i++ ) {
	    printf("%s\t\t%s\n",rp->UsersFullName, rp->OtherInfo);
	    free( rp->UsersFullName );
	    free( rp->OtherInfo );
	    rp++;
	}
	free( results.sequence );
	LWP_DispatchProcess();
    }
    if (bptr != (HRPCBinding *) NULL)
        CloseHRPCBinding(bptr);
    j  = LWP_SignalProcess((char *)mypid);
	if ( j != LWP_SUCCESS )
		printf("%s: error signalling: code=%d\n",name,j);
}

