#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

struct  sockaddr_in MySocket = { AF_INET };

#define MSGSIZE 60

main(argc, argv)
int argc;
char **argv;
{
        int s;
        char HostName[100];
        struct hostent *hp;
	static struct sockaddr_in from = {0};
        int fromlen = sizeof (from);
	char IncomingMsg[MSGSIZE], OutgoingMsg[MSGSIZE], *mp;
	int useTCP = 1;

        if (argc < 3) {
                printf("Usage: %s <-t/-u> portnum [host]\n", argv[0]);
                exit(1);
        }

	if (strcmp(argv[1], "-u") == 0)
		useTCP = 0;

	mp = OutgoingMsg;
	*((short *)(mp)) = htons(1234);		/* "INTEGER" part */
	mp += sizeof(short);
	*((long *)(mp)) = htonl(234567);	/* long part */
	mp += sizeof(long);
	*((long *)(mp)) = htonl(0);		/* boolean part */
	mp += sizeof(long);
	if (useTCP)
		strcpy(mp, "vanilla TCP client string"); /* string part */
	else
		strcpy(mp, "vanilla UDP client string"); /* string part */
	mp += strlen(mp);

	if (useTCP)
		s = socket(AF_INET, SOCK_STREAM, 0);
	else
		s = socket(AF_INET, SOCK_DGRAM, 0);
        if (s < 0) {
                perror("vanilla client: socket");
                exit(1);
        }

	if (argc == 4)
		strcpy(HostName, argv[3]);
	else {
		if (gethostname(HostName, 100) < 0) {
		    perror("vanilla client: gethostname");
		    exit(1);
		}
	}
        hp = gethostbyname(HostName);
        if (hp == NULL) {
            perror("vanilla client: gethostbyname");
            exit(1);
        }

        bcopy(hp->h_addr, &MySocket.sin_addr, hp->h_length);
        MySocket.sin_port = htons(atoi(argv[2]));
	if (useTCP) {
		if (connect(s, &MySocket, sizeof(MySocket)) == -1) {
			perror("vanilla client: connect");
			exit(1);
		}
        }
	if (sendto(s, OutgoingMsg, sizeof(OutgoingMsg), 0, &MySocket,
		   sizeof(MySocket)) == -1) {
		perror("vanilla client: sendto");
		exit(1);
	}
        if (recvfrom(s, IncomingMsg, sizeof(IncomingMsg), 0, &from,
		     &fromlen) == -1) {
		perror("vanilla client: recvfrom");
		exit(1);
	}
	PrintVanillaMsg("vanilla client received msg", IncomingMsg);
}
