#include "HRPC/basicRpc.h"
#include "ClIF.h"
#define HRPC_SERVER
#include "SrvIF.h"
#include <signal.h>
#include <sys/time.h>

HRPCBinding **meBindings;
SpeakDefs_Speak prefs[3];
Binding_BINDING_DESCR clBD;
HRPCBinding *back2Cl;
HRPCBinding *ready;

#define SRV_PROGNUM 50451
#define SRV_VERSNUM 1
#define SRV_CONNECT 1
#define SRV_DOIT 2
#define SRV_DISCONN 3

#define DEBUG

main(argc, argv)
    int  argc;
    char *argv[];
{
    long prognum, procnum, versnum;
    int status, n1, n2;
    int nexported;
    int expFlags;
    
    HRPCErrRec *errRes;

    /*
     * Export self as a server.
     */
    prefs[0] = SUN_XDR_TCP;
    prefs[1] = INVALID_SPEAK;
    nexported = 1;
    expFlags = 0;
    SrvIF_Export("anonymous", &expFlags, prefs, &nexported, &meBindings);
    printf("ExpFlags: %d, nexported: %d.\n",expFlags,nexported);
    if ( expFlags & EXPF_AUTOACT ) {
	struct timeval tmo;

	tmo.tv_sec  = 30;
	tmo.tv_usec =  0;
	HRPCSetRequestTMO( &tmo, 0 );
    }
    
    /*
     * Run our little hacked up version of a server loop.
     */

    while ( 1 ) {
	HRPCDispatcher( 1, meBindings, &ready );
#ifdef DEBUG
	printf("Server: returned from dispatcher...\n");
#endif
	(*ready->rpcDescr.InitIncoming)(ready,
		&prognum, &versnum, &procnum, &status, 0);
	if ( status ) {
	    printf("Bad status from InitIncoming: %d.\n",status);
	    continue;
	}
#ifdef DEBUG
	printf("Server: got a call for %d/%d/%d\n",
		prognum, versnum, procnum);
#endif
	if ( (prognum != SRV_PROGNUM) || (versnum != SRV_VERSNUM) ) {
	    printf("Wrong call: prog %d, vers %d, proc %d.\n",
		   prognum, versnum, procnum);
	    exit( 1 );
	}

	switch ( procnum ) {
	    case SRV_CONNECT:
		server_SrvIF_Connect( ready );
		ConvBDtoBinding( &clBD, &back2Cl );
		break;

	    case SRV_DOIT:
		/* 
		 * "Exit" server loop and start callback.
		 * Under most circumstances we would check the
		 * opcode.
		 */
		server_SrvIF_Doit( ready );

		/*
		 * Get a couple numbers.
	 	 */
		errRes = ClIF_Ask( back2Cl, "First number? ", &n1 );
		if ( errRes ) {
		    printf(" Ask1: ");
		    HRPCperror( errRes );
		}
		
		ClIF_Ask( back2Cl, "Second number? ", &n2 );
		n2 += n1;
		ClIF_Done( back2Cl, n2, &n1 );
		printf("Client replies with %d.\n",n1);
		break;

	    case SRV_DISCONN:
		server_SrvIF_Disconnect( ready );
		CloseHRPCBinding( back2Cl );
		break;
	}
    }
}

void SrvIF_Connect( fBptr, fBD, fOk )
    HRPCBinding *fBptr;
    Binding_BINDING_DESCR *fBD;
    LongInteger *fOk;
{
    Binding_SUN_XDR_TCP_BINDING_DESCR *bdptr;

    bdptr = &(fBD->data.SUN_XDR_TCP_case);
    printf("Descriptor:\n");
    printf("  Speak: %d, prog: %d, port: %d\n",
	   (int) fBD->data.designator,
	   bdptr->progNum, bdptr->portNum, *(int *)&bdptr->ipAddr);
    clBD = *fBD;
    *fOk = 0;
}

void SrvIF_Doit( fBptr, fOpCode, fReply )
    HRPCBinding *fBptr;
    LongInteger fOpCode;
    LongInteger *fReply;
{
    *fReply = 99;
}

void SrvIF_Disconnect( fBptr, fHandle, fGoodBye )
    HRPCBinding *fBptr;
    LongInteger fHandle;
    LongInteger *fGoodBye;
{
    *fGoodBye = 98;
}
