#define HRPC_SERVER
#include <sys/time.h>
#include <HRPC/basicRpc.h>
#include "remoteAdd.h"
#include <stdio.h>
char directory[100];

main( argc, argv )
    int  argc;
    char *argv[];
{
    SpeakDefs_Speak myPrefs[3];
    HRPCBinding **sBindings;
    int nbindings;
    int autoact = 0;

    if ( argc < 2 ) {
	myPrefs[0] = SUN_XDR_UDP;
	myPrefs[1] = SUN_XDR_TCP;
	nbindings = 2;
    }
    else
    if ( !strcmp(argv[1],"-B") ) {
	myPrefs[0] = SUN_XDR_UDP;
	myPrefs[1] = SUN_XDR_TCP;
	nbindings = 2;
    }
    else {
	if ( !strcmp(argv[1],"-T") ) {
	    myPrefs[0] = SUN_XDR_TCP;
	}
	else {
	    myPrefs[0] = SUN_XDR_UDP;
	}
	nbindings = 1;
    }
    myPrefs[nbindings] = INVALID_SPEAK;
    
    remoteAdd_Export( "Dummy", & autoact, myPrefs, &nbindings, &sBindings );
    printf("returned exp flags: %d.\n",autoact);
    printf("number of bindings: %d.\n",nbindings);
    
    if ( autoact & EXPF_AUTOACT ) {
	struct timeval tmo;

	tmo.tv_sec  = 30;
	tmo.tv_usec =  0;
	HRPCSetRequestTMO( &tmo, 0);
    }

    remoteAdd_Server( nbindings, sBindings );
}

void remoteAdd_Add( fBptr, n1, n2, ans )
    HRPCBinding *fBptr;
    LongInteger n1;
    LongInteger n2;
    LongInteger *ans;
{
#ifdef DEBUG
printf("Add routine called, inputs are %d and %d.\n",n1,n2);
#endif
    *ans = n1 +n2;
#ifdef DEBUG
printf("Answer is %d.\n",*ans);
#endif
}
