%{
#ifndef lint
static char RCSid[] = "$Header: scanner.l,v 2.1 86/11/23 17:29:27 kimi Exp $";
#endif
/*
 * scanner.l -- scanner for the HCS Courier stub generator.
 * 
 * Based on the stub generator developed by J.Q. Johnson, et al,
 * at Cornell Univ.  Major changes made at the UW.
 *
 *		>>>>> WARNING <<<<<
 * The scanner communicates with the compiler as a result of
 * compiler directive processing ("pragmas").
 */

#include "compiler.h"
#include "y.tab.h"
%}
%%
--$			|
----			|
[ \t\n]			/* whitespace */;
"--"			{
			char comment[256];
			char *cp;
			char c;

			/*
			 * Pragma variables (e.g., freeResults) are
			 * declared in compiler.h and used by the
			 * main compiler program.
			 *
			 * The processing is *very* primitive right now.
			 * Can do whatever later.  Pragmas begin with
			 * "--$".  Thanks, Niklaus.
			 *
			 * NB: you have to look at the lex output
			 * (lex.yy.c) to understand why there are
			 * break statements in the following.
			 *
			 */
			cp = comment;
			while ( (c = yyinput()) != '\n' ) {
			    *cp++ = c;
			}
			*cp = '\0';
			
			if ( comment[0] != '$' ) {
			    break;
			}
			if ( strncmp("FreeRes",&comment[1],7) ) {
			    break;
			}
			if ( comment[8] == '-' ) {
			    freeResults = 0;
			}
			else
			if ( comment[8] == '+' )
			    freeResults = 1;
			}
ARRAY			{ return (ARRAY); }
BEGIN			{ return (_BEGIN); }
BOOLEAN			{ return (BOOLEAN); }
CARDINAL		{ return (CARDINAL); }
CHOICE			{ return (CHOICE); }
DEPENDS			{ return (DEPENDS); }
END			{ return (END); }
ERROR			{ return (ERROR); }
FILETYPE		{ return (FILETYPE); }
INTEGER			{ return (INTEGER); }
LISPVAL			{ return (LISPVAL); }
LONG			{ return (LONG); }
OF			{ return (OF); }
PROCEDURE		{ return (PROCEDURE); }
PROGRAM			{ return (PROGRAM); }
RECORD			{ return (RECORD); }
REPORTS			{ return (REPORTS); }
RETURNS			{ return (RETURNS); }
SEQUENCE		{ return (SEQUENCE); }
STRING			{ return (STRING); }
TYPE			{ return (TYPE); }
UNSPECIFIED		{ return (UNSPECIFIED); }
UPON			{ return (UPON); }
USERPROC		{ return (USERPROC); }
VERSION			{ return (VERSION); }
TRUE			{ return (TRUE); }
FALSE			{ return (FALSE); }
"=>"			{ return (_CHOOSES); }
"-"?[0-9]+		{
				/*
				 * decimal constant.
				 */
				yylval.stringvalue = copy(yytext);
				return (number);
			}
"-"?[0-7]+[Bb]		{
				char buf[BUFSIZ];
				/*
				 * octal constant.
				 * change to C representation
				 */
				yytext[yyleng-1] = '\0';
				if (*yytext != '-')
					sprintf(buf,"0%s", yytext);
				else
					sprintf(buf,"-0%s", yytext+1);
				yylval.stringvalue = copy(buf);
				return (number);
			}
"-"?[0-9][0-9A-Fa-f]*[Xx]	{
				char buf[BUFSIZ];
				/*
				 * hex constant.
				 * change to C representation
				 */
				yytext[yyleng-1] = '\0';
				if (*yytext != '-')
					sprintf(buf,"0x%s", yytext);
				else
					sprintf(buf,"-0x%s", yytext+1);
				yylval.stringvalue = copy(buf);
				return (number);
			}
\"[^"\n"]*\"		{
				/*
				 * string constant
				 */
				
				yylval.stringvalue = copy(yytext);
				return (string);
			}
\"([^\n"]|\"\")*\"	{
				register char *p;
				/*
				 * string constant with embedded ""
				 */

				for (p=yytext+1; p<yytext+yyleng-1; p++)
					if (*p == '"') *p++='\\';
				yylval.stringvalue = copy(yytext);
				return (string);
			}
[a-zA-Z_][a-zA-Z0-9_]*	{
				yylval.stringvalue = copy(yytext);
				return (identifier);
			}
(\/|~|"../")[a-zA-Z_][a-zA-Z0-9_\/]*	{
				yylval.stringvalue = copy(yytext);
				return (pathname);
			}
.			{
				return ((int) yytext[0]);
			}

%%
