#include "compiler.h"

/*
 * Following is a terrible hack, but need to define
 * correspondence between SpeakType and program number.
 * Note that there is actually a many to one mapping
 * of SpeakType to program number since e.g. SUN_XDR_UDP
 * and SUN_XDR_TCP will use the same program number.
 */
#define SUN_XDR_TCP 1
#define SUN_XDR_UDP 2
#define COUR_COUR_SPP 3
#define DEC_SRC_UDP 4
#define MIN_SPEAK 1
#define MAX_SPEAK DEC_SRC_UDP+1

char *protoNames[MAX_SPEAK] = {
    "INVALID",
    "SUN_XDR_TCP",
    "SUN_XDR_UDP",
    "COUR_COUR_SPP",
    "DEC_SRC_UDP"
};

/* used mainly by Export routines */
int protoToProgN[MAX_SPEAK];

extern char *CurrentProgram;

doProgDecl( fProto, fNum )
    char *fProto;
    char *fNum;
{
    int pindex;
    
    if ( !strcmp("SUN",fProto) ) {
	pindex = SUN_XDR_TCP;
    }
    else
    if ( !strcmp("COUR",fProto) ) {
	pindex = COUR_COUR_SPP;
    }
    else
    if ( !strcmp("DEC",fProto) ) {
	pindex = DEC_SRC_UDP;
    }
    else {
	error(FATAL,"Unrecognized protocol in header: %s",fProto);
    }
    if ( protoToProgN[pindex] != 0 ) {
	error(FATAL,"Double definition of protocol '%s' program number",
		fProto);
    }
    protoToProgN[pindex] = stringtocard(fNum);
    if (pindex == SUN_XDR_TCP) {
	protoToProgN[SUN_XDR_UDP] = protoToProgN[SUN_XDR_TCP];
    }
}

setprogNumber( fNum )
    char *fNum;
{
    int i,j;
    
    j = stringtocard( fNum );
    for ( i = MIN_SPEAK; i < MAX_SPEAK; i++ ) {
	protoToProgN[i] = j;
    }
}

/*
 * Write out the protocol -> program number
 * mapping to the supplied file.
 */

DumpProgramNumbers( fFile )
    FILE *fFile;
{
    int i, j;

    fprintf(fFile,"LongCardinal %s_ProgN[] = {\n",CurrentProgram);
    for ( i = 0; i < MAX_SPEAK; i++ ) {
	fprintf(fFile,"\t%6d%c /* %s */\n",
		protoToProgN[i],
		(i == (MAX_SPEAK-1)) ? ' ' : ',',
		protoNames[i]);
    }
    fprintf(fFile,"};\n\n");
}


void 
LispProgramNumbers (fFile )

{ int i;

    fprintf (fFile, "(setq %s_ProgN (vectori-long\n", CurrentProgram);
    for (i = 0; i < MAX_SPEAK; i++ ) {
	fprintf(fFile, "\t%6d     ;  %s\n", protoToProgN[i], protoNames[i]);
    };
    fprintf (fFile, ")) \n\n");
};
