#ifndef lint
static char RCSid[] = "$Header: procedures.c,v 3.2 87/05/01 16:00:46 kimi Exp $";
#endif

/* $Log:	procedures.c,v $
 * Revision 3.2  87/05/01  16:00:46  kimi
 * *** empty log message ***
 * 
 * Revision 3.1  87/04/05  17:59:38  kimi
 * as copied from /usr/src/local/HRPC.  new run-time as of 4/87
 * 
 * Revision 1.5  85/05/06  08:13:31  jqj
 * Almost Beta-test version.
 * 
 * Revision 1.4  85/03/26  06:10:21  jqj
 * Revised public alpha-test version, released 26 March 1985
 * 
 * Revision 1.3  85/03/11  16:39:55  jqj
 * Public alpha-test version, released 11 March 1985
 * 
 * Revision 1.2  85/02/21  11:05:39  jqj
 * alpha test version
 * 
 * Revision 1.1  85/02/15  13:55:36  jqj
 * Initial revision
 * 
 */

#define argname(p)	((char *) car(caar(p)))
#define argtype(p)	((struct type *) cdar(p))

/*
 * routines for generating procedures and errors
 */

#include "compiler.h"
#include <HRPC/cCourierTypes.h>
extern int fileDefined;			/* from fileaccess.c */
extern int chkProgNum;			/* from main.c */

int (*server_proc)(),(*client_proc)();  /* assigned in languages.c */
                           /* the procedures themselves are in
                              Cproccode.c for C,
			      Lproccode.c for Lisp */
   
/*
 * Generate client and server functions for procedure declarations.
 */
define_procedure_constant(symbol,typtr,value)
	struct object *symbol;
	struct type *typtr;
	struct constant *value;
{
	struct type *resulttype;
	char *procvalue;
	char * resultname;
	char buf[MAXSTR];
	list p, q;

	if (recursive_flag)	/* don't bother to do anything for procs */
		return;		/* in DEPENDS UPON modules */
	if (typtr->type_constr != C_PROCEDURE)
		error(FATAL, "internal error (define_procedure): not a procedure");
	if (value->cn_constr != C_NUMERIC) {
		error(ERROR,"Values of procedure constants must be numeric");
		procvalue = "-1";
	}
	else
		procvalue = value->cn_value;
	/*
	 * RETURNS stuff:  check for any return params having
	 * "anonymous" types and define them.
	 */
	if (length(typtr->type_results) > 0) {
		for (p = typtr->type_results; p != NIL; p = cdr(p) ) {
		    if (typename(argtype(p)) == NULL ) {
			struct object *name;
			name = make_symbol(gensym("T_r"),CurrentProgram);
			define_type(name,argtype(p), (char *) NULL);
		    }
		}
	}

	/*
	 * REPORTS stuff:  check here to make sure the errors are all defined
	 */
	for (p = typtr->type_errors, q = NIL; p != NIL; q = p, p = cdr(p)) {
		struct object *sym;
		sym = check_def((char *)car(p),CurrentProgram);
		if (sym == (struct object *)0) {
			error(ERROR,"Error constant %s not defined",
				(char*)car(p));
			if (q == NIL) typtr->type_errors = cdr(p);
			else cdr(q) = cdr(p);
		}
		else if (sym->o_class != O_CONSTANT
		    || sym->o_constant->cn_constr != C_ERROR) {
			error(ERROR,"Symbol %s is not of appropriate type",
				name_of(sym));
			if (q == NIL) typtr->type_errors = cdr(p);
			else cdr(q) = cdr(p);
		}
	}
	/*
	 * Argument stuff:  make sure all the argument types are defined
	 */
	for (p = typtr->type_args; p != NIL; p = cdr(p)) {
		if (typename(argtype(p)) == NULL) {
			struct object *name;
			name = make_symbol(gensym("T_p"),CurrentProgram);
			define_type(name,argtype(p),(char *) NULL);
		}
	}
	/*
	 * Actually generate code for this procedure
	 */
	proc_functions(symbol->o_constant->cn_name, typtr, procvalue);
	/*
	 * Save this procedure on the global procs for wrapup (server 
	 * dispatch code)
	 */
	Procedures = cons(cons( (list)symbol->o_constant->cn_name,
				(list)procvalue ),
			  Procedures);
}

/*
 * General purpose procedure to generate a list
 * of arguments.  Note that these require different definitions
 * depending on whether we are in the server or the client.
 */
#define INCLIENT 1
#define INSERVER 0
#define REFPARAMS 1
#define NOREFPARAMS 0
#define INARG  1
#define OUTARG 0

RefStrings( fType, fWhere, fArgType, fPrefix, fInfix )
    struct type *fType;
    int fWhere, fArgType;
    char **fPrefix;
    char **fInfix;
{
    static char *amp = "&";
    static char *arrow = "->";
    static char *dot = ".";
    static char *zip = "";

    *fInfix = zip;
    *fPrefix = zip;
    
    switch ( fType->type_constr ) {
	case C_PROCEDURE:
	case C_NUMERIC:
	case C_BOOLEAN:
	case C_ENUMERATION:
	    if ( fWhere == INCLIENT ) {
		if ( fArgType == INARG ) {
		    *fPrefix = amp;
		}
	    }
	    else {
		*fPrefix = amp;
	    }
	    break;

	case C_STRING:
	    if ( fWhere == INCLIENT ) {
		if ( fArgType == INARG ) {
		    *fPrefix = amp;
		}
	    }
	    else {
		*fPrefix = amp;
	    }
	    break;

	case C_ARRAY:
	    /* zip, zip */
	    break;

	case C_CHOICE:
	case C_SEQUENCE:
	case C_RECORD:
	    if ( fWhere == INCLIENT ) {
		*fInfix = arrow;
	    }
	    else {
		*fInfix = dot;
		*fPrefix = amp;
	    }
	    break;

	default:
	    fprintf(stderr,"RefStr botch: type %d\n",(int)fType->type_constr);
	    exit( 1 );

    } /* end switch */
}
	
GenArgList( fType, fWhere, fFile )
    struct type *fType;
    int fWhere;
    FILE *fFile;
{
    char *argPrefix;
    list p;
    struct type *t;

    /* Input parameter declarations */
    for (p = fType->type_args; p != NIL; p = cdr(p)) {
	t = argtype(p);
	
	if ( (fWhere == INCLIENT) &&
	     (  (t->type_constr == C_RECORD) ||
		(t->type_constr == C_SEQUENCE) ||
		(t->type_constr == C_CHOICE) ) ) {
	    argPrefix = "*";
	}
	else {
	    argPrefix = "";
	}
	

		/* if the typename is __FileUID, then this is not an argument
		   that the user needs to give, but must be recorded
		   and sent over the wire.
		*/
	if (strcmp (typename(t), "__FileUID" )) {
	    fprintf(fFile, "\t%s %s%s;\n", 
	    typename(t), argPrefix, argname(p));
	};
    }

    /* Result parameter declarations */
    if ( fWhere == INCLIENT ) {
	argPrefix = "*";
    }
    else {
	argPrefix = "";
    }
    for (p = fType->type_results; p != NIL; p = cdr(p)) {
	t = argtype(p);
	fprintf(fFile, "\t%s %s%s;\n", typename(t),
		(t->type_constr != C_ARRAY) ? argPrefix : "", argname(p));
    }
}

/*
 * General purpose routine to generate an otw calls for
 * a list of arguments.
 *		>>>>> WARNING <<<<<
 * Requires a lot of work wrt when to generate & and when not to.
 */
OtwArgs( fList, fWhere, fArgType, fFile )
    list fList;
    int  fWhere, fArgType;
    FILE *fFile;
{
    list p;
    struct type *t, *bt;
    char *derefSeq;
    char *prefix, *infix;
    LongCardinal fileUIDvalue;
    
    for ( p = fList; p != NIL; p = cdr(p) ) {
	t = argtype(p);
	RefStrings( t, fWhere, fArgType, &prefix, &infix );
	
	if ( t->type_pfname != (char *) NULL ) {
	    fprintf(fFile,"\t%s(fBinding,%s%s);\n",
		    t->type_pfname, prefix, argname(p));
	}
        else
	if ( t->courBaseType ) {
	    fprintf(fFile,"\t(*otwctl->%s)(fBinding,%s%s);\n",
		    typename(t), prefix, argname(p));
	}
	else
	switch ( t->type_constr ) {

	    case C_ENUMERATION:
		fprintf(fFile,"\t(*otwctl->Enumeration)(fBinding,%s%s);\n",
		        prefix, argname(p));
		break;

	    case C_ARRAY:
		bt = t->type_basetype;
		fprintf(fFile,"\t(*otwctl->Array)(fBinding,%s,",
			argname(p));
		fprintf(fFile,"%d,sizeof(%s),",t->type_size,typename(bt));
		if ( bt->type_pfname != (char *) NULL ) {
		    fprintf(fFile,"%s",bt->type_pfname);
		}
		else
		if ( bt->courBaseType ) {
		    fprintf(fFile,"otwctl->%s",typename(bt));
		}
		else
		if ( bt->type_constr == C_ENUMERATION ) {
		    fprintf(fFile,"otwctl->Enumeration");
		}
		else {
		    fprintf(fFile,"%sOtw",typename(bt));
		}
		fprintf(fFile,");\n");
		break;

	    case C_SEQUENCE:
		fprintf(fFile,
		    "\t(*otwctl->Sequence)(fBinding,");
		bt = t->type_basetype;
		fprintf(fFile,"&%s%ssequence,&%s%slength,%d,sizeof(%s),",
		    argname(p), infix, argname(p), infix,
		    t->type_size, typename(bt));
		if ( bt->type_pfname != (char *) NULL ) {
		    fprintf(fFile,"%s",bt->type_pfname);
		}
		else
		if ( bt->courBaseType ) {
		    fprintf(fFile,"otwctl->%s",typename(bt));
		}
		else
		if ( bt->type_constr == C_ENUMERATION ) {
		    fprintf(fFile,"otwctl->Enumeration");
		}
		else {
		    fprintf(fFile,"%sOtw",typename(bt));
		}
		fprintf(fFile,");\n");
		break;

	   case C_RECORD:
	   case C_CHOICE:
		/*
		 *	 >>>>> WARNING <<<<<
		 * Watch out for '&' in front of records - this assumes
		 * that both input/output record params are passed by
		 * reference.
		 */
	/*	fprintf(fFile,"\t%sOtw(fBinding,&%s);\n",typename(t), */
		fprintf(fFile,"\t%sOtw(fBinding,%s%s);\n",typename(t),
			prefix, argname(p));
		break;


				/* special case for fileUID */
			/* the file type (a number from the TypeRegistry)
			   was put into the u_list by fileprocedures.c.
			   If an argument is named __FileUID, then this typtr is
			   not a user-argument, but rather carries the file
			   type.	*/
	   case C_NUMERIC:
	   	if (streq (typename(t), "__FileUID" /* FullName */)) {
		    fprintf (fFile,"\tfileUIDvalue = %d;\n",
					(LongCardinal)car (t->type_list));

		    fprintf (fFile,"\t(*otwctl->LongCardinal)(fBinding, &fileUIDvalue);\n");
		    break;
		};

		/* if not, fall though to DEFAULT from here!! */
		/* There are no other valid numeric typtrs here */
	   default:
		fprintf(stderr,"OtwArgs botch: %d (%d)\n",(int)t->type_constr);
		exit( 1 );
	}
    }
}

/*
 * Generate functions for client and server calls to a procedure.
 */
proc_functions(proc_name, type, proc_number)
	char *proc_name;
	struct type *type;
	char *proc_number;
{
	list p;
	int nresults, fixed_size, variable_size;
	struct type *t, *bt, *result_type;
	char *result_name, *ref, *rtname;
	char *refPrefix;
	extern char *UpCase();

	/*
	 * Make sure there is at most one result returned.
	 */
	nresults = length(type->type_results);
	rtname = "void";
	/*
	 * Server routine.
	 */

	(*server_proc)( proc_name, proc_number, type, server);


	/*
	 * Stub routine for client.
	 */

	fprintf(header,
"\n#ifndef HRPC_SERVER\n\
extern %s %s();\n\
#else\n\
extern %s %s();\n\
#endif\n\
#define %s %s\n",
		"HRPCErrRec *", proc_name,
		rtname,proc_name, UpCase(proc_name), proc_number);
   	(*client_proc)( proc_name, proc_number, type, client);
};  /* end of proc_functions */



