#ifndef lint
static char RCSid[] = "$Header: misc.c,v 3.1 87/04/05 18:01:17 kimi Exp $";
#endif

/* $Log:	misc.c,v $
 * Revision 3.1  87/04/05  18:01:17  kimi
 * aas copied from /usr/src/local/HRPC.  new run-time as of 4/87
 * 
 * Revision 1.3  85/03/11  16:39:50  jqj
 * Public alpha-test version, released 11 March 1985
 * 
 * Revision 1.2  85/02/21  11:05:34  jqj
 * alpha test version
 * 
 * Revision 1.1  85/02/15  13:55:34  jqj
 * Initial revision
 * 
 */

#include "compiler.h"

/*
 * String allocation.
 */
char *
copy(s)
	char *s;
{
	char *p;
	extern char *malloc();

	if ((p = malloc(strlen(s) + 1)) == NULL) {
		error(FATAL, "out of string space");
	}
	(void) strcpy(p, s);
	return (p);
}


/*
 * like atoi, convert a string to an integer.  Accept
 * 1/ numeric string, e.g. "34"
 * 2/ hex string, e.g. "0x22"
 * 3/ octal string, e.g. "042"
 * Handles only positive integers.
 */
int
stringtocard(str)
	char *str;
{
	int val;

	if (
	    sscanf(str, " -0x%x", &val) > 0 ||
	    sscanf(str, " -0%o", &val) > 0)
		return( -val);
	if (
	    sscanf(str, " 0x%x", &val) > 0 ||
	    sscanf(str, " 0%o", &val) > 0 ||
	    sscanf(str, " %d", &val) > 0 
	   )
		return(val);
	return(0);
}


/*
 * Lisp operations.
 */
list
cons(a, b)
	list a, b;
{
	list p;

	if ((p = New(struct cons)) == NIL) {
		error(FATAL,"Out of list space.");
	}
	car(p) = a;
	cdr(p) = b;
	return (p);
}

length(p)
	list p;
{
	int n;

	for (n = 0; p != NIL; p = cdr(p), n++)
		;
	return (n);
}

list
nconc(p, q)
	list p, q;
{
	list pp;

	pp = p;
	if (p == NIL)
		return (q);
	while (cdr(p) != NIL)
		p = cdr(p);
	cdr(p) = q;
	return (pp);
}

/*
 * Turn upper/lower case in all upper.  Beware
 * of static buffer.
 */
char *UpCase( fString )
    char *fString;
{
    register char *to, *from;
    static char upbuf[100];

    to = upbuf;
    
    for( from = fString; *from; from++ ) {
	if ( (*from >= 'a') && (*from <= 'z') )
	    *to = *from - 32;
	else *to = *from;
	to++;
    }
    *to = '\0';
    return( upbuf );
}
