/* File:  lispcode.c  Date:  May 1, 1987   Kimi Gosney  */

/*
 * INTERFACE:	Lprogram_head_client,Lgenerate_client_binding,
 *              Lref_program_text, Lgenerate_export_routine,
 *     	        Lprogram_head_server,Lgenerate_server_binding,
 *
 * FUNCTION:	Franz Lisp specific code
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	assignments are made in languages.c via setup_languages()
 *              called in main().  The routines in this file are general.
 *              Lclient_proc() and Lserver_proc() are located in Lproccode.c.
 *
 */

/* $Log:	lispcode.c,v $
*/


# include "compiler.h"
# include "HRPC/cCourierTypes.h"

extern int fileDefined;


/* for code.c */


/*
 * Generate export function for server.  This stub routine is
 * actually just an interface to a much more complicated Export
 * routine buried in the RPC runtime.
 */
int 
Lprogram_head_client()
{
  fprintf (client, "\n;  Client stub for %s. \n\n", CurrentProgram);
  fprintf (client, "(sstatus feature _HRPCCLIENT)\n\n");
  fprintf (client, "(load '%s_defs.l)\n\n", CurrentProgram);
};

int 
Lprogram_head_server()
{ extern void LispProgramNumbers();   /* prognums.c */


    fprintf (server, "\n;  Server stub for %s. \n\n", CurrentProgram);

  fprintf (server, "(sstatus feature _HRPCSERVER)\n\n");
    fprintf (server, "(load '%s_defs.l)\n\n", CurrentProgram);
};


/****************************************************************/

#ifndef LISPLIBPATH
static char *LISPLIBPATH = "/usr/src/local/HRPC/LispIncludes";
#endif
#ifndef HRPCLIBPATH
static char *HRPCLIBPATH = "/usr/src/local/HRPC/HRpcRTS";
#endif
/* HELP ON THIS???
               set path to look for libraries ,
	         This isn't right.  should do sstatus more intelligently.
*/
int
L_defs( fFile )
	FILE *fFile;
{ extern void LispProgramNumbers();
  list p;



	fprintf (fFile, "\n; definitions for %s\n\
(comment -- '(these variables are predefined in the following inclusion\n\
\t\tINVALID_SPEAK\t\t0\n\t\tSUN_XDR_TCP\t\t1\n\t\tSUN_XDR_UDP\t\t2\n\
\t\tCOURIER_COURIER_SPP\t3\n\t\tDEC_SRC_UDP\t\t4))\n\n", CurrentProgram);



	fprintf (fFile,
"(sstatus load-search-path \n\t(|.| /usr/lib/lisp %s %s))\n\n",
		LISPLIBPATH, HRPCLIBPATH);


        fprintf (fFile, 
"#-_HRPCSR (load 'HRPCsendreceive.l)\n\t\t\t\t\t\t; conditional inclusion\n\n");

    /* same as DumpProgramNumbers, called by program_header() in code.c */
    LispProgramNumbers (fFile);    /* in prognums.c */

};


/****************************************************************/

int
Lgenerate_export_routine()
{
    fprintf (server, "(defun %s_Export (fName fKind fPrefs nPrefs)\n\
\t\t\t;  fName is service instance name (temporarily machine)\n\
\t\t\t;  fKind =0 if not to contact name server\n\
\t\t\t;  fPrefs is a vectori of otw formats\n\
\t\t\t;  nPrefs is size of fPrefs (number of bindings)\n\n", CurrentProgram);
    fprintf (server, "\t(HRPCExportAux\n\t\t\"%s\" fName %s_ProgN %d fKind \
\n\t\tfPrefs nPrefs 0 0))\n\n\n",
	     CurrentProgram, CurrentProgram, CurrentVersion);

};

/****************************************************************/


   /* generate dispatcher function for server */
int
Lgenerate_server_binding()
{ list p;
  extern char *UpCase();

	/*
	 * Note:  procedure number, program number and version
	 * number are long ints at this level, no matter what
	 * they are as far as the RPC protocol is concerned.
	 */
   fprintf (server, "(defun %s_Server (fNB fBindings)\n\
\t\t\t\t; fNB is number of bindings\n\
\t\t\t\t; fBindings is an array of bindings, \n\
\t\t\t\t;  returned by %s_Export\n\n",
CurrentProgram, CurrentProgram);

  fprintf (server, "\t(prog (readyAndProcNum)\n\
\t\t(setq readyAndProcNum (new-vectori-long 2))\n\
\t\t (errset\n\
\t\t  (prog ()\n\t\t loop \n\
\t\t   (WhoCallsMe fNB fBindings readyAndProcNum %s_ProgN)\n\n\
\t\t   (caseq (vrefi-long readyAndProcNum 1)\n", CurrentProgram);

  /* find all procedures declared in the program */
  for ( p = Procedures; p != NIL; p = cdr(p)) {
      fprintf (server,
"\t\t\t(%s    (serverTalkLisp\n\t\t\t\t(vrefi-long readyAndProcNum 0)\n\
\t\t\t\t%s_detect_jmp\n\t\t\t\t'%s\n\t\t\t\t%s_arg_pattern\n\
\t\t\t\t%s_return_pattern))\n",
         /*  UpCase( (char *) caar(p)) */ (char *) cdar(p),
	   (char *)caar(p), (char *)caar(p),
	   (char *)caar(p), (char *)caar(p) );
    };  /* end for.. */

    fprintf (server,
"\t\t\t(t    (print\n\t\t\t\t '(%s_server:  no such procedure))\n\
\t\t\t\t(terpri))\n\t\t   )\n", CurrentProgram);
    fprintf (server,
"\t\t  (go loop)\n\t\t  )\n\
\t\tt)    ; this is the last arg to errset and suppresses msgs if nil\n\
\t)\n)\n");

};  /* end of generate_server_binding */


/****************************************************************/



/* bindHack set in main from command line switch */
extern int bindHack;


int
Lgenerate_client_binding()
{ char *hcsFile = "HCSFile";
  list p;

    fprintf (client,
"(defun %s_Import (fInstanceName)\n", CurrentProgram);
    fprintf (client,
"\t(setq _HRPC_tmp (%sInitHRPC fInstanceName %d %d",
	(bindHack) ? "XX" : "", CurrentNumber, CurrentVersion);

		/* only do for client, for files, because
    				   file server interface doesn't need this */
    fprintf(client, " \"%s\"))\n",(fileDefined) ? hcsFile : CurrentProgram);

    fprintf (client, "\t(cond (( < _HRPC_tmp 0)\n\
\t\t (HRPC-error-print RUNTIME-ERROR\n\
\t\t  (times -1 _HRPC_tmp)) (error))\n\
\t   (t _HRPC_tmp)))\n\n\n");



};
/****************************************************************/


int
Lref_program_text(name, number, version)
	char *name, *number, *version;
{
    fprintf (lcheader, 
";   uses definitions from the DEPENDS UPON inclusion %s (%s) version %s\n\n",
         name, number, version);
};

    



