/* File:  languages.c  Date:  May 1, 1987  */

/*
 * INTERFACE:	setup_languages()
 *
 * FUNCTION:	assign language specific routines 
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	The C code is the original, and much of the code that
 *              generates symbol table structures is tightly intertwined
 *              code emitted for C headers.  Rather than rebuild those
 *              for each language, I am leaving the C code intact for 
 *              header and header1, and adding lheader which will be equivalent
 *              file for Lisp and other interpreted interfaces, such as 
 *              smallTalk;
 *
 */

/* $Log:   languages.c,v  $
*/

#include "compiler.h"

extern
int (*program_head_client)(), (*program_head_server)(), 
    (*generate_export_routine)(), (*generate_server_binding)(),
    (*generate_client_binding)(),
    (*ref_program_text)(),
    (*server_proc)(), (*client_proc)(),
    (*client_definitions)(), (*server_definitions)();  


extern int Cprogram_head_client(), Cprogram_head_server(),        /* code.c */
           Cgenerate_export_routine(), Cgenerate_server_binding(),
           Cgenerate_client_binding(),
	   C_noOp(), C_extradefs(),                               /* here */
	   Cserver_proc(), Cclient_proc();		    /* procedures.c */

							 /* lispcode.c */
extern int Lprogram_head_client(), Lprogram_head_server(),       
           Lgenerate_export_routine(), Lgenerate_server_binding(),
           Lgenerate_client_binding(), 
           Lref_program_text(),
	   Lclient_proc(), Lserver_proc(),
	   L_defs();





setup_languages( clientLang, serverLang)
     int clientLang, serverLang;
{
  switch (clientLang) {

              /* from code.c */
  case 'c' : program_head_client = Cprogram_head_client;
	   generate_client_binding = Cgenerate_client_binding;
	   ref_program_text = C_noOp;
	   client_definitions = C_extradefs;
	   	/* in procedures.c */
	   client_proc = Cclient_proc;
	   break;
              /* from code.c */
  case 'l' : program_head_client = Lprogram_head_client;
	   generate_client_binding = Lgenerate_client_binding;
	   ref_program_text = Lref_program_text;
	   client_definitions = L_defs;
	      /* for procedures.c */
	   client_proc = Lclient_proc;
	   break;
  default : error(FATAL, "invalid language type \n");
	 }


  switch (serverLang) {
  case 'c':      /* from code.c */
	   program_head_server = Cprogram_head_server;
	   generate_export_routine = Cgenerate_export_routine;
	   generate_server_binding = Cgenerate_server_binding;
	   server_proc = Cserver_proc;
	   server_definitions = C_extradefs;
	   break;
 case 'l':       /* from code.c */
	   program_head_server = Lprogram_head_server;
	   generate_export_routine = Lgenerate_export_routine;
	   generate_server_binding = Lgenerate_server_binding;
	   server_proc = Lserver_proc;
	   server_definitions = L_defs;
	   break;
 default:  error (FATAL, "invalid server language assigned \n");
	 }
}


/*****************************************************************/

/* this is a no op */

/*ARGSUSED*/
int
C_noOp ( dummy1, dummy2, dummy3)
  char *dummy1, *dummy2, *dummy3;
{};


/*ARGSUSED*/
int
C_extradefs( fFile)
	FILE *fFile;
{};

