

/* File:  fileprocedures.c  Date: 9/1/86 Kimi Gosney    */

/* $Log:	fileprocedures.c,v $
 * Revision 1.5  86/11/19  21:28:12  kimi
 * stable version
 * 
 * Revision 1.4  86/11/16  16:16:45  kimi
 * version with arg lists spec as cons structures
 * 
 * Revision 1.2  86/10/23  18:50:13  kimi
 * using DEPENDS UPON
 * 
 *
 */


/*
 * INTERFACE:	make_fileaccess_procs()
 *
 * FUNCTION:	emit code for procedures to access files
 *
 * IMPORTS:	fileDefined, FileTypeName from fileaccess.c
 *		cons() from misc.c
 *		procedure_type(), sequence_type(), make_type() from types.c
 *		define_constant(), Numeric_constant() from constants.c
 *		make_symbol() from symbols.c
 *
 * EXPORTS:	make_fileaccess_procs()
 *	NOT FOR INTENDED FOR EXPORT: make_fileprocedure(), make_filelists()
 *
 * DESIGN:	Build up data structures representing the required arguments
 *		for the file server access procedures.  Call upon same
 *		routines to emit the code as are used for normal procedures.
 *		Note that the file-type-ID is part of these arg lists, but
 *		is not manipulated by the user.  The fileDefined flag
 *		causes the code-emitting procedures in procedures.c to
 *		skip it when procedures are written into *_client.c.
 *		The typeUID is built into the stub, and sent over the wire,
 *		without the user ever seeing it. (unless s/he looks in the
 *		stub).
 *
 */

# include "compiler.h"
# include <HRPC/cCourierTypes.h>
# include <stdio.h>

extern char FileTypeName[];		/* from fileaccess.c */
extern int fileDefined;

#ifdef BOOTVERS
extern int errs;

make_fileaccess_procs()
{
    fprintf(stderr,"Cannot access WCS with bootstrap stubgenerator\n");
    errs = 1;
    goodbye();
}

make_fileprocedure()
{
    fprintf(stderr,"Cannot access WCS with bootstrap stubgenerator\n");
    errs = 1;
    goodbye();
}

make_filelists()
{
    fprintf(stderr,"Cannot access WCS with bootstrap stubgenerator\n");
    errs = 1;
    goodbye();
}

#else

/***********************************************************************/

/* make symbol table -like type structures */

	/* since cons only suffers FATAL errors, there are no useful
	   error messages to  generate here */
void			
make_filelists (typtr, typeUID,
		CreateArgListPtr, CreateResListPtr, CreateRepListPtr,
		PutArgListPtr, PutResListPtr, PutRepListPtr,
		PutManyArgListPtr,
		CommitArgListPtr, CommitResListPtr, CommitRepListPtr,
		OpenArgListPtr, OpenResListPtr, OpenRepListPtr,
		GetArgListPtr, GetResListPtr, GetRepListPtr,
		CloseArgListPtr, CloseResListPtr, CloseRepListPtr,
		AbortArgListPtr, AbortResListPtr, AbortRepListPtr)
	struct type *typtr;
	LongCardinal typeUID;
	list *CreateArgListPtr, *CreateResListPtr, *CreateRepListPtr,
		*PutArgListPtr, *PutResListPtr, *PutRepListPtr,
		*PutManyArgListPtr,
		*CommitArgListPtr, *CommitResListPtr, *CommitRepListPtr,
		*OpenArgListPtr, *OpenResListPtr, *OpenRepListPtr,
		*GetArgListPtr, *GetResListPtr, *GetRepListPtr,
		*CloseArgListPtr, *CloseResListPtr, *CloseRepListPtr,
		*AbortArgListPtr, *AbortResListPtr, *AbortRepListPtr;


	{ struct type *wFDTyptr, *rFDTyptr, *statusRecTyptr, *fileSpecTyptr,
	  		*versSpecTyptr, *fooSeqTyptr, *fileUIDTyptr;
	  list typeCons, recordCons, recordSeqCons, statusCons;

	  setUpForIFS (typtr, &wFDTyptr, &rFDTyptr, &statusRecTyptr,
	  	&fileSpecTyptr, &versSpecTyptr,	&fooSeqTyptr, &fileUIDTyptr,
		typeUID);


/* make symbol table -like type structures */
	  typeCons = cons (
			 cons ((list)"type", NIL),
			 (list)fileUIDTyptr);

  	  recordCons = cons (
			 cons ((list)"record", NIL),
			 (list)typtr);


  	  statusCons = cons (
			 cons ((list)"status", NIL),
			 (list)statusRecTyptr);

 
	  *CreateArgListPtr = 
	  	cons(				/* create args */
		    cons (
		        cons ((list)"file", NIL),
			(list)String_type),
		    cons (
		        typeCons,
			NIL)
		);

			    
		
	  *CreateResListPtr = 
	  	cons (				/* create res */
	            statusCons,
		    cons (
			cons (
			    cons ("writeFile", NIL),
			    (list)wFDTyptr),
			NIL
		    )
		);

	  *PutArgListPtr =
	  	cons (				
		    cons (
		        cons ((list)"writeFile", NIL),
			(list)wFDTyptr),
		    cons (
		        typeCons,
			cons (
			    recordCons,
			    NIL)
		    )
		);


	  *PutManyArgListPtr =
	  	cons (				
		    cons (
		        cons ((list)"writeFile", NIL),
			(list)wFDTyptr),
		    cons (
		        typeCons,
			cons (
			    cons (
				cons ((list)"records", NIL),
				(list)fooSeqTyptr),
			    NIL)
			)
		    );


	  *PutResListPtr = 
	  	cons (			
		    statusCons,
		    NIL);
		    

	  *CommitArgListPtr = 
		cons (				/* commit args */
		    cons (
		        cons ((list)"writeFile", NIL),
			(list)wFDTyptr),
		    cons (
		        cons (
			    cons ((list)"nameForNewFile", NIL),
			    (list)String_type),
			cons (
			    cons (
			        cons ((list)"checkForConsistencyWith", NIL),
			        (list)versSpecTyptr),
			    NIL)
		    )
		);

	  *CommitResListPtr =
		cons ( 			/* commit results */
		    statusCons,
		    cons (
			    cons (
			        cons ((list)"newFile", NIL),
			        (list)fileSpecTyptr),

			    NIL)
		    );


	  *AbortArgListPtr =
	  	cons (
	     	      cons (
		          cons ((list)"writeFile", NIL),
		          (list)wFDTyptr),
		      NIL);


	  *AbortResListPtr =
	  	cons (
		     statusCons,
		     NIL);




	  *OpenArgListPtr =
	  	cons(				/* open args */
		    cons (
		        cons ((list)"file", NIL),
			(list)fileSpecTyptr),
		    cons (
		        typeCons,
			NIL)
		);

			    
	  *OpenResListPtr =
	  	cons (				/* open res */
	            statusCons,
		    cons (
			cons (
			    cons ((list)"readFile", NIL),
			    (list)rFDTyptr),
			NIL
		    )
		);

	  *GetArgListPtr =
	  	cons (
		    cons (
		        cons ((list)"readFile", NIL),
			(list)rFDTyptr),
		    cons (
		        typeCons,
			cons (
			    cons (
			        cons ((list)"firstRecordIndex", NIL),
				(list)LongCardinal_type),
			    cons (
			        cons (
				    cons ((list)"recordCount", NIL),
				    (list)LongCardinal_type),
				NIL)
			)
		    )
		);


	  *GetResListPtr =
	  	cons (
		     statusCons,
		     cons (
		     	      cons (
			          cons ((list)"records", NIL),
			          (list)fooSeqTyptr),
			      NIL)
			);


	  *CloseArgListPtr =
	  	cons (
	     	      cons (
		          cons ((list)"readFile", NIL),
		          (list)rFDTyptr),
		      NIL);


	  *CloseResListPtr =
	  	cons (
		     statusCons,
		     NIL);




		*CreateRepListPtr = *PutRepListPtr = *CommitRepListPtr =
		*OpenRepListPtr = *GetRepListPtr = *CloseRepListPtr =
		*AbortRepListPtr = NIL;
	};


/*******************************************************************/

void
make_fileprocedure (procName, procNumber, ArgList, ResList, RepList)
	char *procName, *procNumber;
	list ArgList, ResList, RepList;
		{
			struct object *symbol;
			struct type *typtr;

			symbol = make_symbol(procName, CurrentProgram);
			typtr =  procedure_type (ArgList, ResList, RepList);
			define_constant(symbol, typtr,
			  Numeric_constant(procNumber));

		};

		
/*******************************************************************/

void
make_fileaccess_procs (fooTyptr, typeUID)
	  struct type *fooTyptr;
	  LongCardinal typeUID;



	{ list CreateArgList, CreateResList, CreateRepList,
		PutArgList, PutResList, PutRepList, PutManyArgList,
		CommitArgList, CommitResList, CommitRepList,
		OpenArgList, OpenResList, OpenRepList,
		GetArgList, GetResList, GetRepList,
		CloseArgList, CloseResList, CloseRepList,
		AbortArgList, AbortResList, AbortRepList;


	  char *procedName;
	

     /* define argument for the automatically created variables */
	     make_filelists ( fooTyptr, typeUID,
	        &CreateArgList, &CreateResList, &CreateRepList,
		&PutArgList, &PutResList, &PutRepList, &PutManyArgList,
		&CommitArgList, &CommitResList, &CommitRepList,
		&OpenArgList, &OpenResList, &OpenRepList,
		&GetArgList, &GetResList, &GetRepList,
		&CloseArgList, &CloseResList, &CloseRepList,
		&AbortArgList, &AbortResList, &AbortRepList);

	
	     


	  if ((procedName = malloc (strlen (FileTypeName) + 8)) == NULL)
	  	error (FATAL, "out of string space");


	  /* Note that the numbers assigned to these procedures are
	     defined by the WCS (InterimFileServer) interface.     */


	  /* Create */
	  (void) sprintf(procedName, "%s%s", "MakeNew", FileTypeName);
	  make_fileprocedure (procedName, "8", CreateArgList, CreateResList,
	  	CreateRepList);

	  /* Put */
	  (void) sprintf(procedName, "%s%s", "Put", FileTypeName);
	  make_fileprocedure (procedName, "9", PutManyArgList, PutResList,
	        PutRepList);


	  /* Commit */
	  (void) sprintf(procedName, "%s%s", "Commit", FileTypeName);
	  make_fileprocedure (procedName, "11", CommitArgList, CommitResList,
	  	CommitRepList);

	  /* Abort */
	  (void) sprintf(procedName, "%s%s", "Abort", FileTypeName);
	  make_fileprocedure (procedName, "12", AbortArgList, AbortResList,
	  	AbortRepList);

	  /* Open */
	  (void) sprintf(procedName, "%s%s", "Open", FileTypeName);
	  make_fileprocedure (procedName, "13", OpenArgList, OpenResList,
	  	OpenRepList);

	  /* Get */
	  (void) sprintf(procedName, "%s%s", "Get", FileTypeName);
	  make_fileprocedure (procedName, "14", GetArgList, GetResList,
	  	GetRepList);

	  /* Close */
	  (void) sprintf(procedName, "%s%s", "Close", FileTypeName);
	  make_fileprocedure (procedName, "15", CloseArgList, CloseResList,
	  	CloseRepList);




        free (procedName);



	};




/***********************************************************************/
/* define all these standard types for use by the WCS (also known as
   InterimFileServer).
*/

setUpForIFS (typtr, wFDTyptrPtr, rFDTyptrPtr, statusRecTyptrPtr, fileSpecTyptrPtr, versSpecTyptrPtr, fooSeqTyptrPtr, fileUIDTyptrPtr, typeUID)
      struct type *typtr, **wFDTyptrPtr, **rFDTyptrPtr, **statusRecTyptrPtr,
      		**fileSpecTyptrPtr, **versSpecTyptrPtr, **fooSeqTyptrPtr,
		**fileUIDTyptrPtr;
      LongCardinal typeUID;
      { struct object *symbol;
        struct type *verSpecTyptr, *NullRecTyptr, *StrRecTyptr,
		*LongCardTyptr, *CardTyptr, *IntTyptr, *VersionSpecType,
		*StatusCode;
	char fooSeqName[MAXSTR + 10];

        symbol = check_def ("WritableFileDescriptor", "FileComponents");
	*wFDTyptrPtr = symbol->o_type;

        symbol = check_def ("ReadableFileDescriptor", "FileComponents");
	*rFDTyptrPtr = symbol->o_type;

        symbol = check_def ("StatusRecord", "FileComponents");
	*statusRecTyptrPtr = symbol->o_type;

        symbol = check_def ("FileSpecifier", "FileComponents");
	*fileSpecTyptrPtr = symbol->o_type;

        symbol = check_def ("VersionSpec", "FileComponents");
	*versSpecTyptrPtr = symbol->o_type;


	sprintf (fooSeqName, "SequenceOf%s", FileTypeName);
	symbol = make_symbol ( fooSeqName, CurrentProgram);
	define_type (symbol,
	  *fooSeqTyptrPtr = sequence_type (MAXSEQ, typtr),
	  (char *)NULL);

	if ( fileDefined ) {

	    	/* if this is not the first file type declaration
		    in the .cr file, __FileUID will already have been
		    declared and used.  Need to suppress redeclaration,
		    but still need to use the old declaration to get
		    proper handling of type in the make_procedure...
		 */
           symbol = check_def ("__FileUID", CurrentProgram);
	   if ( symbol == ONIL ) 
	        error(FATAL, "FileUID botch.  \nfileDefined evaluated to TRUE but __FileUID is not defined in CurrentProgram, %s\n", CurrentProgram);
	   *fileUIDTyptrPtr = symbol->o_type;
	} else {
		/* if we are making a fileUIDTyptr, put the type (number)
		   into the u_list.  procedures.c knows to treat typtrs
		   named __FileUID specially, and retrieve it.
		   fileDefined flag is used in main.c,code.c and procedures.c
		*/

	   symbol = make_symbol ( "__FileUID", CurrentProgram);
 	   *fileUIDTyptrPtr = make_type(C_NUMERIC);
	   (*fileUIDTyptrPtr)->type_u.u_list = cons ((list *)typeUID, NIL);  

	    /* in-line replacement for define_type(), omitting
	       emission of the 'typedef' and keeping the name simple  */
	    symbol->o_class = O_TYPE;
	    symbol->o_type = *fileUIDTyptrPtr;
	    symbol->t_pfname = (char *)NULL;
	    symbol->t_name =
	    	copy( "__FileUID");


	   fileDefined = 1;	/* TRUE */

	};
      };
#endif
