#ifndef lint
static char RCSid[] = "$Header: code.c,v 3.2 87/05/01 15:59:43 kimi Exp $";
#endif

/* $Log:	code.c,v $
 * Revision 3.2  87/05/01  15:59:43  kimi
 * *** empty log message ***
 * 
 * Revision 3.1  87/04/05  17:57:31  kimi
 * As copied from /usr/src/local/HRPC.  new run-time 4/87
 * 
 * Revision 1.6  85/05/23  06:19:16  jqj
 * Public Beta-test version, released 24 May 1985
 * 
 * Revision 1.5  85/05/06  08:12:58  jqj
 * Almost Beta-test version.
 * 
 * Revision 1.4  85/03/26  06:09:24  jqj
 * Revised public alpha-test version, released 26 March 1985
 * 
 * Revision 1.3  85/03/11  16:38:39  jqj
 * Public alpha-test version, released 11 March 1985
 * 
 * Revision 1.2  85/02/21  11:04:47  jqj
 * alpha test version
 * 
 * Revision 1.1  85/02/15  13:55:15  jqj
 * Initial revision
 * 
 */

#include "compiler.h"
#if defined(sun)
#include <courier/courierdb.h>
#endif
#if defined(vax)
#include "courierdb.h"
#endif

extern int fileDefined;		/* in filecode.c */
extern int DoFileName();	/* in getcourierent.c */


int (*program_head_client)(), (*program_head_server)(), 
    (*generate_export_routine)(), (*generate_server_binding)(),
    (*generate_client_binding)(),
    (*ref_program_text)(),
    (*client_definitions)(), (*server_definitions)();


char *CurrentProgram = "unknown";
int CurrentNumber = 0;
int CurrentVersion = 0;

/*
 * Generate comments, #includes, and client binding.
 * This action is called before the module body has been reduced.
 * (jqj)
 */
program_header(symbol, number, version)
	char *symbol;
	char *number, *version;
{

	if (check_dependency(symbol)) {
		char *tempsym;
		tempsym = gensym(symbol);
		error(WARNING,"Module %s already seen.  Using %s.",
				symbol,tempsym);
		symbol = tempsym;
	}
	(void) make_module(symbol,number,version);
	CurrentProgram = symbol;
	CurrentVersion = stringtocard(version);
	CurrentNumber = stringtocard(number);

	/*
	 * only do this stuff for the main Courier program -- generate
	 * minimal code for DEPENDS UPON inclusions.
	 */
	if (recursive_flag) {
		fprintf(header1,"/* DEPENDS UPON %s NUMBER %d VERSION %d */\n",
			CurrentProgram, CurrentNumber, CurrentVersion);
		return;
	}

	/*
	 * Generate initial contents of all sorts of stuff:
	 * (1) set up gensym counter,
	 * (2) generate beginning of header files, support file, 
	 *	client file, server file
	 */
	setgensym(number,version);
	fprintf(header1,
"/*\n\
 * This header file contains inclusions for the main definitions and for\n\
 * any DEPENDS UPON modules.  It also contains #define commands to open\n\
 * the scope of the main definitons module.\n\
 *\n\
 * main inclusion:\n\
 */\n\
#include \"%s.h\"\n\n",
		CurrentProgram);

	/*
	 * In the definitions for this module, make sure we don't
	 * compile things twice by wrapping everything inside of a
	 * #ifndef ... #endif (the #endif is in wrapup_program() ).
	 */
	fprintf(header,
"/*\n\
 * Definitions for %s VERSION %s NUMBER %s.\n\
 */\n\
#ifndef __%s\n\
#define __%s\n\
#include <HRPC/cCourierTypes.h>\n\
#include <HRPC/basicRpc.h>\n\
#include <HRPC/hrpcErrCodes.h>\n\n",
		CurrentProgram, version, number,
		CurrentProgram, /*CurrentVersion, */
		CurrentProgram  /*,CurrentVersion */);

	fprintf(support1,
"/*\n\
 * Support routines for %s.\n\
 */\n\
#include \"%s.h\"\n",
		CurrentProgram, CurrentProgram);
	DumpProgramNumbers(support1);

        (*program_head_client)();         /* language specific stuff */
        (*program_head_server)();
}

/*************************************************************/

/*
 * Recursively parse a program to get types and constants.
 * as a side effect, enters the program name into the SymbolTables 
 * symbol table.
 */
ref_program(name, number, version)
	char *name, *number, *version;
{
	long save_offset;
	char *save_input_file;
	char buf[MAXSTR];
	int *p;           /* this is really a 'struct parser_state' */
	int intversion;
	extern int *save_parser_state();
	struct courierdbent *dbent;
	char descFileName[100];
	int istilde;	/* boolean */

	intversion = stringtocard(version);
	/*
	 * in a DEPENDS UPON inclusion, generate minimal code, making
	 * sure we don't do it twice.  The included program is wrapped in
	 * an #ifdef ... #endif
	 */

	istilde = (*name == '~');
	/* hack the name so that we can deal with tilde expansion */
	if (istilde) DoFileName (&name, descFileName);


	if (!recursive_flag) {

		fprintf(header,"\n\
/*\n\
 * Definitions from DEPENDS UPON %s inclusion\n\
 * (must be linked with %s_otw.c also)\n\
 */\n",
			name,
			name);

	    if (istilde || (*name == '/') || (*name == '.')) {
		fprintf(header,"\n\
#include \"%s.h\"\n",
			name);
	    } else {
		fprintf(header,"\n\
#include <HRPC/CIncludes/%s.h>\n",
			name);
	    };
        }
        (*ref_program_text)(name,number,version);  /* for foreign languages */

	if (check_module_def(name,number,version))
		/* we've already parsed this one, so don't bother to redo */
		return;

	save_offset = ftell(stdin);
	save_input_file = input_file;
	sprintf(buf, "%s.cr", name);
	input_file = buf;
	if (freopen(input_file, "r", stdin) == NULL) {
		dbent = getcourierservice(stringtocard(number),intversion);
		if (dbent == NULL ||
		    dbent->cr_description == NULL ||
		    (input_file = copy(dbent->cr_description)) == NULL ||
		    freopen(input_file, "r", stdin) == NULL) {
			error(ERROR, "file %s not found", input_file);
			input_file = save_input_file;
			freopen(input_file, "r", stdin);
			fseek(stdin, save_offset, 0);
			return;
		}
	}
	p = save_parser_state();
	/* note:  recursive_flag is now set */
	(void) yyparse();	/* recursively parse */



	/* We should test that we actually did find the matching description.
	   yyparse() will have redefined Current{Program,Number,Version}.
	   Thus we can check them before we set them back to what they are
	   supposed to be in this, the parent, level.
	*/
	if ( (CurrentNumber != stringtocard(number))
		|| (CurrentVersion != intversion) ) {
		    error(FATAL, "\n\tFile depended upon did not match courier description file found. \n\tRequested %s.cr (%d) VERSION %d.\n\tFound PROGRAM %s NUMBER %d VERSION %d.\n", 
name, stringtocard(number), intversion, CurrentProgram, CurrentNumber, CurrentVersion);
		};

	restore_parser_state(p);
	input_file = save_input_file;
	freopen(input_file, "r", stdin);
	fseek(stdin, save_offset, 0);
	return;
}

/*
 * Generate any code needed after DEPENDS UPON modules have been
 * parsed, but before declarations.
 */
program_body()
{
	if (recursive_flag)
		return;
	fprintf(header1,
"/*\n\
 * Widen scope to include all symbols defined in main inclusion:\n\
 */\n");

	(*client_definitions)(lcheader);     /* no op for C */
	(*server_definitions)(lsheader);     /* passing in file so that
						if these are same for some
						language, one routine is OK */
 }

/*
 * Generate code relating to binding.
 * This action is called after the entire module has been reduced.
 */
wrapup_program(prog)
	char *prog;
{
	if (recursive_flag)
		return;
	fprintf(header,"\n#endif __%s\n\n", CurrentProgram);
	if (!streq(prog,CurrentProgram))
		error(FATAL,"internal error (module): conflicting module names, %s and %s",
			prog,CurrentProgram);
	(*generate_export_routine)();
	(*generate_server_binding)();
	(*generate_client_binding)();
}

/*
 * Generate export function for server.  This stub routine is
 * actually just an interface to a much more complicated Export
 * routine buried in the RPC runtime.
 */
Cgenerate_export_routine()
{
    fprintf(server,"\nextern LongCardinal %s_ProgN[];\n",CurrentProgram);
    fprintf(server,"\n%s_Export( fName, fKind, fPrefs, fNPrefs, fBindings )\n",
	    CurrentProgram);
    fprintf(server,
"\tString fName;\n\
\tint fKind;\n\
\tSpeakDefs_Speak fPrefs[];\n\
\tint *fNPrefs;\n\
\tHRPCBinding *fBindings[];\n\
{\n",CurrentProgram);
    fprintf(server,
	"\tHRPCExport( \"%s\", fName, %s_ProgN, %d, fKind, fPrefs,\n\
\t\t\tfBindings, fNPrefs, 0, 0 );\n",
	CurrentProgram, CurrentProgram, CurrentVersion);
    fprintf(server,"}\n\n");
};


/*
 * Generate dispatcher function for server.
 */
Cgenerate_server_binding()
{
	list p;
	extern char *UpCase();

	/*
	 * Note:  procedure number, program number and version
	 * number are long ints at this level, no matter what
	 * they are as far as the RPC protocol is concerned.
	 */
	fprintf(server,
"\n%s_Server( fNB, fBptr )\n\
\tint fNB;\n\
\tHRPCBinding *fBptr[];\n\
{\n\
\tlong procnum;\n\
\tlong programnum;\n\
\tlong versionnum;\n\
\tHRPCBinding *readyBptr;\n\
\tint  status;\n\
\n\
\tfor (;;) {\n", CurrentProgram);
	fprintf(server,"\t\tif ( !HRPCDispatcher(fNB, fBptr, &readyBptr) ) return;\n");
	fprintf(server,"\t\t(*readyBptr->rpcDescr.InitIncoming)(readyBptr,\n\
\t\t\t&programnum, &versionnum, &procnum, &status, 0 );\n");
	fprintf(server,"\t\tif ( status ) continue;\n");
	fprintf(server,"\t\t/* FIXME: should check prog# & vers# here */\n");
	fprintf(server,"\t\tswitch( procnum ) {\n");
	/*
	 * Find all the procedures declared in the program.
	 */
	for (p = Procedures; p != NIL; p = cdr(p)) {
		fprintf(server,
"\t\tcase %s:\n\
\t\t\tserver_%s( readyBptr );\n\
\t\t\tbreak;\n",
			UpCase( (char *) caar(p) ), (char *)caar(p));
	}
	fprintf(server,
"\t\tdefault:\n\
\t\t\tfatalerr(\"%s_Server: no such procedure no.: %%d\\n\",procnum);\n",
		CurrentProgram,CurrentProgram);
	fprintf(server,"\t\t} /* switch */\n\t} /* for */\n}\n");
}

/*
 * Generate function for importing server module.
 */

/* bindHack set in main from command line switch */
extern int bindHack;

Cgenerate_client_binding()
{
    char *hcsFile = "HCSFile";

    fprintf(header1,"extern HRPCErrRec *%s_Import();\n",CurrentProgram);
    fprintf(client,
    "HRPCErrRec *%s_Import( fInstanceName, fBinding )\n\
    String fInstanceName;\n\
    HRPCBinding **fBinding;\n",
	CurrentProgram);
    fprintf(client,"{\n    extern HRPCErrRec *%sInitHRPCBinding();\n\n",
		(bindHack) ? "XX" : "");
    fprintf(client,"    return(\n");
    fprintf(client,
	"\t%sInitHRPCBinding( %d, %d,\n",
	(bindHack) ? "XX" : "", CurrentNumber,CurrentVersion);

    fprintf(client, "\t\tfInstanceName, \"%s\",\n",
		(fileDefined) ? hcsFile : CurrentProgram);
     		/* only do for client, for files,
		   because file server interface doesn't need this */

    fprintf(client,"\t\t(char *) 0, (char *) 0, fBinding)\n");
    fprintf(client,"          );\n");
    fprintf(client,"}\n");
}


/******************************************************************/


/* extracted from program_header() to allow language specific code to be 
   emitted for clients */

int
Cprogram_head_client()
{

	fprintf(client,
"/*\n\
 * Client routines for %s.\n\
 */\n\
#include \"%s.h\"\n\
#include <setjmp.h>\n",
		CurrentProgram, CurrentProgram);
	fprintf(client,"\nextern LongCardinal %s_ProgN[];\n",CurrentProgram);
};


int
Cprogram_head_server()
{
	fprintf(server,
"/*\n\
 * Server for %s.\n\
 */\n\
#define HRPC_SERVER\n\
#include \"%s.h\"\n\
#include <setjmp.h>\n\n",
		CurrentProgram, CurrentProgram);
}


