--
-- Renamed and hacked, 4/2/87.  Still uses 4 part names.
--
Binding : PROGRAM 1234 VERSION 1 =

BEGIN

DEPENDS UPON SpeakDefs(750) VERSION 1;

	-- This is the premier attempt to define the Courier interface to the
	-- HCS name service.

	-- Note that the BA (Binding Agent) stuff is also wedged in here,
	-- although this would never occur in practice.


	-- Data Structures

	FOUR_PART_NAME	: TYPE = RECORD
		[
		SpeakSet	: SEQUENCE OF LONG UNSPECIFIED,
		Instance	: STRING,
		Type		: STRING,
		Domain		: STRING
		];

--
--	SPEAK : TYPE = see speak.cr
--
	SUN_XDR_UDP_BINDING_DESCR	: TYPE = RECORD
		[
		ipAddr		: ARRAY 2 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	SUN_XDR_TCP_BINDING_DESCR	: TYPE = RECORD
		[
		ipAddr		: ARRAY 2 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	COURIER_COURIER_SPP_BINDING_DESCR	: TYPE = RECORD
		[
		xnsAddr		: ARRAY 5 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	RAW_TCP_BINDING_DESCR	: TYPE = RECORD
		[
		ipAddr		: ARRAY 2 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	RAW_UDP_BINDING_DESCR	: TYPE = RECORD
		[
		ipAddr		: ARRAY 2 OF UNSPECIFIED,
		portNum		: LONG CARDINAL,
		progNum		: LONG CARDINAL
		];

	REAL_BINDING_DESCR	: TYPE = CHOICE SpeakDefs.Speak OF
		{
		INVALID_SPEAK		=> UNSPECIFIED,
		SUN_XDR_TCP		=> SUN_XDR_TCP_BINDING_DESCR,
		SUN_XDR_UDP		=> SUN_XDR_UDP_BINDING_DESCR,
		COURIER_COURIER_SPP	=> COURIER_COURIER_SPP_BINDING_DESCR,
		DEC_SRC_UDP		=> UNSPECIFIED,
		RAW_TCP			=> RAW_TCP_BINDING_DESCR,
		RAW_UDP			=> RAW_UDP_BINDING_DESCR
		};


	BINDING_DESCR	: TYPE = RECORD
		[
		useBA		: BOOLEAN,
		data		: REAL_BINDING_DESCR
		];

	BINDING_DESCR_LIST : TYPE = SEQUENCE 1000 OF BINDING_DESCR;



	-- HRPC Error returns

	HRPC_ERRCODE	: TYPE = LONG CARDINAL;

	IMPORT_NORMAL   : HRPC_ERRCODE =       0; -- success
	IMPORT_NSFAILED : HRPC_ERRCODE = 020001X; -- No NS
	IMPORT_BAFAILED : HRPC_ERRCODE = 020002X; -- No BA
	IMPORT_BADNAME  : HRPC_ERRCODE = 020003X; -- Name not found
	IMPORT_BADSPEAK : HRPC_ERRCODE = 020004X; -- Bad speak type
	IMPORT_BADSYNTAX: HRPC_ERRCODE = 020005X; -- Bad name syntax
	IMPORT_NOTREGIS : HRPC_ERRCODE = 020006X; -- BA says "no such service"
	IMPORT_BADHOST  : HRPC_ERRCODE = 020007X; -- XX

	EXPORT_NORMAL   : HRPC_ERRCODE =	      0; -- success
	EXPORT_NSFAILED : HRPC_ERRCODE = 030001X; -- can't register with NS
	EXPORT_BAFAILED : HRPC_ERRCODE = 030002X; -- can't register with BA
	EXPORT_INUSE    : HRPC_ERRCODE = 030003X; -- can't "re-export"
	EXPORT_BADSPEAK : HRPC_ERRCODE = 030004X;
	EXPORT_BADSYNTAX: HRPC_ERRCODE = 030005X;

        STATUS_REC	: TYPE = RECORD
		 [
		 errCode: HRPC_ERRCODE,
		 notUsed: LONG UNSPECIFIED
		 ];

	-- Remote Entry Points

	EvalQuery	: PROCEDURE [ serverQuery : FOUR_PART_NAME ]
				RETURNS [ serverList : BINDING_DESCR_LIST,
					  status : STATUS_REC ]
			= 1;

	RegisterServer	: PROCEDURE [ serverName : FOUR_PART_NAME,
				      descrList : BINDING_DESCR_LIST ]
				RETURNS [ status : STATUS_REC ]
			= 2;

--
-- Obsolete
--	ResolveBinding	: PROCEDURE [ speakType : SpeakDefs.Speak,
--				      bindDescr : BINDING_DESCR ]
--				RETURNS [ answer : BINDING_DESCR,
--					  status : STATUS_REC ]	= 3;

END.
