/*
 * Server for TypeRegistry.
 */
#define HRPC_SERVER
#include "TypeRegistry.h"
#include <setjmp.h>


extern void TypeRegistry_GetTypeID();
static jmp_buf server_TypeRegistry_GetTypeID_Unwind;

HRPCErrRec *server_TypeRegistry_GetTypeID(fBinding)
	HRPCBinding *fBinding;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;

	String name;
	String structure;
	String description;
	Boolean registerOption;
	TypeRegistry_StatusCode status;
	LongCardinal typeID;

	if ( server_TypeRegistry_GetTypeID_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(server_TypeRegistry_GetTypeID_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) server_TypeRegistry_GetTypeID_Unwind;
	(*otwctl->String)(fBinding,&name);
	(*otwctl->String)(fBinding,&structure);
	(*otwctl->String)(fBinding,&description);
	(*otwctl->Boolean)(fBinding,&registerOption);
	(*rpcctl->FinishIncoming)(fBinding);
	TypeRegistry_GetTypeID(fBinding, name, structure, description, registerOption, &status, &typeID);
	(*rpcctl->InitReply)(fBinding);
	(*otwctl->Enumeration)(fBinding,&status);
	(*otwctl->LongCardinal)(fBinding,&typeID);
	(*rpcctl->FinishReply)(fBinding);
	return(NOHRPCERR);
}

extern void TypeRegistry_LookupByName();
static jmp_buf server_TypeRegistry_LookupByName_Unwind;

HRPCErrRec *server_TypeRegistry_LookupByName(fBinding)
	HRPCBinding *fBinding;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;

	String name;
	TypeRegistry_StatusCode status;
	TypeRegistry_T_r3266_3 found;

	if ( server_TypeRegistry_LookupByName_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(server_TypeRegistry_LookupByName_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) server_TypeRegistry_LookupByName_Unwind;
	(*otwctl->String)(fBinding,&name);
	(*rpcctl->FinishIncoming)(fBinding);
	TypeRegistry_LookupByName(fBinding, name, &status, &found);
	(*rpcctl->InitReply)(fBinding);
	(*otwctl->Enumeration)(fBinding,&status);
	(*otwctl->Sequence)(fBinding,&found.sequence,&found.length,65535,sizeof(TypeRegistry_T_s3266_4),TypeRegistry_T_s3266_4Otw);
	(*rpcctl->FinishReply)(fBinding);
	return(NOHRPCERR);
}

extern void TypeRegistry_LookupByStructure();
static jmp_buf server_TypeRegistry_LookupByStructure_Unwind;

HRPCErrRec *server_TypeRegistry_LookupByStructure(fBinding)
	HRPCBinding *fBinding;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;

	String structure;
	TypeRegistry_StatusCode status;
	TypeRegistry_T_r3266_6 found;

	if ( server_TypeRegistry_LookupByStructure_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(server_TypeRegistry_LookupByStructure_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) server_TypeRegistry_LookupByStructure_Unwind;
	(*otwctl->String)(fBinding,&structure);
	(*rpcctl->FinishIncoming)(fBinding);
	TypeRegistry_LookupByStructure(fBinding, structure, &status, &found);
	(*rpcctl->InitReply)(fBinding);
	(*otwctl->Enumeration)(fBinding,&status);
	(*otwctl->Sequence)(fBinding,&found.sequence,&found.length,65535,sizeof(TypeRegistry_T_s3266_7),TypeRegistry_T_s3266_7Otw);
	(*rpcctl->FinishReply)(fBinding);
	return(NOHRPCERR);
}

extern void TypeRegistry_LookupByID();
static jmp_buf server_TypeRegistry_LookupByID_Unwind;

HRPCErrRec *server_TypeRegistry_LookupByID(fBinding)
	HRPCBinding *fBinding;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;

	LongCardinal typeID;
	TypeRegistry_StatusCode status;
	String name;
	String structure;

	if ( server_TypeRegistry_LookupByID_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(server_TypeRegistry_LookupByID_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) server_TypeRegistry_LookupByID_Unwind;
	(*otwctl->LongCardinal)(fBinding,&typeID);
	(*rpcctl->FinishIncoming)(fBinding);
	TypeRegistry_LookupByID(fBinding, typeID, &status, &name, &structure);
	(*rpcctl->InitReply)(fBinding);
	(*otwctl->Enumeration)(fBinding,&status);
	(*otwctl->String)(fBinding,&name);
	(*otwctl->String)(fBinding,&structure);
	(*rpcctl->FinishReply)(fBinding);
	return(NOHRPCERR);
}

extern void TypeRegistry_GetFullDescription();
static jmp_buf server_TypeRegistry_GetFullDescription_Unwind;

HRPCErrRec *server_TypeRegistry_GetFullDescription(fBinding)
	HRPCBinding *fBinding;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;

	LongCardinal typeID;
	TypeRegistry_StatusCode status;
	String description;

	if ( server_TypeRegistry_GetFullDescription_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(server_TypeRegistry_GetFullDescription_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) server_TypeRegistry_GetFullDescription_Unwind;
	(*otwctl->LongCardinal)(fBinding,&typeID);
	(*rpcctl->FinishIncoming)(fBinding);
	TypeRegistry_GetFullDescription(fBinding, typeID, &status, &description);
	(*rpcctl->InitReply)(fBinding);
	(*otwctl->Enumeration)(fBinding,&status);
	(*otwctl->String)(fBinding,&description);
	(*rpcctl->FinishReply)(fBinding);
	return(NOHRPCERR);
}

extern LongCardinal TypeRegistry_ProgN[];

TypeRegistry_Export( fName, fKind, fPrefs, fNPrefs, fBindings )
	String fName;
	int fKind;
	SpeakDefs_Speak fPrefs[];
	int *fNPrefs;
	HRPCBinding *fBindings[];
{
	HRPCExport( "TypeRegistry", fName, TypeRegistry_ProgN, 1, fKind, fPrefs,
			fBindings, fNPrefs, 0, 0 );
}


TypeRegistry_Server( fNB, fBptr )
	int fNB;
	HRPCBinding *fBptr[];
{
	long procnum;
	long programnum;
	long versionnum;
	HRPCBinding *readyBptr;
	int  status;

	for (;;) {
		if ( !HRPCDispatcher(fNB, fBptr, &readyBptr) ) return;
		(*readyBptr->rpcDescr.InitIncoming)(readyBptr,
			&programnum, &versionnum, &procnum, &status, 0 );
		if ( status ) continue;
		/* FIXME: should check prog# & vers# here */
		switch( procnum ) {
		case TYPEREGISTRY_GETFULLDESCRIPTION:
			server_TypeRegistry_GetFullDescription( readyBptr );
			break;
		case TYPEREGISTRY_LOOKUPBYID:
			server_TypeRegistry_LookupByID( readyBptr );
			break;
		case TYPEREGISTRY_LOOKUPBYSTRUCTURE:
			server_TypeRegistry_LookupByStructure( readyBptr );
			break;
		case TYPEREGISTRY_LOOKUPBYNAME:
			server_TypeRegistry_LookupByName( readyBptr );
			break;
		case TYPEREGISTRY_GETTYPEID:
			server_TypeRegistry_GetTypeID( readyBptr );
			break;
		default:
			fatalerr("TypeRegistry_Server: no such procedure no.: %d\n",procnum);
		} /* switch */
	} /* for */
}
