/*
 * Client routines for TypeRegistry.
 */
#include "TypeRegistry.h"
#include <setjmp.h>

extern LongCardinal TypeRegistry_ProgN[];

static jmp_buf TypeRegistry_GetTypeID_Unwind;
HRPCErrRec *
TypeRegistry_GetTypeID(fBinding, name, structure, description, registerOption, status, typeID)
	HRPCBinding *fBinding;
	String name;
	String structure;
	String description;
	Boolean registerOption;
	TypeRegistry_StatusCode *status;
	LongCardinal *typeID;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;
	if ( (fBinding->bndProgNum != TypeRegistry_ProgN[(int)fBinding->speaking]) 
		 || (fBinding->ifdPtr->versNum > 1)) {
		return(NewHRPCErrRec(HRPC_WRNGSTUB,0));
	}
	if ( TypeRegistry_GetTypeID_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(TypeRegistry_GetTypeID_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) TypeRegistry_GetTypeID_Unwind;
	(*rpcctl->InitOutgoing)(fBinding, 1, 1);
	(*otwctl->String)(fBinding,&name);
	(*otwctl->String)(fBinding,&structure);
	(*otwctl->String)(fBinding,&description);
	(*otwctl->Boolean)(fBinding,&registerOption);
	(*rpcctl->FinishOutgoing)(fBinding);
	(*rpcctl->InitAnswer)(fBinding);
	(*otwctl->Enumeration)(fBinding,status);
	(*otwctl->LongCardinal)(fBinding,typeID);
	(*rpcctl->FinishAnswer)(fBinding);
	return(NOHRPCERR);
}

static jmp_buf TypeRegistry_LookupByName_Unwind;
HRPCErrRec *
TypeRegistry_LookupByName(fBinding, name, status, found)
	HRPCBinding *fBinding;
	String name;
	TypeRegistry_StatusCode *status;
	TypeRegistry_T_r3266_3 *found;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;
	if ( (fBinding->bndProgNum != TypeRegistry_ProgN[(int)fBinding->speaking]) 
		 || (fBinding->ifdPtr->versNum > 1)) {
		return(NewHRPCErrRec(HRPC_WRNGSTUB,0));
	}
	if ( TypeRegistry_LookupByName_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(TypeRegistry_LookupByName_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) TypeRegistry_LookupByName_Unwind;
	(*rpcctl->InitOutgoing)(fBinding, 2, 1);
	(*otwctl->String)(fBinding,&name);
	(*rpcctl->FinishOutgoing)(fBinding);
	(*rpcctl->InitAnswer)(fBinding);
	(*otwctl->Enumeration)(fBinding,status);
	(*otwctl->Sequence)(fBinding,&found->sequence,&found->length,65535,sizeof(TypeRegistry_T_s3266_4),TypeRegistry_T_s3266_4Otw);
	(*rpcctl->FinishAnswer)(fBinding);
	return(NOHRPCERR);
}

static jmp_buf TypeRegistry_LookupByStructure_Unwind;
HRPCErrRec *
TypeRegistry_LookupByStructure(fBinding, structure, status, found)
	HRPCBinding *fBinding;
	String structure;
	TypeRegistry_StatusCode *status;
	TypeRegistry_T_r3266_6 *found;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;
	if ( (fBinding->bndProgNum != TypeRegistry_ProgN[(int)fBinding->speaking]) 
		 || (fBinding->ifdPtr->versNum > 1)) {
		return(NewHRPCErrRec(HRPC_WRNGSTUB,0));
	}
	if ( TypeRegistry_LookupByStructure_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(TypeRegistry_LookupByStructure_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) TypeRegistry_LookupByStructure_Unwind;
	(*rpcctl->InitOutgoing)(fBinding, 3, 1);
	(*otwctl->String)(fBinding,&structure);
	(*rpcctl->FinishOutgoing)(fBinding);
	(*rpcctl->InitAnswer)(fBinding);
	(*otwctl->Enumeration)(fBinding,status);
	(*otwctl->Sequence)(fBinding,&found->sequence,&found->length,65535,sizeof(TypeRegistry_T_s3266_7),TypeRegistry_T_s3266_7Otw);
	(*rpcctl->FinishAnswer)(fBinding);
	return(NOHRPCERR);
}

static jmp_buf TypeRegistry_LookupByID_Unwind;
HRPCErrRec *
TypeRegistry_LookupByID(fBinding, typeID, status, name, structure)
	HRPCBinding *fBinding;
	LongCardinal typeID;
	TypeRegistry_StatusCode *status;
	String *name;
	String *structure;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;
	if ( (fBinding->bndProgNum != TypeRegistry_ProgN[(int)fBinding->speaking]) 
		 || (fBinding->ifdPtr->versNum > 1)) {
		return(NewHRPCErrRec(HRPC_WRNGSTUB,0));
	}
	if ( TypeRegistry_LookupByID_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(TypeRegistry_LookupByID_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) TypeRegistry_LookupByID_Unwind;
	(*rpcctl->InitOutgoing)(fBinding, 4, 1);
	(*otwctl->LongCardinal)(fBinding,&typeID);
	(*rpcctl->FinishOutgoing)(fBinding);
	(*rpcctl->InitAnswer)(fBinding);
	(*otwctl->Enumeration)(fBinding,status);
	(*otwctl->String)(fBinding,name);
	(*otwctl->String)(fBinding,structure);
	(*rpcctl->FinishAnswer)(fBinding);
	return(NOHRPCERR);
}

static jmp_buf TypeRegistry_GetFullDescription_Unwind;
HRPCErrRec *
TypeRegistry_GetFullDescription(fBinding, typeID, status, description)
	HRPCBinding *fBinding;
	LongCardinal typeID;
	TypeRegistry_StatusCode *status;
	String *description;
{
	register OtwControl *otwctl = &(fBinding->otwDescr);
	register RpcControl *rpcctl = &(fBinding->rpcDescr);
	HRPCErrRec *errRes;
	if ( (fBinding->bndProgNum != TypeRegistry_ProgN[(int)fBinding->speaking]) 
		 || (fBinding->ifdPtr->versNum > 1)) {
		return(NewHRPCErrRec(HRPC_WRNGSTUB,0));
	}
	if ( TypeRegistry_GetFullDescription_Unwind[9] == 0 ) {
		if ( errRes = (HRPCErrRec *) setjmp(TypeRegistry_GetFullDescription_Unwind) ) {
			return( errRes );
		}
	}
	fBinding->unwindTo = (memory) TypeRegistry_GetFullDescription_Unwind;
	(*rpcctl->InitOutgoing)(fBinding, 5, 1);
	(*otwctl->LongCardinal)(fBinding,&typeID);
	(*rpcctl->FinishOutgoing)(fBinding);
	(*rpcctl->InitAnswer)(fBinding);
	(*otwctl->Enumeration)(fBinding,status);
	(*otwctl->String)(fBinding,description);
	(*rpcctl->FinishAnswer)(fBinding);
	return(NOHRPCERR);
}
HRPCErrRec *TypeRegistry_Import( fInstanceName, fBinding )
    String fInstanceName;
    HRPCBinding **fBinding;
{
    extern HRPCErrRec *InitHRPCBinding();

    return(
	InitHRPCBinding( 3266, 1,
		fInstanceName, "TypeRegistry",
		(char *) 0, (char *) 0, fBinding)
          );
}
