/*
 * Definitions for TypeRegistry VERSION 1 NUMBER 3266.
 */
#ifndef __TypeRegistry
#define __TypeRegistry
#include <HRPC/cCourierTypes.h>
#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>

typedef String TypeRegistry_TypeName;
typedef LongCardinal TypeRegistry_RecordType;
typedef String TypeRegistry_StructureDescription;
typedef String TypeRegistry_LongDescription;

static Cardinal TypeRegistry_maxTypeName = {50};

static Cardinal TypeRegistry_maxStructureDescription = {250};

typedef enum {
	TR_success = 0,
	TR_alreadyRegistered = 1,
	TR_newlyRegistered = 2,
	TR_reRegistered = 3,
	TR_notRegisteredByRequest = 4,
	TR_typeNameTooLong = 5,
	TR_structureDescriptionTooLong = 6,
	TR_insufficientSpace = 7,
	TR_notFound = 8,
	TR_cantFindCourierDescription = 9,
	TR_other = 255
} TypeRegistry_StatusCode;

#ifndef HRPC_SERVER
extern HRPCErrRec * TypeRegistry_GetTypeID();
#else
extern void TypeRegistry_GetTypeID();
#endif
#define TYPEREGISTRY_GETTYPEID 1

typedef struct {
	LongCardinal typeID;
	String structure;
} TypeRegistry_T_s3266_4;
extern int TypeRegistry_T_s3266_4Otw();

typedef struct {
	Cardinal length;
	TypeRegistry_T_s3266_4 *sequence;
} TypeRegistry_T_r3266_3;
extern int TypeRegistry_T_r3266_3Otw();

#ifndef HRPC_SERVER
extern HRPCErrRec * TypeRegistry_LookupByName();
#else
extern void TypeRegistry_LookupByName();
#endif
#define TYPEREGISTRY_LOOKUPBYNAME 2

typedef struct {
	LongCardinal typeID;
	String name;
} TypeRegistry_T_s3266_7;
extern int TypeRegistry_T_s3266_7Otw();

typedef struct {
	Cardinal length;
	TypeRegistry_T_s3266_7 *sequence;
} TypeRegistry_T_r3266_6;
extern int TypeRegistry_T_r3266_6Otw();

#ifndef HRPC_SERVER
extern HRPCErrRec * TypeRegistry_LookupByStructure();
#else
extern void TypeRegistry_LookupByStructure();
#endif
#define TYPEREGISTRY_LOOKUPBYSTRUCTURE 3

#ifndef HRPC_SERVER
extern HRPCErrRec * TypeRegistry_LookupByID();
#else
extern void TypeRegistry_LookupByID();
#endif
#define TYPEREGISTRY_LOOKUPBYID 4

#ifndef HRPC_SERVER
extern HRPCErrRec * TypeRegistry_GetFullDescription();
#else
extern void TypeRegistry_GetFullDescription();
#endif
#define TYPEREGISTRY_GETFULLDESCRIPTION 5

#endif __TypeRegistry

