-- TypeRegistry.cr
-- JMaloney, 27-Aug-86 13:27:14.
-- Revised: Bjorn Freeman-Benson, 11-Sep-86
-- Revised: JMaloney, 4-Sep-86 12:24:15 - changed StatusCode and GetTypeID.

TypeRegistry: PROGRAM 3266 VERSION 1 =
BEGIN

-- Types

  -- The TypeRegistry stores 4-tuples of the form:
  --   <RecordType> <TypeName> <StructureDescription> <LongDescriptionFilename>
  -- The actual long description is saved in a seperate file give by ^^^.


  TypeName: TYPE = STRING;
    -- Mnemonic name for the type.
    -- Must be less than maxTypeName characters.

  RecordType: TYPE = LONG CARDINAL;
    -- The "magic number" assigned by the type registry.

  StructureDescription: TYPE = STRING;
    -- A compact, interpretable record description.
    -- Must be less than maxStructureDescription characters.
    -- See the DataString document.

  LongDescription: TYPE = STRING;
    -- The full Courier type description including comments.

  maxTypeName: CARDINAL = 50;
  maxStructureDescription: CARDINAL = 250;

-- Errors

  StatusCode: TYPE = {
    TR_success(0),
    TR_alreadyRegistered(1),
    TR_newlyRegistered(2),
    TR_reRegistered(3),
    TR_notRegisteredByRequest(4),
    TR_typeNameTooLong(5),
    TR_structureDescriptionTooLong(6),
    TR_insufficientSpace(7),
    TR_notFound(8),
    TR_cantFindCourierDescription(9),
    TR_other(255)};

-- Operations

  GetTypeID: PROCEDURE [
    name: TypeName,
    structure: StructureDescription,
    description: LongDescription,
    registerOption: BOOLEAN]
      RETURNS [
        status: StatusCode,
        typeID: RecordType]
    = 1;
  -- If a matching entry is found (matches name and structure)
  --	If registerOption is TRUE
  --	   Reregisters the description and returns reRegistered
  --	else
  --	   Returns alreadyRegistered
  --	endif
  -- else
  --	If registerOption is TRUE
  --	   Registers the type and returns newlyRegistered
  --	else
  --	   Returns notRegisteredByRequest
  --	endif
  -- endif
  -- Possible outcomes:
  --	alreadyRegistered
  --	newlyRegistered
  --	notRegisteredByRequest
  --	reRegistered
  --	typeNameTooLong
  --	structureDescriptionTooLong
  --	insufficientSpace
  --	other

  LookupByName: PROCEDURE [name: TypeName]
    RETURNS [
      status: StatusCode,
      found: SEQUENCE OF RECORD [
        typeID: RecordType,
	structure: StructureDescription]]
    = 2;
  -- Possible outcomes:
  --	success, returns data in found
  --	notFound
  --	typeNameTooLong
  --	other

  LookupByStructure: PROCEDURE [structure: StructureDescription]
    RETURNS [
      status: StatusCode,
      found: SEQUENCE OF RECORD [
        typeID: RecordType,
	name: TypeName]]
    = 3;
  -- Possible outcomes:
  --	success, returns data in found
  --	notFound
  --	structureDescriptionTooLong
  --	other

  LookupByID: PROCEDURE [typeID: RecordType]
    RETURNS [
      status: StatusCode,
      name: TypeName,
      structure: StructureDescription]
    = 4;
  -- Possible outcomes:
  --	success, returns data in name and structure
  --	notFound
  --	other

  GetFullDescription: PROCEDURE [typeID: RecordType]
    RETURNS [
      status: StatusCode,
      description: LongDescription]
    = 5;
  -- Possible outcomes:
  --	success
  --	notFound
  --	cantFindCourierDescription
  --	other

END.
