/* File: /u1/oystr/HRPC/HRPC/STMs/SUN_TCP_STMs.c  Date:  18-Aug-1987  */

/*
 * $Header$
 * FUNCTION: SUN_TCP_* Speak Type Managers.
 * 
 * $Log$
 *
 *  18-Aug-1987: Initial implementation, Mark Squillante
 */

#include <stdio.h>
#include <sys/time.h>
#include <signal.h>
#include "../LWP/kEvents.h"
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include "../Transports/connDefs.h"
#include "../LWP/lwpSystemQs.h"
#include <netinet/in.h>
#include <fcntl.h>

HRPCBinding	*SearchBindingQ();
int		DeleteFromTaskQ();
int		AddToArrivedPacketQ();

/*
 * The SpeakTypeMgrs process packets that have arrived by determining which
 * LWP should receive the packet, setting that LWP's buffer ptrs, and
 * awakening that LWP.  Each STM walks through its TaskQ (each element
 * representing a packet that has arrived) processing the elements in this Q.
 * The Q has been constructed by the signal handler.  The STM holds signals
 * during its walk thru the Q - the assumptions are that the Q will be small,
 * the STM doesn't require much time to process an element, & therefore signals
 * will not be held for an extended period of time.  If any of the assumptions
 * prove false, signals should be released and reaquired after processing
 * an element on the TaskQ.
 */
int	SUN_TCP_SpeakTypeMgr(myfBptr)
    HRPCBinding	*myfBptr;
{
	HRPCBinding		*wakeupBinding;
	struct PacketQelement	*head, *nexthead;
	struct lwpIoRequest	*request;
	struct timeval		timeout;
	int			sigsheldprevious, myfd;
	int			myst;
	void			TCP_passTaskToBinding();
	int			recv_fd, workLeftOnTaskQ;

	myfd = myfBptr->transDescr.sockfd;
	myst = (int) myfBptr->speaking;
	request = lwpNewRequest();
	timeout.tv_sec  = 10;
	timeout.tv_usec = 0;
	while ( TRUE ) {
	    workLeftOnTaskQ = FALSE;
	    HRPC_LWPawakenSTMs();
		/* Hold signals */
	    DISABLE_SignalHandler
	    for ( head=STMconnStates[myst].TaskQ; head != NULL; head=nexthead ) {
		nexthead = head -> Next;
		recv_fd = head -> fd;

		    /* set up binding ptrs in case IdTable procs are called */
		myfBptr->curBufSize = head->BufSize;
		myfBptr->curBufMark = head->BufMark;
		myfBptr->currentBuffer = head->CurrentBuffer;

		    /* check if error occurred when SignalHandler did read */
		if ( head->BufSize <= 0 ) {	/* read error */
			/* find first BindingQ el & return its Binding */
		    wakeupBinding = SearchBindingQ(myst,recv_fd,NULL);
		} else {	/* successful read */
			/* find appropriate BindingQ el & return its Binding */
		    wakeupBinding = SearchBindingQ(myst,recv_fd,myfBptr);
		}

		    /* pass task to BindingQ el obtained above */
		if ( wakeupBinding == 0 ) {
			/* nobody available to process task so just leave task
			 * on TaskQ and process later - ??? there may be cases
			 * where throwing task away is more appropriate */
		    TAIL_TaskQ[myst] = head;
		    workLeftOnTaskQ = TRUE;
		} else {
		        /* add packet to wakeupBinding's arrivedPacketQ */
		    TCP_passTaskToBinding(myst,wakeupBinding,head);
		}
	    }
		/* Release signals */
	    ENABLE_SignalHandler
		/* wait until there's something for me to do */
	    if ( workLeftOnTaskQ ) {
		    /* set timeout - construct request block & insert */
		request -> timeout.TotalTime = timeout;
		request -> timeout.BackPointer = (char *) request;
		request -> HRPC_WaitCondition = (HRPCBinding *) myst;
		timerInsert(lwpRequests, &request->timeout);
	    }
	    (*HRPC_lwpDescr.Wait)(myst);
	    if ( workLeftOnTaskQ ) {
		    /* remove request block */
		timerRemove(lwpRequests, &request->timeout);
	    }
	}
}
/* This procedure is used by STMs to carry out the passing of packet
 * information to the binding for which it is destined.  Thus, it is assumed
 * that signals are already held (for access to TaskQ). */
static void	TCP_passTaskToBinding(spktyp,fBptr,packetInfo)
    int				spktyp;
    HRPCBinding			*fBptr;
    struct PacketQelement	*packetInfo;
{
	struct sockaddr_in	*from;
	struct sockaddr_in	*peer;

	DeleteFromTaskQ(spktyp,packetInfo,0);
	AddToArrivedPacketQ(fBptr,packetInfo);
	fBptr->transDescr.packetArrived++;
	(*HRPC_lwpDescr.Signal)(fBptr);
}
