#ifndef rpcSun
#define rpcSun

/*
 * Following are fragmentation flags (must be 2**n)
 */
/* Not all of current segment is in buffer */
#define FRAGINBUF 1

/* Buffer contains part of next segment */
#define NEXTSEGINBUF  2

/* Bit set in count field to denote last segment */
#define LASTSEGTAG 0x80000000

typedef struct {
    struct rpc_msg callHdr;
    int    segSize;   /* Size of current segment */
    int    bufSize;   /* total REMAINING data bytes in buffer */
    int    fragSize;  /* size of current fragment */
    int    fragFlags; /* bitmask of fragmentation flags */
    BufPos countPos;  /* Position of segment count field */
} SunCallInfo;

/* From bufferOps.c */
extern int SetBufPos();
extern int GetBufPos();

/* From sunTcpFrags.c */
extern int SetFragFlags();

#endif
