/* File: /u1/schwartz/HCS/Impl/HRPC/MyProtos/RpcProtos/rpcRawServ.c  Date: 30-Aug-1986  */

/*
 * $Header$
 * INTERFACE:	Implements the server-side routines of the
 *		RAW RPC protocol.  Mostly stolen from
 *		/u1/oystr/HRPC/RpcProtos/rpcSunServ.c.
 *
 * FUNCTION:	See above.
 *
 * IMPORTS:	basicRpc.h
 *
 * EXPORTS:	RawInitIncoming, RawPacketIncoming, RawFinishIncoming,
 *		RawInitReply,	 RawReplyPacket,    RawFinishReply
 *
 * DESIGN:
 *
 * $Log$
 * 30-Aug-1986:	Initial implementation, Mike Schwartz
 */

/*
#include <sys/types.h>
*/
#include <HRPC/basicRpc.h>
/*
#include <HRPC/bufferOps.h>
*/
#include <netinet/in.h>
#include "../Transports/connDefs.h"

/* "forward" definitions */
extern RawPacketIncoming();
extern RawReplyPacket();
extern int AllocateBuffer();

/*
 * Wait for an incoming request message.  The assumption
 * is that the associated socket has already been opened
 * by the export routine.
 */

RawInitIncoming( fBptr, fProgNum, fVersNum, fProcNum,
		 fStatus, fSpare2 )
    HRPCBinding *fBptr;
    long *fProgNum;
    long *fVersNum;
    long *fProcNum;
    int  *fStatus;
    char *fSpare2;
{
    register TransControl *tcptr  = &(fBptr->transDescr);
    
    /*
     * Set OTW direction and snarf a buffer.
     */
    fBptr->otwOp = OTW_DECODE;
    AllocateBuffer( fBptr );

    /*
     * Set call direction.
     */
    if ( (*fStatus = (*tcptr->InitRecv)(fBptr, CONN_SRVCALL)) )
	return;
    
    /*
     * Try to read a packet - loop on timeout.
     */
    while( ! (*tcptr->RecvPacket)(fBptr) ) {
	/* null */
    };

    /*
     * Stuff packet input routine.
     */
    fBptr->rpcDescr.GetPacket = RawPacketIncoming;

    return;
}

/*
 * Handle one incoming packet.  The RPC level routines
 * for this are actually the same for both server and client
 * side - they should actually be factored out and placed
 * in a separate file.  Later for this optimization.
 */

RawPacketIncoming( fBptr )
    HRPCBinding *fBptr;
{
    if ( fBptr->transType == UDPTRANSP ) {
	fatalerr("RawPacketIncoming: can't happen with UDP.\n");
    }
}

/*
 * This routine does absolutely nothing for now.
 */
RawFinishIncoming( fBptr )
    HRPCBinding *fBptr;
{
    (*fBptr->transDescr.FinishRecv)(fBptr, CONN_SRVCALL);
}

/*
 * Routines for sending replies to incoming requests.
 */

RawInitReply( fBptr )
    HRPCBinding *fBptr;
{
    register TransControl *tcptr  = &(fBptr->transDescr);
    
    /*
     * Set direction.
     */
    fBptr->otwOp = OTW_ENCODE;
    AllocateBuffer(fBptr);
    (*tcptr->InitSend)(fBptr, CONN_SRVREPLY);
    
    /* Stuff output routine */
    fBptr->rpcDescr.PutPacket = RawReplyPacket;

    return;
}

RawReplyPacket( fBptr )
    HRPCBinding *fBptr;
{
    if ( fBptr->transType == UDPTRANSP ) {
	/* should not happen if using UDP */
	fatalerr("RawPacketOutgoing: should not happen.\n");
    }
    (*fBptr->transDescr.SendPacket)(fBptr);
}

RawFinishReply( fBptr )
    register HRPCBinding *fBptr;
{
    (*fBptr->transDescr.FinishSend)(fBptr, CONN_SRVREPLY);
}
