/* File: /u1/schwartz/HCS/Impl/HRPC/MyProtos/RpcProtos/rpcRaw.c  Date:  29-Aug-1986  */

/*
 * $Header$
 * INTERFACE:	Implements fake RAW RPC protocol
 *
 * FUNCTION:	See above
 *
 * IMPORTS:	basicRpc.h
 *
 * EXPORTS:	Standard RPC emulation routines
 *
 * DESIGN:	Based mostly on rpcSun.c, gutted of the RPC and authentication
 *		stuff.  See the DESIGN coment in ../Binding/configRAW.c for
 *		more details.
 *
 * DEFECTS:
 * $Log$
 *  29-Aug-1986:	Initial implementation, Mike Schwartz
 *
 *  27-Nov-1986:	Changed to fit new RecvPacket interface. MFS.
 */

#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>
#include <netinet/in.h>
#include "../Transports/connDefs.h"


/* "forward" defs. */
extern RawPacketOutgoing();
extern RawPacketIncoming();
extern RawAnswerPacket();
extern RawReplyPacket();
extern int AllocateBuffer();

RawInitOutgoing( fBptr, fProcedureNum, fVersNum )
    HRPCBinding *fBptr;
    int		 fProcedureNum;
    int		 fVersNum;
{
    register TransControl *tcptr  = &(fBptr->transDescr);
 
    /*
     * Open the connection.
     *		>>>>> WARNING <<<<<
     * Watch out for this call to OpenLink given DTC's
     * BS about "availability". Actually, this is a tough
     * call.
     */
    (*tcptr->OpenLink)( fBptr );
    (*tcptr->InitSend)( fBptr, CONN_CLCALL );
    
    /*
     * Set direction, get a buffer.
     */
    fBptr->otwOp = OTW_ENCODE;
    AllocateBuffer( fBptr );

    fBptr->rpcDescr.PutPacket = RawPacketOutgoing;

    /* No header placed in output buffer: Must be marshalled in by client
       for RAW protocol */
    return;
}

RawPacketOutgoing( fBptr )
    HRPCBinding *fBptr;
{
    if ( fBptr->transType == UDPTRANSP ) {
        /* should not happen if using UDP */
        fatalerr("RawPacketOutgoing: should not happen.\n");
    }
    (*fBptr->transDescr.SendPacket)(fBptr);
}

RawFinishOutgoing( fBptr )
    register HRPCBinding *fBptr;
{
    (*fBptr->transDescr.FinishSend)(fBptr, CONN_CLCALL);
}


/*
 * Following is very nasty due to necessity of implementing
 * retransmit policy at RPC protocol level.  To quote DTC:
 * "This is not right!! Why is it doing this?!?!".
 *		>>>>> WARNING <<<<<
 * Major changes required for tcp adaptation.
 * Also have to redo send/receive buffers in presence of
 * multiple outstanding messages.
 */

#define MAXRECVTRIES 4

RawInitAnswer( fBptr )
    HRPCBinding *fBptr;
{
    int rcvTries, rcvStat;
    int	saveBufSize;
    
    /*
     * Hang around waiting for a reply.
     *		>>>>> WARNING <<<<<
     * If using TCP should check NEXTSEGINBUF flag -
     * no read if more data avail.  Can only happen
     * in LWP environment with multiplexed calls, which
     * means that we need more routing info in packet anyway.
     * Plus major problems, since connection is set up to be
     * one way only (either sending or receiving).
     */
    if ( fBptr->transType == UDPTRANSP ) {
	saveBufSize = fBptr->curBufSize;
    }
    
retry_loop:
    rcvStat = (*fBptr->transDescr.InitRecv)(fBptr, CONN_WREPLY);
    rcvTries = 1;
    
    while ( (rcvStat == HRPC_REPLYTMO) && (rcvTries < MAXRECVTRIES) ) {
	if ( fBptr->transType == UDPTRANSP ) {
	    /*
	     * I will be sorry for doing this...
	     * Restore the old buffer size.  We are counting on
	     * the fact InitRecv will reuse the old buffer
	     * without destroying the contents if the receive
	     * times out.
	     */
	    fBptr->curBufSize = saveBufSize;
	    (*fBptr->transDescr.InitSend)(fBptr, CONN_CLCALL);
	    (*fBptr->transDescr.SendPacket)( fBptr );
	}
	rcvStat = (*fBptr->transDescr.InitRecv)(fBptr, CONN_WREPLY);
	rcvTries++;
    }

    /*
     * Check for timeout.
     */
    if ( (rcvTries >= MAXRECVTRIES) || rcvStat ) {
        struct sockaddr_in *sinp;

	sinp = (struct sockaddr_in *) &fBptr->transDescr.netAddr;
	errmsg("RawInitAnswer: no reply in %d retries, rcvStat 0x%x\n",
		rcvTries,rcvStat);
	fatalerr("   Program# %d @ IP addr %08x.\n",
		 fBptr->ifdPtr->progNum, sinp->sin_addr.s_addr);
    }
	     
    /*
     * Decode the reply.
     */
    fBptr->otwOp = OTW_DECODE;
    fBptr->rpcDescr.GetPacket = RawAnswerPacket;
}

RawAnswerPacket( fBptr )
    HRPCBinding *fBptr;
{
    if ( fBptr->transType == UDPTRANSP ) {
	fatalerr("RawAnswerPacket: can't happen with UDP.\n");
    }
    (*fBptr->transDescr.RecvPacket)(fBptr);
}

RawFinishAnswer( fBptr )
    register HRPCBinding *fBptr;
{
    /*
     * Just free up the per call info for now
     *		>>>>> WARNING <<<<
     * This finishes one call - may still be something
     * in buffer related to next call.  Watch out for
     * this.
     */
    (*fBptr->transDescr.FinishRecv)(fBptr, CONN_CLREPLY);
}

RawCloseRpc( fBptr )
    register HRPCBinding *fBptr;
{
}
