/* File: /u1/oystr/HRPC/RpcProtos/rpcCourServ.c  Date:  7-Oct-1986  */

/*
 * $Header$
 * INTERFACE:	Implements the server-side routines of
 *		the Courier RPC protocol.  See rpcCour.c
 *		and rpcCourClient.c for companion routines
 *		that do the client side.
 *
 * FUNCTION:	See above.
 *
 * IMPORTS:	basicRpc.h + CCS.h +  routines from rpcCourHdrs.c
 *
 * EXPORTS:	CourInitIncoming, CourPacketIncoming, CourFinishIncoming,
 *		CourInitReply,	  CourReplyPacket,    CourFinishReply
 *
 * DESIGN:	Complicated to a large degree by the way Courier
 *		works: auto-activation.
 *
 * $Log$
 *  7-Oct-1986:	Initial implementation, Jan Sanislo
 */

#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>
#include <setjmp.h>
#include "../Transports/connDefs.h"
#include "../RpcProtos/rpcCour.h"
#include "../RpcProtos/courDbg.h"

/* "forward" definitions */
extern CourPacketIncoming();
extern CourReplyPacket();
extern int AllocateBuffer();

/*
 * Generic, protocol-independent incoming routine.
 * Wait for an incoming call message and pull the
 * header apart.
 */
static jmp_buf ciiUnwind;

CourInitIncoming( fBptr, fProgNum, fVersNum, fProcNum,
		  fStatus, fSpare2)
    HRPCBinding *fBptr;
    long *fProgNum;
    long *fVersNum;
    long *fProcNum;
    int  *fStatus;
    char *fSpare2;
{
    register CourCallHdr *callHdr;
    register OtwControl   *otwptr = &(fBptr->otwDescr);
    register TransControl *tcptr  = &(fBptr->transDescr);
    CourCallInfo *cinfo;
    char *ME = "CourInitIncoming";
    HRPCErrRec *errRes;
    memory saveUnwind;
    
mCourDbgMsg((courLogF,"%s starting...\n",ME));

    /*
     * May get a receive unwind so prepare to handle it.
     */
    if (
#ifdef vax
	 ciiUnwind[9] == 0
#endif
#ifdef sun
	 ciiUnwind[14] == 0
#endif
				) {
	if ( errRes = (HRPCErrRec *) setjmp( ciiUnwind ) ) {
	    *fStatus = (int) errRes->hrpcErr;
	    HRPCFreeErr( errRes );
	    fBptr->unwindTo = saveUnwind;
	    return;
	}
    }
    saveUnwind = fBptr->unwindTo;
    fBptr->unwindTo = (memory) ciiUnwind;
    
    /*
     * Allocate/reuse callinfo structure.
     */
    if ( (cinfo = (CourCallInfo *) fBptr->rpcDescr.callState) ==
	    (CourCallInfo *) NULL) {
	cinfo = (CourCallInfo *) calloc( 1, sizeof(CourCallInfo) );
	if ( cinfo == (CourCallInfo *) NULL ) {
	    fatalerr("%s: can't alloc call info\n",ME);
	    /* NOTREACHED */
	}
	fBptr->rpcDescr.callState = (memory) cinfo;
	cinfo->abortseen = FALSE;
	cinfo->bdtState = BDT_WANTDATA;
	cinfo->courState = COUR_WANTVERS;
mCourDbgMsg((courLogF,"  allocated new call info.\n"));

    }

    /*
     * Set OTW & call direction, snarf a buffer.
     */
    fBptr->otwOp = OTW_DECODE;

ResetReceive:
    *fStatus = (*tcptr->InitRecv)(fBptr, CONN_SRVCALL);
    fBptr->unwindTo = saveUnwind;
    if ( *fStatus ) return;

mCourDbgMsg((courLogF,"InitIncoming got packet, state %d.\n",cinfo->courState));
    if ( cinfo->courState == COUR_WANTVERS ) {
	/*
	 * Eat courier version limits if necessary.  This is
	 * VERY tacky, for the following reasons:  If we get
	 * called by a Cornell Courier client, then the first
	 * packet looks like:
	 *	hi version
	 *	lo version
	 *	standard call header
	 * However, if we get called by Xerox Courier, the first
	 * packetS (thats plural) look like:
	 *  P1: hi version
	 *      lo version
	 *  P2: standard call header.
	 * The daemon that forked us has already eaten first packet
	 * and passes us its contents as ARGUMENTS in argc/argc.
	 * Which explains why these programs have command lines
	 * like "4 512 768".  The latter two are the version numbers
	 * (2,3) in network order.  Cornell Courier picks these up
	 * and stuffs them in a pseudo-packet.  We can't since we
	 * do not have access to argv.  Therefore we make the following
	 * crude assumption: If the first two "cardinals" in the
	 * buffer = the expected version numbers then eat them,
	 * otherwise assume that they are not there.
	 */
	Cardinal *junk;
	Cardinal ozone;
	
	junk = (Cardinal *) fBptr->curBufMark;
	if ( ( (*junk == 512) || (*junk == 768) ) &&
	     (*(junk+1) == 768 ) ) {
	    (*fBptr->otwDescr.Cardinal)(fBptr,&ozone);
	    (*fBptr->otwDescr.Cardinal)(fBptr,&ozone);
mCourDbgMsg((courLogF,"Ate version numbers.\n"));
	}
	/*
	 * Version numbers can arrive as separate packet with EOM set.
	 * May have to read more.
	 *
	 *		>>>> WARNING <<<< >>>> WARNING <<<<
	 * As of now (11/3/86), the courier daemon that spawned
	 * this process takes care of sending the version numbers,
	 * so we do not have to worry about it.  Note that this
	 * will probably be a problem later on.
        cinfo->courState = COUR_SENDVERS;
	 */
	cinfo->courState = COUR_INPROG;
	if ( fBptr->curBufSize == 0 ) {
mCourDbgMsg((courLogF,"**Doing receive reset.\n"));
	    goto ResetReceive;
	}
    }
    
    /*
     * Get the header.
     */
    if ( CourRpcHdr( fBptr, &cinfo->genericHdr ) != COUR_CALLMSG ) {
	fatalerr("%s: bad call header.\n",ME);
	/* NOTREACHED */
    }
    /*
     * Looks OK, send back results.
     */
    callHdr = &(cinfo->genericHdr.courCall);
    *fProgNum = (long) callHdr->courProgN;
    *fVersNum = (long) callHdr->courVersN;
    *fProcNum = (long) callHdr->courProcN;
mCourDbgMsg((courLogF,"Got call for %d/%d/%d.\n",*fProgNum,*fVersNum,*fProcNum));

    /*
     * Stuff packet input routine.
     */
    fBptr->rpcDescr.GetPacket = CourPacketIncoming;
    return;
}

CourPacketIncoming( fBptr )
    register HRPCBinding *fBptr;
{
    (*fBptr->transDescr.RecvPacket)( fBptr );
mCourDbgMsg((courLogF,"CourPacketIncoming.\n"));
}

CourFinishIncoming( fBptr )
{
    /* Nothing for now */
mCourDbgMsg((courLogF,"CourFinishIncoming\n"));
}

CourInitReply( fBptr )
    HRPCBinding *fBptr;
{
    register OtwControl   *otwptr = &(fBptr->otwDescr);
    register TransControl *tcptr  = &(fBptr->transDescr);
    CourCallInfo *cinfo = (CourCallInfo *) fBptr->rpcDescr.callState;
    CourCallHdr *callHdr;
    
mCourDbgMsg((courLogF,"CourInitReply\n"));
    /*
     * Set direction.
     */
    fBptr->otwOp = OTW_ENCODE;
    AllocateBuffer( fBptr );
    (*tcptr->InitSend)( fBptr, CONN_SRVREPLY );

    if ( cinfo->courState == COUR_SENDVERS ) {
	Cardinal junk;
mCourDbgMsg((courLogF,"Sending version numbers.\n"));
	junk = COURIERVERSION;
	(*otwptr->Cardinal)(fBptr,&junk);
	(*otwptr->Cardinal)(fBptr,&junk);
	cinfo->courState = COUR_INPROG;
    }
    
    /* Stuff reply message type and transID */
    callHdr = &(cinfo->genericHdr.courCall);
    /* watch out... replacing msg type in place */
    callHdr->courMsgType = COUR_REPLYMSG;
    (*otwptr->Cardinal)( fBptr, &callHdr->courMsgType );
    (*otwptr->Unspecified) ( fBptr, &callHdr->courTransID );

    /* Set up for next packet send */
    fBptr->rpcDescr.PutPacket = CourReplyPacket;
}

CourReplyPacket( fBptr )
    register HRPCBinding *fBptr;
{
    (*fBptr->transDescr.SendPacket)( fBptr );
mCourDbgMsg((courLogF,"CourReplyPacket.\n"));

}

CourFinishReply( fBptr )
    register HRPCBinding *fBptr;
{
    (*fBptr->transDescr.FinishSend)( fBptr, CONN_SRVREPLY );
mCourDbgMsg((courLogF,"CourFinishReply\n"));
}
