/* File: /u1/oystr/HRPC/RpcProtos/rpcCourHdrs.c  Date:  8-Oct-1986  */

/*
 * $Header$
 * INTERFACE:	CourRpcHdr	
 *
 * FUNCTION:	Encode/Decode a Courier rpc header structure.
 *
 * IMPORTS:	basicRpc.h, rpcCour.h
 *
 * EXPORTS:	CourRpcHdr( fBptr, fGenericHdr )
 *
 * DESIGN:	Return the "type" of the header encoded/decoded.
 *		There are several types of headers we can get
 *		depending on the result of the call.
 */

/*
 * $Log:	rpcclient.c,v $
 * Revision 2.0  86/10/08  12:40:29 oystr
 * Major rewrite.  Almost nothing left from original implementation
 * by Dennis Ching (which mainly consisted of stuff lifted from
 * the Cornell Courier library.
 *
 */

#include <HRPC/basicRpc.h>
#include "../RpcProtos/rpcCour.h"

/* 
 * Returns the "type" of the header that is encoded/decoded.
 */

int CourRpcHdr(fBptr, fGenericHdr)
    HRPCBinding *fBptr;
    CourGenericHeader *fGenericHdr;
{
    register OtwControl *otwptr = &(fBptr->otwDescr);
    int retval;
    CourCallHdr *callhdr;
    CourReplyHdr *replyhdr;
    CourAbortHdr *abhdr;
    CourRejectHdr *rejhdr;

    replyhdr = (CourReplyHdr *) &(fGenericHdr->courReply);
    /*
     * Do message type
     */
    (*otwptr->Cardinal)(fBptr, &replyhdr->courMsgType);
    retval = replyhdr->courMsgType;
    (*otwptr->Unspecified)(fBptr, &replyhdr->courTransID);

    switch (retval) {
	case COUR_REPLYMSG:
	    break;

	case COUR_CALLMSG:
	    callhdr = (CourCallHdr *) replyhdr;
	    (*otwptr->LongCardinal)(fBptr, &callhdr->courProgN);
	    (*otwptr->Cardinal)(fBptr, &callhdr->courVersN);
	    (*otwptr->Cardinal)(fBptr, &callhdr->courProcN);
	    break;

	case COUR_REJECTMSG:
	    rejhdr = (CourRejectHdr *) replyhdr;
	    (*otwptr->Cardinal)(fBptr, &rejhdr->rejectCode);
	    if ( (int) rejhdr->rejectCode == COUR_BADVERS ) {
		(*otwptr->Cardinal)(fBptr, &(rejhdr->loVers));
		(*otwptr->Cardinal)(fBptr, &(rejhdr->hiVers));
	    }
	    break;

	case COUR_ABORTMSG:
	    abhdr = (CourAbortHdr *) replyhdr;
	    (*otwptr->Cardinal)(fBptr, &abhdr->errorValue);
	    break;

	default:
	    fatalerr("Unknown Courier RPC message type: %d.\n",retval);
	    /*NOTREACHED*/
    }
    return( retval );
}

/*
 * Used to be called from RPC client stub but
 * is now probably obsolete.  Left here for documentation
 * purposes only.
 *###/
MaybeCallBDTHandler(fBptr, BDTproc)
    HRPCBinding *fBptr;	/* socket descriptor *###/
    int (*BDTproc)();
{
    CourCallInfo *callState;

    callState = (CourCallInfo *) fBptr->rpcDescr.callState;

    /*
     * can't look ahead here, since server may be expecting us to send
     * lots of data before he does anything
     *###/
    callState->abortseen = FALSE;

    /* ### setup interrupt handler for URGENT messages *###/
    if (BDTproc != NULL) {
	(*BDTproc)(fBptr);
    }
    /* ### clear interrupt handler *###/
    callState->bdtState = BDT_WANTDATA;
}
*****/


