/* File: /u1/oystr/HRPC/HRpcRTS/RpcProtos/rpcCour.c  Date:  1-Mar-1986  */

/*
 * $Header: rpcCour.c,v 2.0 86/10/08 15:07:29 oystr Exp $
 * INTERFACE:    Implements fake Courier RPC protocol
 *
 * FUNCTION:    See above
 *
 * IMPORTS:	basicRpc.h
 *		rpcCour.h
 *
 * EXPORTS:	Standard RPC emulation routines
 *
 * DESIGN:	Why not.
 *
 * $Log:	rpcCour.c,v $
 * Revision 2.0  86/10/08  10:46:53  oystr
 * Major rewrite to get rid of lingering transport
 * dependencies.
 *
 * Revision 1.7  86/06/13  12:53:54  oystr
 * General clean up during merge.
 *
 * Revision 1.6  86/04/03  15:07:29  dtc
 * dunno what I changed
 * 
 * Revision 1.4  86/03/31  20:37:16  dtc
 * working "lawnmower" version, client side only
 * 
 * Revision 1.2  86/03/28  15:14:08  dtc
 * version with "lawnmower" for client message transmission
 * 
 *  1-Mar-1986:    Initial implementation, Jan Sanislo
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>
#include "../RpcProtos/rpcCour.h"
#include "../Transports/connDefs.h"
extern int AllocateBuffer();

CourInitOutgoing( fBptr, fProcedureNum, fVersNum )
    HRPCBinding *fBptr;
    int     fProcedureNum;
    int	    fVersNum;
{
    register CourCallInfo *callState =
		(CourCallInfo *) fBptr->rpcDescr.callState;
    register RpcControl   *rpcptr = &(fBptr->rpcDescr);
    OtwControl   *otwptr = &(fBptr->otwDescr);
    register TransControl *tcptr  = &(fBptr->transDescr);
    register CourCallHdr *callhdr;
    CourCallInfo *nrcall;
    static Cardinal ourCVersion = COURIERVERSION;
    static Cardinal callMsgType = COUR_CALLMSG;

    if ( callState == (CourCallInfo *) NULL ) {
	callState = (CourCallInfo *) calloc(1, sizeof(CourCallInfo));
	if ( callState == (CourCallInfo *) NULL ) {
	    fatalerr("CourInitOutgoing: cannot alloc callState.\n");
	}
	rpcptr->callState = (memory) callState;
	callState->courState = COUR_CLOSED;
	callState->abortseen = FALSE;
	callState->bdtState = BDT_WANTDATA;
    }
    nrcall = callState;

    /*
     * Open the connection.
     */
    if (callState->courState == COUR_CLOSED) {
	(*tcptr->OpenLink)( fBptr );
	callState->courState = COUR_WANTVERS;
    }

    /*
     * Set direction, get a buffer.
     */
    fBptr->otwOp = OTW_ENCODE;
    AllocateBuffer( fBptr );


    /*
     * Stuff into the packet-dispatching procedure pointers the appropriate
     * routines.
     */
    rpcptr->PutPacket = rpcptr->PacketOutgoing;
    rpcptr->GetPacket = rpcptr->AnswerPacket;

    /*
     * Generate headers in place, once per RPC.
     *
     * Initialize the transport header
     */
    if( (*tcptr->InitSend)( fBptr, CONN_CLCALL ) ) {
	callState->courState = COUR_WANTVERS;
    }
    
    if (callState->courState == COUR_WANTVERS) {
        /* exchange version numbers */
        (*otwptr->Cardinal)(fBptr, &ourCVersion);
        (*otwptr->Cardinal)(fBptr, &ourCVersion);
    }
    /*
     * XXX direct otw calls would be faster,
     * but we are saving a copy of the header.
     * This may be unnecessary also (we really only
     * need the TID for LWP dispatching purposes.
     * For now we will do things the dumb, stupid way.
     * May also be necessary to save the whole thing since
     * we are not supposed to *know* that we are using a
     * reliable protocol.
     */
    callhdr = (CourCallHdr *) &(nrcall->genericHdr.courCall);
    callhdr->courMsgType = COUR_CALLMSG;
    callhdr->courTransID = (Unspecified) (getpid() ^ random());
    callhdr->courProgN = fBptr->bndProgNum;
    callhdr->courVersN = (Cardinal) fVersNum;
    callhdr->courProcN = (Cardinal) fProcedureNum;
    CourRpcHdr( fBptr, callhdr );
    /*
     * Header encoded in output buffer, done here.
     */
}

CourPacketOutgoing( fBptr )
    register HRPCBinding *fBptr;
{
    (*fBptr->transDescr.SendPacket)(fBptr);
}

CourFinishOutgoing( fBptr )
    register HRPCBinding *fBptr;
{
    register CourCallInfo *callState =
		(CourCallInfo *) fBptr->rpcDescr.callState;

    (*fBptr->transDescr.FinishSend)( fBptr, CONN_CLCALL );
    /* 
     * XXX why is this an 'if' statement???
     * what the hell is this stuff???
    if (callState->courState == COUR_CALLDONE)
	callState->courState = COUR_INPROG;
     */
}

CourInitAnswer( fBptr )
    HRPCBinding *fBptr;
{
    register TransControl *tcptr  = &(fBptr->transDescr);
    CourGenericHeader genericHdr;
    register CourCallHdr *callhdr;
    CourCallInfo *callState = (CourCallInfo *) fBptr->rpcDescr.callState;
    int msgType;

    /* set up for decoding resultant message */
    fBptr->otwOp = OTW_DECODE;

ResetReceive:
    /* initialize the transport for reception */
    (*tcptr->InitRecv)(fBptr, CONN_WREPLY);

    if ( callState->courState == COUR_WANTVERS ) {
	Cardinal junk;
	OtwControl *otwptr;

	otwptr = &(fBptr->otwDescr);
        (*otwptr->Cardinal)(fBptr, &junk);
	(*otwptr->Cardinal)(fBptr, &junk);
	callState->courState = COUR_INPROG;
	/*
	 * 	>>>> WARNING <<<<
	 * Versions can appear as a separate packet with EOM set.
	 * If there is nothing left in the buffer, assume
	 * that this is the case and reset receive state.
	 */
	if ( fBptr->curBufSize == 0 ) goto ResetReceive;
    }
    
    callhdr = (CourCallHdr *) &callState->genericHdr.courCall;
    msgType = CourRpcHdr( fBptr, &genericHdr );
    if ( msgType == COUR_REPLYMSG ) {
	if ( callhdr->courTransID != genericHdr.courCall.courTransID ) {
	    errmsg("Courier call/reply id mismatch.\n");
	    goto eat_hot_lead_and_die;
	}
	return;
    }

    if ( msgType == COUR_ABORTMSG ) {
	CourAbortHdr *abHdr;

	abHdr = (CourAbortHdr *) &genericHdr;
	errmsg("Courier Call aborted, error number %d.\n",
		abHdr->errorValue );
    }
    else
    if ( msgType == COUR_REJECTMSG ) {
        CourRejectHdr *rejHdr;
	int hrpcCode;

	rejHdr = (CourRejectHdr *) &genericHdr;
	switch ( rejHdr->rejectCode ) {
	    case COUR_BADPROGN:
		hrpcCode = HRPC_BADPROGN;
		break;
	    case COUR_BADPROCN:
		hrpcCode = HRPC_BADPROCN;
		break;
	    case COUR_INVALARG:
		hrpcCode = HRPC_BADPARAM;
		break;
	    case COUR_BADVERS:
		hrpcCode = HRPC_BADVERSN;
		break;
	} /* switch */
	longjmp( fBptr->unwindTo, NewHRPCErrRec( hrpcCode, 0 ) );
    }

eat_hot_lead_and_die:
    fatalerr("...while trying to call Prog %d, Proc %d, Vers %d.\n",
	callhdr->courProgN,callhdr->courProcN,callhdr->courVersN);
    /*NOTREACHED*/
}

CourAnswerPacket( fBptr )
    register HRPCBinding *fBptr;
{
    (*fBptr->transDescr.RecvPacket)(fBptr);
}

CourFinishAnswer( fBptr )
    register HRPCBinding *fBptr;
{
    /*
     * Do nothing for now.  Should probably set
     * connection state to e.g. idle.
    (void) free( fBptr->rpcDescr.callState );
    fBptr->rpcDescr.callState = (memory) NULL;
     */
}

CourCloseRpc( fBptr )
    register HRPCBinding *fBptr;
{
    if ( fBptr->rpcDescr.callState != (memory) NULL ) {
	free( fBptr->rpcDescr.callState );
	fBptr->rpcDescr.callState = (memory) NULL;
    }
}
