/* File: /u1/oystr/HRPC/HRpcRTS/otwCour.c  Date:  2-Mar-1986  */

/*
 * $Header: otwCour.c,v 1.6 86/04/09 13:04:31 dtc Exp $
 * INTERFACE:	Several - see procedure definitions.
 *
 * FUNCTION:	Marshalling routines XDR style.
 *
 * IMPORTS:	Basic rpc definitions.
 *
 * EXPORTS:	Many routines.
 *
 * DESIGN:	Direct rip off from SUN XDR routines.
 *		There probably should be a copyright notice
 *		from them in here.
 *
 * DEFICIENCIES: Many - mainly related to assumptions made about
 *		 the storage allocation for Courier types in
 *		 the application language.
 * $Log:	otwCour.c,v $
 * Revision 1.7  86/06/13  11:00:00  oystr
 * General clean up during merge.
 *
 * Revision 1.6  86/04/09  13:04:31  dtc
 * haven't the foggiest what I changed
 * 
 * Revision 1.5  86/04/03  15:13:05  dtc
 * added a conditionally compiled clause for trying Jan's in-line hack for
 * htons(), et. al.
 * 
 * Revision 1.3  86/03/31  20:38:15  dtc
 * working "lawnmower" version, client side only
 * 
 * Revision 1.2  86/03/28  15:16:23  dtc
 * version with "lawnmower" for client message transmission
 * 
 * Revision 1.1  86/03/27  08:33:25  dtc
 * Initial revision
 * 
 *  2-Mar-1986:	Initial implementation, Jan Sanislo
 * 24-Mar-1986: Modified for Courier over-the-wire format, Dennis Ching
 */

#include <HRPC/basicRpc.h>

/*
 * Low-level byte moving, with byte-swapping.
 * Use these definitions for VAX and other low-enders.
 */
#ifdef vax
#define htocb(a,b) (*((char *)(b)+1) = *(char *)(a))

#define ctohb(a,b) (*(char *)(b) = *((char *)(a)+1))

#define htocs(a,b) (*((char *)(b)+1) = *(char *)(a),\
		    *(char *)(b) = *((char *)(a)+1))

#define ctohs(a,b) (*(char *)(b) = *((char *)(a)+1),\
		    *((char *)(b)+1) = *(char *)(a))

#define htocl(a,b) (*(char *)(b) = *((char *)(a)+3),\
		    *((char *)(b)+1) = *((char *)(a)+2),\
		    *((char *)(b)+2) = *((char *)(a)+1),\
		    *((char *)(b)+3) = *(char *)(a))

#define ctohl(a,b) (*((char *)(b)+3) = *(char *)(a),\
		    *((char *)(b)+2) = *((char *)(a)+1),\
		    *((char *)(b)+1) = *((char *)(a)+2),\
		    *(char *)(b) = *((char *)(a)+3) )
#endif

/*
 * Should be "defined(sun) || defined(ibm032)"
 * but the 'defined' contstruct is not recognized on
 * Pegusi.
 */
#ifdef ibm032
#define sun
#endif

#ifdef sun
#define htocb(a,b) (*((char *)(b)+1) = *(char *)(a))

#define ctohb(a,b) (*(char *)(b) = *((char *)(a)+1))

#define htocs(a,b) (*(short *)(b) = *(short *)(a))

#define ctohs(a,b) (*(short *)(b) = *(short *)(a))

#define htocl(a,b) (*(long *)(b) = *(long *)(a))

#define ctohl(a,b) (*(long *)(b) = *(long *)(a))
#endif

#ifdef ibm032
#undef sun
#endif

/*
 * Alignment control, for strings, etc.
 * This is 4 for XDR and 2 for COURIER.
 */
#define ALIGNSIZE 2

CourDeallocate( fBptr )
    register HRPCBinding *fBptr;
{
    /* Do nothing for now */
}

/*
 * Special routine to translate 16-bit
 * Courier count fields <-> integers.
 */

CourCountField( fBptr, fCount )
    register HRPCBinding *fBptr;
    register int *fCount;
{
    Cardinal wiresize;

    if ( fBptr->otwOp != OTW_DECODE ) {
	wiresize = (Cardinal) *fCount;
	if ( wiresize != *fCount ) {
	    fatalerr("CourCountField: size too large - %d.\n",*fCount);
	}
    }
    CourCardinal( fBptr, &wiresize );
    if ( fBptr->otwOp == OTW_DECODE ) {
	*fCount = (int) wiresize & 0xFFFF;
    }
}

CourLongCardinal( fBptr, lp)
    register HRPCBinding *fBptr;
    register LongCardinal *lp;
{
    register memory ptr;

    if ( fBptr->otwOp == OTW_FREE ) return;
    
    if ((fBptr->curBufSize - sizeof(LongCardinal)) < 0) {
	if ( fBptr->otwOp == OTW_ENCODE ) {
	    (*fBptr->rpcDescr.PutPacket)( fBptr );
	}
	else {
	    LongCardinal tmp;

	    OtwNeedBytes( fBptr, sizeof(LongCardinal) - fBptr->curBufSize,
			  &tmp );
	    ctohl(&tmp,lp);
	    return;
	}
    }

    ptr = fBptr->curBufMark;
    if (fBptr->otwOp == OTW_DECODE) {
	ctohl(ptr,lp);
    }
    else {
	htocl(lp,ptr);
    }
    fBptr->curBufMark += sizeof(LongCardinal);
    fBptr->curBufSize -= sizeof(LongCardinal);
}

CourCardinal( fBptr, lp)
    register HRPCBinding *fBptr;
    register Cardinal *lp;
{
    register memory ptr;

    if ( fBptr->otwOp == OTW_FREE ) return;

    if ((fBptr->curBufSize - sizeof(Cardinal)) < 0) {
	if ( fBptr->otwOp == OTW_ENCODE ) {
	    (*fBptr->rpcDescr.PutPacket)( fBptr );
	}
	else {
	    Cardinal tmp;

	    OtwNeedBytes( fBptr, sizeof(Cardinal) - fBptr->curBufSize,
			  &tmp );
	    ctohs(&tmp,lp);
	    return;
	}
    }

    ptr = fBptr->curBufMark;
    if (fBptr->otwOp == OTW_DECODE) {
	ctohs(ptr,lp);
    }
    else {
	htocs(lp,ptr);
    }
    fBptr->curBufMark += sizeof(Cardinal);
    fBptr->curBufSize -= sizeof(Cardinal);
}

CourInteger( fBptr, lp)
    register HRPCBinding *fBptr;
    register Integer *lp;
{
    register memory ptr;

    if ( fBptr->otwOp == OTW_FREE ) return;

    if ((fBptr->curBufSize - sizeof(Integer)) < 0) {
	if ( fBptr->otwOp == OTW_ENCODE ) {
	    (*fBptr->rpcDescr.PutPacket)( fBptr );
	}
	else {
	    Integer tmp;

	    OtwNeedBytes( fBptr, sizeof(Integer) - fBptr->curBufSize,
			  &tmp );
	    ctohs(&tmp,lp);
	    return;
	}
    }

    ptr = fBptr->curBufMark;
    if (fBptr->otwOp == OTW_DECODE) {
	ctohs(ptr,lp);
    }
    else {
	htocs(lp,ptr);
    }
    fBptr->curBufMark += sizeof(Integer);
    fBptr->curBufSize -= sizeof(Integer);
}

CourLongInteger( fBptr, lp)
    register HRPCBinding *fBptr;
    register LongInteger *lp;
{
    register memory ptr;

    if ( fBptr->otwOp == OTW_FREE ) return;

    if ((fBptr->curBufSize - sizeof(LongCardinal)) < 0) {
	if ( fBptr->otwOp == OTW_ENCODE ) {
	    (*fBptr->rpcDescr.PutPacket)( fBptr );
	}
	else {
	    LongInteger tmp;

	    OtwNeedBytes( fBptr, sizeof(LongInteger) - fBptr->curBufSize,
			  &tmp );
	    ctohl(&tmp,lp);
	    return;
	}
    }

    ptr = fBptr->curBufMark;
    if (fBptr->otwOp == OTW_DECODE) {
	ctohl(ptr,lp);
    }
    else {
	htocl(lp,ptr);
    }
    fBptr->curBufMark += sizeof(LongInteger);
    fBptr->curBufSize -= sizeof(LongInteger);
}

CourUnspecified( fBptr, lp)
    register HRPCBinding *fBptr;
    register Unspecified *lp;
{
    register memory ptr;

    if ( fBptr->otwOp == OTW_FREE ) return;

    if ((fBptr->curBufSize - sizeof(Unspecified)) < 0) {
	if ( fBptr->otwOp == OTW_ENCODE ) {
	    (*fBptr->rpcDescr.PutPacket)( fBptr );
	}
	else {
	    Unspecified tmp;

	    OtwNeedBytes( fBptr, sizeof(Unspecified) - fBptr->curBufSize,
			  &tmp );
	    *lp = tmp;
	    return;
	}
    }

    ptr = fBptr->curBufMark;
    if (fBptr->otwOp == OTW_DECODE) {
	*lp = *(Unspecified *) ptr;
    }
    else {
	*(Unspecified *) ptr = *lp;
    }
    fBptr->curBufMark += sizeof(Unspecified);
    fBptr->curBufSize -= sizeof(Unspecified);
}

CourLongUnspecified( fBptr, lp)
    register HRPCBinding *fBptr;
    register LongUnspecified *lp;
{
    register memory ptr;

    if ( fBptr->otwOp == OTW_FREE ) return;

    if ((fBptr->curBufSize - sizeof(LongCardinal)) < 0) {
	if ( fBptr->otwOp == OTW_ENCODE ) {
	    (*fBptr->rpcDescr.PutPacket)( fBptr );
	}
	else {
	    LongUnspecified tmp;

	    OtwNeedBytes( fBptr, sizeof(LongUnspecified) - fBptr->curBufSize,
			  &tmp );
	    *lp = tmp;
	    return;
	}
    }

    ptr = fBptr->curBufMark;
    if (fBptr->otwOp == OTW_DECODE) {
	*lp = *(LongUnspecified *) ptr;
    }
    else {
	*(LongUnspecified *) ptr = *lp;
    }
    fBptr->curBufMark += sizeof(LongUnspecified);
    fBptr->curBufSize -= sizeof(LongUnspecified);
}

CourBoolean( fBptr, lp)
    register HRPCBinding *fBptr;
    register Boolean *lp;
{
    register memory ptr;

    if ( fBptr->otwOp == OTW_FREE ) return;

    if ((fBptr->curBufSize - sizeof(Unspecified)) < 0) {
	if ( fBptr->otwOp == OTW_ENCODE ) {
	    (*fBptr->rpcDescr.PutPacket)( fBptr );
	}
	else {
	    Unspecified tmp;

	    OtwNeedBytes( fBptr, sizeof(Unspecified) - fBptr->curBufSize,
			  &tmp );
	    ctohb(&tmp,lp);
	    return;
	}
    }

    ptr = fBptr->curBufMark;
    if (fBptr->otwOp == OTW_DECODE) {
	ctohb(ptr, lp);
    }
    else {
	htocb(lp,ptr);
    }
    fBptr->curBufMark += sizeof(Unspecified);
    fBptr->curBufSize -= sizeof(Unspecified);
}

/*
 * Some nastiness involving enumerations -
 * these are represented as 16 bits over-the-wire
 * but 32-bits internally.  This is actually
 * a C language hassle.
 */

CourEnumeration( fBptr, fValue )
    register HRPCBinding *fBptr;
    LongCardinal *fValue;
{
    Cardinal tmp;

    if ( fBptr->otwOp == OTW_FREE ) return;

    if ( fBptr->otwOp == OTW_ENCODE ) {
	if ( *fValue > 65536 ) {
	    fatalerr("CourEnumeration: value too large (%d).\n",*fValue);
	    /*NOTREACHED*/
	}
	tmp = (Cardinal) *fValue;
	CourCardinal( fBptr, &tmp );
    }
    else {
	CourCardinal( fBptr, &tmp );
	*fValue = (LongCardinal) tmp;
    }
}

CourString( fBptr, fString )
    register HRPCBinding *fBptr;
    String	*fString;
{
    char *sp = *fString;
    register int n;
    int size, nodesize;
    register memory ptr;
    
    if ( fBptr->otwOp == OTW_FREE ) {
	free( *fString );
	return;
    }

    if ( fBptr->otwOp != OTW_DECODE )
	size = strlen( sp );
    CourCountField( fBptr, &size ); /* read/write size */
    nodesize = size + 1; /* for 0-byte terminator */
    
    switch( fBptr->otwOp ) {
	case OTW_DECODE:
	    *fString = sp = (char *) malloc( nodesize );
	    if ( sp == (char *) 0 )
		fatalerr("CourString: can't alloc string space.\n");
	    sp[size] = (char) 0;
	    if ( size > 0 ) {
	        ptr = fBptr->curBufMark;
		n = size;
		while (--n >= 0)
		    if (*ptr++ == '\000')
			*--ptr = '\200';
				/* convert to C format, translating \000 to
				   \0200 and terminating on count */
	        OtwByteCopy( fBptr, (memory) sp, size, ALIGNSIZE );
	    }
	    return;

	case OTW_ENCODE:
	    /*
	     * Should be CourStringCopy in order to do
	     * character translation.
	     */
	    if ( size > 0 ) {
	        ptr = sp;
		n = size;
		while (--n >= 0)
		    if (*ptr++ == '\200')
			*--ptr = '\0';
				/* convert to counted-sequence format,
				   translating \0200 to \000 */
	        OtwByteCopy( fBptr, (memory) sp, size, ALIGNSIZE );
	    }
	    return;

	case OTW_FREE:
	    if ( sp != (char *) NULL ) {
		free( sp );
		*fString = (char *) NULL;
	    }
    }
}


CourArray( fBinding, fAddr, fArrSize, fEltSize, fComp )
    register HRPCBinding *fBinding;
    memory fAddr;
    int fArrSize;
    int fEltSize;
    int (*fComp)();
{
    register memory target = fAddr;
    register int i;

    /* XXX deprecated: never allocate anything of fixed size.
     * To reinstall change definition of "memory fAddr" to "memory *fAddr".
     * But first change the stub compiler so it will pass you the
     * right thing.
     * Allocate memory based on fAddr != NULL
     *
    if ( target == (memory) NULL ) {
	if ( fBinding->otwOp == OTW_FREE ) return;
	if ( fBinding->otwOp == OTW_DECODE ) {
	    *fAddr = target = (memory) calloc( fArrSize * fEltSize, 1 );
	    if ( target == (memory) NULL ) {
		fatalerr("CourArray: can't get memory for %d * %d bytes.\n",
			 realSize, fEltSize);
	    }
	}
    }
     * XXX */

    /*
     * Churn through, one element at a time.
     */
    for ( i = 0; i < fArrSize; i++ ) {
	(*fComp)(fBinding, target );
	target += fEltSize;
    }
}

CourSequence( fBinding, fAddr, fArrSize, fMaxSize, fEltSize, fComp )
    register HRPCBinding *fBinding;
    memory *fAddr;
    Cardinal *fArrSize;
    int    fMaxSize;
    int    fEltSize;
    int    (*fComp)();
{
    int realSize;
    register memory target = *fAddr;
    register int i;
    char *ME = "CourSequence:";
    
    if ( fBinding->otwOp == OTW_FREE ) {
	if ( *fArrSize <= 0 ) return;
	realSize = (int) *fArrSize;
	goto churn;
    }

    realSize = (int) *fArrSize;
    CourCountField( fBinding, &realSize );
    *fArrSize = (Cardinal) realSize;
    if ( *fArrSize < 0 ) {
	fatalerr("%s negative size: %d.\n", ME, *fArrSize);
    }
    if ( *fArrSize == 0 ) return; /* guessing 0 length is ok */
    if ( *fArrSize > fMaxSize ) {
	fatalerr("%s max size exceeded: %d > %d.\n",ME,*fArrSize,
		  fMaxSize);
    }
	      
    /*
     * Always allocate on DECODE, never allocate on ENCODE.
     */
    if ( fBinding->otwOp == OTW_DECODE ) {
	*fAddr = target = (memory) calloc( realSize * fEltSize, 1 );
	if ( target == (memory) NULL ) {
	    fatalerr("%s can't get memory for %d * %d bytes.\n",ME,
		 realSize, fEltSize);
	}
    }

    /*
     * Churn through, one element at a time.
     */
churn:
    for ( i = 0; i < realSize; i++ ) {
	(*fComp)(fBinding, target );
	target += fEltSize;
    }
    if ( fBinding->otwOp == OTW_FREE ) {
	free(*fAddr);
    }
}

CourError()
{
    abort();
}

CourNilRecord()
{
    /* do absolutely nothing */
}

/*
 * Semi-dummy for now.
 */
/*ARGSUSED*/
CourCloseOtw( fBptr )
    HRPCBinding *fBptr;
{
}

/*
 * 		>>>>> WARNING <<<<
 * Following three procedures are never called
 * directly.  Their function is performed by routines
 * generated by the stub compiler.
 */

CourRecord()
{
    abort();
}

CourProcedure()
{
    abort();
}

CourChoice()
{
    abort();
}
