/*LINTLIBRARY*/
/* File:  transp.c  Date:  1/23/87  Kimi Gosney  */

/*
 * INTERFACE:	
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 *
 *
 *
 * $Log:	transp.c,v $
 * Revision 1.1  87/06/30  21:34:41  kimi
 * Initial revision
 * 
 * Revision 1.2  87/06/29  19:10:25  kimi
 * *** empty log message ***
 * 
 * Revision 1.1  87/05/25  19:40:53  kimi
 * Initial revision
 * 
 * Revision 1.8  87/04/21  11:48:30  kimi
 * works with new-runtime, but without support for setjmp.
 * helpserver.o works for ltest6 and lower.
 * 
 * Revision 1.6  87/03/18  23:04:26  kimi
 * about to try new run-time
 * 
 * Revision 1.5  87/02/15  20:57:16  kimi
 * working version with ltest3 (strings/int)
 * 
 * Revision 1.4  87/02/15  15:46:23  kimi
 * this version worked with clients, being reworked for servers.
 * 
 * Revision 1.3  87/01/28  20:41:52  kimi
 * this works with strings, simple, using vectori. with chatty debugging code.
 * 
 * Revision 1.2  87/01/25  19:59:59  kimi
 * IntegerTransport works with retval/litserv (ltest, ltest2)
 * It is being reworked for ltest3, since strings are a problem
 * 
 *
 */

#include <stdio.h>
#include <setjmp.h>
#include "HRPC/basicRpc.h"
#include "HRPC/hrpcErrCodes.h"
extern int XdrLongCardinal(), CourCountField(); 
       /* from /usr/src/local/HRPC/OtwReps/otw{Sun,Cour}.c  */
extern char *strbuf;	/* from /usr/src/ucb/franz/data.c */
extern char *newstr();



int debug = 0;		/* initialize to false */
                        /* mostly not checked if compiled without
			   DEBUGLISP flag, except in OtwListLength */

void                    /* called by lisp stubs */
setdebug( wantdebug)
   int wantdebug;
   { debug = wantdebug;
#ifdef DEBUGLISP
     printf ("debug is %d\n", debug);
     fflush (stdout);
#endif
   };


/**********************************************************/



long
EnumTransport ( fBinding, tell_jmp, otwTypeNumber )
     HRPCBinding **fBinding;
     long tell_jmp[];
     long *otwTypeNumber;

{ LongCardinal tmpint;
  HRPCErrRec *errRes;
  jmp_buf Unwind;
  
#ifdef DEBUGLISP
  if (debug) {
    
    printf ("calling EnumTransport with typenumber of %ld\n", *otwTypeNumber);
    fflush (stdout);
  };
#endif

/*NOSTRICT*/
  if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
    tell_jmp[0] = (long)(errRes->hrpcErr);
    return (0);
  }

  (*fBinding)->unwindTo = (memory) Unwind;
  tmpint = (LongCardinal)(*otwTypeNumber);
  (*((*fBinding)->otwDescr).Enumeration)( (*fBinding), &tmpint);
  tell_jmp[0] = 0;   /* ie. HRPC_NORMAL */
  return ((long)tmpint);

};


/********************************************************************/

/* we cannot use fString again because of the malloc() by the run-time.
   After the call to run-time, it points to C space.
   we cannot copy into the old fString, because the Lisp structure that was 
   passed in is of fixed length, and if we overwrite its end, we stomp
   on other stuff.
*/

char *
StringTransport ( fBinding, tell_jmp, fString )
     HRPCBinding **fBinding;
     long tell_jmp[2];
  char *fString;

{ char *tmpstr = " ";
  HRPCErrRec *errRes;
  jmp_buf Unwind;

				/* XdrString malloc()s its return space */
#ifdef DEBUGLISP
   if (debug) {
   if (fString) {
       printf ("in StringTransport\n fString= %s\n",
   	fString);
   } else {
       fString = tmpstr;
       printf ("null input string\n");
   };
   fflush (stdout);
   } else {
       if (fString == 0) fString = tmpstr;
   };	/* end of if debug.... */
#else if
   if (!fString) fString = tmpstr;
#endif


    if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
      tell_jmp[0] =  errRes->hrpcErr;
      return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

   (*((*fBinding)->otwDescr).String) (*fBinding, &fString);
/*   XdrString (*fBinding, &fString);  */

#ifdef DEBUGLISP
   if (debug) {
   printf ("return from XdrString with string of length %d, as %s\n",
	   (strlen (fString)), fString);
   printf ("after call: fString is %ld and its contents %ld, %c\n",
   	(int)fString, (int)(*fString), (char)(*fString));
   };
#endif

/*  So XdrString's malloc goes to waste, since I have to reallocate to
      wind up with our data in space that Lisp knows about. */

   if ((*fBinding)->otwOp == OTW_DECODE) {
      strcpy (strbuf, fString);	/* strbuf and newstr() are from franz */
#ifdef DEBUGLISP
       if (debug){
           printf ("copied into strbuf %s\n", fString);
           fflush (stdout);
       };
#endif
      free(fString);
   };
   tell_jmp[0] = 0;
   return ( newstr(0) );	/* return contents of strbuf as Lisp string */

};

/***********************************************************/

long
IntegerTransport ( fBinding, tell_jmp, inout )
     HRPCBinding **fBinding;
     long tell_jmp[2];
     long *inout;

{  HRPCErrRec *errRes;
   jmp_buf Unwind;
   
   Integer tmpint; /* for servers, no one has allocated space, initially, for
		   inout.  so we use automatic space for otw, then return
		   as c-function, so space is allocated in Lisp universe
		   at return */
#ifdef DEBUGLISP
   if (debug) {
       printf ("in IntegerTransport. inout= %d\n",
   	*inout);
   fflush (stdout);
   printf ("bndProgNum is %d\n", (*fBinding)->bndProgNum);
   fflush (stdout);
   };
#endif

   tmpint = (Integer)(*inout);

       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 tell_jmp[0] = errRes->hrpcErr;
	 return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

   (*((*fBinding)->otwDescr).Integer) ((*fBinding), &tmpint);

#ifdef DEBUGLISP
   if (debug) {
       printf ("returned from XdrInteger\n");
     };
#endif

   tell_jmp[0] = 0;
   return ((long) tmpint );
};

/***********************************************************/

long
LongIntegerTransport ( fBinding, tell_jmp, inout )
     HRPCBinding **fBinding;
     long tell_jmp[2];
     long *inout;

{  HRPCErrRec *errRes;
   jmp_buf Unwind;
   
   LongInteger tmpint;
                /* for servers, no one has allocated space, initially, for
		   inout.  so we use automatic space for otw, then return
		   as c-function, so space is allocated in Lisp universe
		   at return */
#ifdef DEBUGLISP
   if (debug) {
       printf ("dummy for IntegerTransport\nShould check speaking. inout= %d\n",
   	*inout);
       fflush (stdout);
       printf ("bndProgNum is %d\n", (*fBinding)->bndProgNum);
       fflush (stdout);
   };
#endif
   tmpint = (LongInteger)(*inout);

       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 tell_jmp[0] = errRes->hrpcErr;
	 return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

   (*((*fBinding)->otwDescr).LongInteger) ((*fBinding), &tmpint);

#ifdef DEBUGLISP
   if (debug) {
       printf ("returned from XdrLongInteger\n");
       fflush (stdout);
     };
#endif

   tell_jmp[0] = 0;
   return ( (long)tmpint );
};

/***********************************************************/

long
LongCardinalTransport ( fBinding, tell_jmp, inout )
     HRPCBinding **fBinding;
     long tell_jmp[2];
     long *inout;

{  LongCardinal tmpint;
   HRPCErrRec *errRes;
   jmp_buf Unwind;

                /* for servers, no one has allocated space, initially, for
		   inout.  so we use automatic space for otw, then return
		   as c-function, so space is allocated in Lisp universe
		   at return */
#ifdef DEBUGLISP
   if (debug) {
       printf ("in LongCardinalTransport\nShould check speaking. inout= %d\n",
   	*inout);
   fflush (stdout);
   printf ("bndProgNum is %d\n", (*fBinding)->bndProgNum);
   fflush (stdout);
   };
#endif

   tmpint = (LongCardinal)(*inout);


       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 tell_jmp[0] = errRes->hrpcErr;
	 return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

   (*((*fBinding)->otwDescr).LongCardinal) ((*fBinding), &tmpint);

#ifdef DEBUGLISP
   if (debug) {
       printf ("returned from XdrLongCardinal\n");
       fflush (stdout);
     };
#endif
  

   tell_jmp[0] = 0;
   return ( (long)tmpint );
};

/***********************************************************/

long
CardinalTransport ( fBinding, tell_jmp, inout )
     HRPCBinding **fBinding;
     long tell_jmp[2];
     long *inout;

{  Cardinal tmpint;
   HRPCErrRec *errRes;
   jmp_buf Unwind;

                /* for servers, no one has allocated space, initially, for
		   inout.  so we use automatic space for otw, then return
		   as c-function, so space is allocated in Lisp universe
		   at return */
#ifdef DEBUGLISP
   if (debug) {
       printf ("in CardinalTransport\nShould check speaking. inout= %d\n",
   	*inout);
   fflush (stdout);
   printf ("bndProgNum is %d\n", (*fBinding)->bndProgNum);
   fflush (stdout);
   };
#endif

   tmpint = (Cardinal)(*inout);


       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 tell_jmp[0] = errRes->hrpcErr;
	 return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

   (*((*fBinding)->otwDescr).Cardinal) ((*fBinding), &tmpint);

#ifdef DEBUGLISP
   if (debug) {
       printf ("returned from XdrCardinal\n");
       fflush (stdout);
     };
#endif
  

   tell_jmp[0] = 0;
   return ( (long)tmpint );
};

/***********************************************************/

long
BooleanTransport ( fBinding, tell_jmp, inout )
     HRPCBinding **fBinding;
     long tell_jmp[2];
     long *inout;

{  Boolean tmpint;
   HRPCErrRec *errRes;
   jmp_buf Unwind;

                /* for servers, no one has allocated space, initially, for
		   inout.  so we use automatic space for otw, then return
		   as c-function, so space is allocated in Lisp universe
		   at return */
#ifdef DEBUGLISP
   if (debug) {
       printf ("in BooleanTransport\nShould check speaking. inout= %d\n",
   	*inout);
   fflush (stdout);
   printf ("bndProgNum is %d\n", (*fBinding)->bndProgNum);
   fflush (stdout);
   };
#endif

   tmpint = (Boolean)(*inout);


       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 tell_jmp[0] = errRes->hrpcErr;
	 return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

   (*((*fBinding)->otwDescr).Boolean) ((*fBinding), &tmpint);

#ifdef DEBUGLISP
   if (debug) {
       printf ("returned from XdrBoolean\n");
       fflush (stdout);
     };
#endif
  

   tell_jmp[0] = 0;
   return ( (long)tmpint );
};

/**************************************************************/

long
OtwListLength (fBinding, tell_jmp, length)
     HRPCBinding **fBinding;
     long tell_jmp[2];
     long *length;
{ int otwTypeVal, intLength;
  LongCardinal tmpLength;
  HRPCErrRec *errRes;
  jmp_buf Unwind;

       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 tell_jmp[0] = errRes->hrpcErr;
	 return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

  if ((otwTypeVal = (**fBinding).otwType) == SUNOTW) {
    if (debug) printf ("SUNOTW used for length function\n");
    /*    XdrCountField (*fBinding, length);  NOTE: XdrCountField is
          defined by a #def to be XdrLongCardinal.  Thus I can't use
	  it because the loader can't find it by its name.  If this changes,
	  this will break. */
    tmpLength = (LongCardinal)(*length);
    XdrLongCardinal (*fBinding, &tmpLength);
    return ((long)tmpLength);
  } else
    if (otwTypeVal == COUROTW) {
      if (debug) printf ("COUROTW used for list length function\n");
      intLength = (int)*length;
      CourCountField (*fBinding, &intLength);
      return ((long)intLength);
    } else {
      tell_jmp[0] = 0x10102;
      if (debug) {
	printf ("not SunXdr, not Courier otw type.  Need to fix transp.c\n");
	fflush (stdout);
      }

      tell_jmp[0] = 0;
      return (1);
    };
};

/************************************************/
/* treating just like integers */

long
LongUnspecTransport ( fBinding, tell_jmp, inout )
     HRPCBinding **fBinding;
     long tell_jmp[2];
     long *inout;

{  HRPCErrRec *errRes;
   jmp_buf Unwind;
   
   LongUnspecified tmpint; /* for servers, no one has allocated space, initially, for
		   inout.  so we use automatic space for otw, then return
		   as c-function, so space is allocated in Lisp universe
		   at return */
#ifdef DEBUGLISP
   if (debug) {
       printf ("in LongUnspecTransport. inout= %d\n",
   	*inout);
   fflush (stdout);
   printf ("bndProgNum is %d\n", (*fBinding)->bndProgNum);
   fflush (stdout);
   };
#endif

   tmpint = (LongUnspecified)(*inout);

       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 tell_jmp[0] = errRes->hrpcErr;
	 return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

   (*((*fBinding)->otwDescr).LongUnspecified) ((*fBinding), &tmpint);

#ifdef DEBUGLISP
   if (debug) {
       printf ("returned from XdrLongUnspecified\n");
     };
#endif

   tell_jmp[0] = 0;
   return ((long) tmpint );
};

/***********************************************************/
/* we're doing Unspecifieds just like integers.
*/

long
UnspecTransport ( fBinding, tell_jmp, inout )
     HRPCBinding **fBinding;
     long tell_jmp[2];
     long *inout;

{  HRPCErrRec *errRes;
   jmp_buf Unwind;
   
   Unspecified tmpint; 

#ifdef DEBUGLISP
   if (debug) {
       printf ("in UnspecTransport. inout= %d\n",
   	*inout);
   fflush (stdout);
   printf ("bndProgNum is %d\n", (*fBinding)->bndProgNum);
   fflush (stdout);
   };
#endif

   tmpint = (Unspecified)(*inout);

       if (errRes = (HRPCErrRec *) setjmp (Unwind)) {
	 tell_jmp[0] = errRes->hrpcErr;
	 return (0);
       }

  (*fBinding)->unwindTo = (memory) Unwind;

   (*((*fBinding)->otwDescr).Unspecified) ((*fBinding), &tmpint);

#ifdef DEBUGLISP
   if (debug) {
       printf ("returned from XdrUnspec\n");
     };
#endif

   tell_jmp[0] = 0;
   return ((long) tmpint );
};

/***********************************************************/
