
;  File:  sendreceive.l  Date:  3/25/87 Kimi Gosney

 ;
 ; INTERFACE:	LispSend (fBinding lispval)
 ;              LispReceive (fBinding lispval)
 ;
 ; FUNCTION:	send and receive any Lispval
 ;
 ; IMPORTS:	various from transport.c
 ;
 ; EXPORTS:	LispSend, LispReceive (others visible, not intended for export)
 ;
 ; DESIGN:	cdr down the list, checking the type of each element.
 ;                The primitives are integers and strings.  Symbols are passed
 ;                as their pname (eventually to be passed as list, with proper-
 ;                ties), lists are handled recursively.  
 ;              Other types are not fully defined yet.
 ;

(comment
; $Log:	sendreceive.l,v $
 * Revision 1.4  87/06/29  19:07:06  kimi
 * working copy as of 6/29/87
 * 
; * Revision 1.3  87/06/09  18:05:20  kimi
; * *** empty log message ***
; * 
; * Revision 1.2  87/05/07  18:28:58  kimi
; * works for hand-built stubs.
; * 
; * Revision 1.1  87/03/30  11:01:31  kimi
; * Initial revision
; * 
)

;  transports general case in Lisp

; these belong in .h file equivalent...
(setq  _symbolLT 0
       _listLT   1
       _fixnumLT 2
       _stringLT 5
       _vectorLT 6
       _vectoriLT 7
       _arrayLT  8
       _otherLT  255
       _dummyLT  -1
)





  
(defun LispSend-aux (fBinding detect-jmp x)
  (cond ((symbolp x)
	 ( EnumTransport fBinding detect-jmp _symbolLT)
	 (and DebugFlag
	      (print `(x is a symbol,(get_pname x) -- sending pname) ))
	 (StringTransport fBinding detect-jmp (get_pname x)))
	((fixp x)
	 (cond ((bigp x) (print `(need to deal with bignum ,x)))
	       ( t (EnumTransport fBinding detect-jmp _fixnumLT)
		   (and DebugFlag (print `(x is a fixnum ,x -- sending)))
		   (IntegerTransport fBinding detect-jmp x)
	       )
	 ))

	((stringp x)
	 (EnumTransport fBinding detect-jmp _stringLT)
	 (and DebugFlag (print `(x is a string ,x -- sending )))
	 (StringTransport fBinding detect-jmp x))
	
     
	((listp x)
	 (and DebugFlag (print '(x is a list)))
	 (LispSend-list fBinding detect-jmp x))
	(t (print '(else)))
))


;(defun LispSend (fBinding x)
;  (cond ((listp x) (LispSend-list fBinding x))
;	( t  (LispSend-aux fBinding x)))
;)


; using the fexpr enables us to eval at top-level only
; necessary to handle lists of arbitrary depth....
( defun LispSend fexpr (x)
  (cond ((listp (eval (caddr x)))
	 (LispSend-list
	  (eval (car x))         ; fBinding
	  (eval (cadr x))        ; detect-jmp
	  (eval (caddr x))))     ; rest
	( t (LispSend-aux (eval(car x)) (eval (cadr x)) (eval (caddr x)))))
)

(defun LispSend-list (fBinding detect-jmp x)
  (prog (x1)
	( EnumTransport fBinding detect-jmp _listLT )
	( OtwListLength fBinding detect-jmp (length x))
	(do ( (x1 x (cdr x1)))
	    ( (null x1) '())
	    ( LispSend-aux fBinding detect-jmp (car x1))
	)
   )
)

;*****************************************************************;

(defun LispReceive ( fBinding detect-jmp dummyArg )
  (prog (receive_type)
	(setq receive_type (EnumTransport fBinding detect-jmp dummyArg))
	
	
        (cond ( (not (equal receive_type _listLT))
	        (return (LispReceive-aux receive_type fBinding detect-jmp dummyArg)))
	      ( t (return (LispReceive-list fBinding detect-jmp dummyArg))))
))

(defun LispReceive-list ( fBinding detect-jmp dummyArg )
  ( prog ( list_length  tmplist count)
	 ( setq 
		 list_length (OtwListLength fBinding detect-jmp dummyArg)
		 tmplist nil
		 count 0)
	 (cond  ((eq list_length 0) (return nil))
		( t nil))
	 loop
	 (setq tmplist (nconc tmplist
		( list (LispReceive-aux (EnumTransport
					     fBinding detect-jmp dummyArg)
					fBinding
					detect-jmp
					dummyArg))))
	 ( setq count (plus count 1))
	 (terpri)
	 (and DebugFlag (print `(count is ,count and tmplist is ,tmplist)))
	 ( cond ((eq count list_length) (return tmplist))
		( t (go loop)))
))

(defun LispReceive-aux (y fBinding detect-jmp dummyArg)
  (cond ((eq y _symbolLT)
	 (concat (StringTransport fBinding detect-jmp dummyArg)))
	((eq y _fixnumLT)
	 (IntegerTransport fBinding detect-jmp dummyArg))
	((eq y _stringLT)
	 (StringTransport fBinding detect-jmp dummyArg))
	((eq y _listLT)
	 (print '(list...))
	 (LispReceive-list fBinding detect-jmp dummyArg))
	(t (print '(couldnt cope with receive -- substituting nil)))
))


