(comment  /* File: constructed.l  Date:   June 1987  Kimi Gosney */

/*
 * INTERFACE:	ArraySend
 *              SequenceSend
 *              ChoiceSend
 *
 * FUNCTION:	transports composed types in terms of primitive types
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 */

;/* $Log:	constructed.l,v $
 * Revision 1.3  87/06/29  19:06:03  kimi
 * working copy as of 6/29/87
 * 
 * Revision 1.2  87/06/15  20:56:14  kimi
 * working version for sequences
 * 
*/
)

(defun ArraySend (fBinding detect-jmp sizeArray type-pattern outgoing)
  (prog (count tmp sender)
	(setq count 0)
	(cond ((and (listp type-pattern)
		    (equal 1 (length type-pattern)))
	       (setq sender 'HRPC-Send-aux)
	       (setq type-pattern (car type-pattern)))
	      ((atom type-pattern)
	       (setq sender 'HRPC-Send-aux))
	      (t (setq sender 'HRPC-Send)))
	(OtwListLength fBinding detect-jmp sizeArray)
	loop
	(cond ((equal count sizeArray) (return))
	      (t
	       (apply sender (list fBinding detect-jmp type-pattern
		      (eval (arrayref outgoing count))))
				 
	       (setq count (plus count 1))))
	(go loop)))

(defun ArrayRecv (fBinding detect-jmp sizeArray type-pattern dummyArg)
  (prog (count tmp recvr lastarg)
	(setq count 0)
	(setq tmp (array tmp t sizeArray))
	(cond ((and (listp type-pattern)
		    (equal 1 (length type-pattern)))
	       (setq recvr 'HRPC-Recv-aux
		     lastarg dummyArg
		     type-pattern (car type-pattern)))
	      ((atom type-pattern)
	       (setq recvr 'HRPC-Recv-aux
		     lastarg dummyArg))
	      (t
	       (setq recvr 'HRPC-Recv
		     lastarg nil)))
	(OtwListLength fBinding detect-jmp sizeArray)
	loop
	(cond ((equal count sizeArray) (return tmp))
	      (t
	       (store (tmp count)
		      (apply recvr
			     (nconc (list fBinding detect-jmp type-pattern)
				    lastarg)))
	       (setq count (plus count 1 ))
	       (go loop)
	       ))
))	       

(defun SequenceSend (fBinding detect-jmp maxSequence type-pattern outgoing)
  (prog (tmp sender)
	(cond ((greaterp (length outgoing) maxSequence)
	       (err (HRPC-error-print SEQUENCE-TOO-LONG (length outgoing))))
	                ; this first one is an error check

	                ; now establish type of send.  It may be composite or
	                ; simple.  If simple, may appear with different
	                ; parenthesization depending on whether specified as
                        ;SEQUENCE OF STRING or SEQUENCE OF RECORD[blah :STRING]
	      ((and (listp type-pattern)
		    (equal 1 (length type-pattern)))
	       (setq type-pattern (car type-pattern))
	       (setq sender 'HRPC-Send-aux))
	      ((atom type-pattern)
	       (setq sender 'HRPC-Send-aux))

	      (t (setq sender 'HRPC-Send)))
	(OtwListLength fBinding detect-jmp (length outgoing))

	loop
	(cond ((null outgoing) (return))
	      (t
	       (apply sender (list fBinding detect-jmp type-pattern
		      (car outgoing)))
	       (setq outgoing (cdr outgoing))))
	(go loop)))




(defun SequenceRecv (fBinding detect-jmp maxSequence type-pattern dummyArg)
  (prog (count tmp recvr lastarg)
	(setq count (OtwListLength fBinding detect-jmp maxSequence)
	      tmp nil)
	(cond ((and (listp type-pattern)
		    (equal 1 (length type-pattern)))
	       (setq recvr 'HRPC-Recv-aux
		     type-pattern (car type-pattern)
		     lastarg (list dummyArg)))
	      ((atom type-pattern)
	       (setq recvr 'HRPC-Recv-aux
		     lastarg (list dummyArg)))
	      (t
	       (setq recvr 'HRPC-Recv
		     lastarg nil)))
	loop
	(cond ((zerop count) (return tmp))
	      (t
	       (setq tmp (nconc tmp (list (apply recvr
				(nconc (list fBinding detect-jmp type-pattern)
				       lastarg))))
		     count (- count 1 ))
	       (go loop)
	       ))
))


;*******************************************************;

(defun ChoiceSend (fBinding detect-jmp type-name type-pattern outgoing)
  (setq ChoiceDescriptivePair (matchtype outgoing type-pattern))
  (EnumTransport fBinding detect-jmp (car ChoiceDescriptivePair))
  (HRPC-Send fBinding
	     detect-jmp
	     (cadr ChoiceDescriptivePair)
	     outgoing)
)



(defun ChoiceRecv (fBinding detect-jmp type-name type-pattern dummyArg)
  (setq ChoiceDescriptivePair
	(assoc (EnumTransport fBinding detect-jmp dummyArg)
	       type-pattern))
  (HRPC-Recv fBinding
	     detect-jmp
	     (cadr ChoiceDescriptivePair)
	     dummyArg)
)
	     

; need to return Enum value and type string
; infer choice type from structure

; input is s-expression to be sent
; choiceassoc list is the association list of 
;    (designator-type type-string-which-may-be-a-list) pairs
;   that has been extracted from recognizing a choice type
(defun matchchoice ( out1 choiceassoclist )
  (cond ((null choiceassoclist) nil)
	((matchtype out1 (cadar choiceassoclist)) (car choiceassoclist))
	( t (matchchoice out1 (cdr choiceassoclist)))))


; test a particular pair to be the match
; out2 is an arbitrary s-expression, typestring is just that
(defun matchtype (out2 typestring)
  (cond ((null out2) (matchNilOut typestring))   ; if TS accepts nil, OK
	((atom out2)
	 (cond ((atom typestring) (matchel out2 typestring))
	       ((equal (car typestring) 'Choice)
		(matchchoice out2 (caddr typestring)))
	       (t nil)))
	((listp typestring)    ; necessary condition.  out2 by now is a list
	 (cond ((equal (car typestring) 'Sequence)
		(matchsequence out2 (cadr typestring) (caddr typestring)))
	       ((equal (car typestring) 'Array)
		(matcharray out2 (cadr typestring) (caddr typestring)))
	       ((equal (car typestring) 'Choice)
		(matchchoice out2 (caddr typestring)))
	       (t (and (matchtype (car out2) (car typestring))
		       (matchtype (cdr out2) (cdr typestring))))))
		       
	(t nil)))


; does a particular typestring unify with nil?
(defun matchNilOut (typestring)
  (or (null typestring)
      (equal typestring 'NilRecord)
      (equal typestring 'Boolean)
      (and (listp typestring)     ; so next line won't fail
	   ( or (equal (car typestring) 'Sequence)    ; zero length sequence
		(and (equal (car typestring) 'Choice)
		     (matchchoice nil (caddr typestring)))))
))


; given an atom, does the type match
; out3 is known to be a non-nil atom
(defun matchel (out3 typestring)
  (cond ((stringp out3) (equal typestring 'String))
	((bigp out3) nil)     ; no mapping for big (test must precede fixp)
	((fixp out3)
	 (cond ((equal typestring 'LongInteger) t)
	       ((equal typestring 'Integer) (< out3 65535))
	       ((equal typestring 'LongCardinal) (> out3 0))
	       ((equal typestring 'Cardinal) (and (< out3 '65535)
						  (> out3 '0)))
	       (t nil)))
	((equal t out3) (equal typestring 'Boolean))
	(t nil)))

        ; floats obviously belong here.  everything else doesn't map to Courier



(defun matchsequence (out3 sequencemax basetype)
  (and ( < (length out3) (add1 sequencemax))
       ( or (null out3)   ; nil is permitted to match a sequence of length 0
	    (apply 'and
		   (mapcar '(lambda (element)
			      (matchtype element basetype))
			   out3)
	    ))))


(defun matcharray (out3 arraysize basetype)
  (prog (counter)
	(setq counter 0)
	(cond ((< (cadr (arraydims out3)) arraysize)
	       (return nil))
	      (t t))
     loop
        (cond ((not (matchtype (arrayref out3 counter) basetype))
	       (return nil))
	      ((= (setq counter (add1 counter)) arraysize)
	       (return t))
	      (t t))
	(go loop)))
	      
	       
		


