/* File: /u1/oystr/HRPC/LWP/stdTypes.h  30-Dec-1983 Eden standard definitions */

/* Included in the HRPC LWP support. */

/*
 * $Header$
 * CAVEATS:	>>>>> WARNING <<<<< >>>>> WARNING <<<<< >>>>> WARNING <<<<<
 *		MAKE NO CHANGES TO THIS FILE WITHOUT THE EXPRESS PERMISSION
 *		OF J. Sanislo ( username `oystr' ).
 *		This file is included by the Eden modifications to the Unix
 *		kernel.  When changes are made to this file, a copy should
 *		be sent to ALL NODES ( ~eden/EdenKernel/h/stdTypes.h ).
 *
 * INTERFACE:	None.
 *
 * FUNCTION:	Define general purpose types.  Declare as external several
 *		structure constants.
 *
 * IMPORTS:	None.
 *
 * EXPORTS:	Standard Eden types: integer, KKStatus, Boolean, NodeNum,
 *		etc.  It also defines as external the names of various
 *		structured constants (see below).
 *
 * DESIGN:	For convenience and consistency Eden uses several
 *		structured constants (e.g. NULLCAPA).  It is handy
 *		to initialize these structures at compile-time and
 *		allow others to use them without including all of Eden.
 *		Due to the fact that the loader will rebel if a global
 *		variable is initialized twice, the variables are here
 *		defined as external.  A separate library module
 *		(EdenKernel/Main/stdValInit.c) contains the initializations
 *		and is available by linking with /usr/local/lib/libeden.a.
 *		Note that this module will not be loaded unless on of the
 *		values is actually referenced.
 *
 * $Log$
 * 3-Nov-1982	Initial implementation. J. Sanislo
 * 4-Feb-1983   Boolean changed from enum {False, True} to int, etc.
 *              D. Jacobson
 * 30-Dec-1983  Coalesced stdTypes and external definitions for structured
 *		constants.  The VALUES of these constants are defined in
 *		the (codeless) module EdenKernel/Main/stdValInit.c.
 */

#ifndef stdTypes
#define stdTypes

#define integer long int
#define KKStatus long int

typedef int Boolean;
#define FALSE 0
#define False 0
#define TRUE  1
#define True  1

#define NodeNum short int
#define NULLNODE (NodeNum) 0

/*
 * The following are the `standard types' defined by the
 * current VAX implementation of Concurrent Euclid.
 * They are prefixed by "CE" to avoid any ambiguity with
 * standard C types which have similar names.
 */
#define CEShortInt unsigned char
#define CESignedInt short int
#define CEUnsignedInt unsigned short int
#define CELongInt long int
#define CEBoolean unsigned char

#define MAXNETPATHCHARS 128

/* Should be changed to NetPathName instead of CountString */
typedef char CountString[MAXNETPATHCHARS];

typedef struct {
	unsigned char TimeChars[6];
} TimeStamp;

typedef struct {
	TimeStamp UIDTime;
	NodeNum	  UIDNode;
} UID;

typedef unsigned short int Rights;

typedef struct {
	UID    ObjectName;
	Rights AccessRights;
} Capability;

/*
 * Standard kernel queue header structure.  Defined
 * this way to make use of VAX hardware queue instructions.
 * NEVER, EVER change this definition without a full review of
 * the situation.
 */
struct Queue {
    struct Queue *F;
    struct Queue *B;
};

/*
 * Define the structure constants as external.
 * These will only be loaded if they are referenced.
 * The initialization is done by the module EdenKernel/h/stdValInit.c,
 * which contains no executable code.
 */
extern Capability  NULLCAPA;
extern TimeStamp   NULLTS;
extern UID	   NULLUID;
extern Rights	   NULLRIGHTS;
extern TimeStamp   INFINITETS;


#endif
