/* File: /u1/oystr/HRPC/LWP/lwpMisc.c  Date:  18-Aug-1987  */

/*
 * $Header$
 * FUNCTION: Miscellaneous routines needed by the LWP control subsystem.
 * 
 * $Log$
 *
 *  18-Aug-1987: Initial implementation, Mark Squillante
 */

#include <HRPC/CIncludes/Binding_defs.h>
#include "kEvents.h"
#include <HRPC/LWP/LWPdefs.h>
#include <HRPC/LWP/LWPtypes.h>
#include "../Transports/connDefs.h"
#include <netinet/in.h>
#ifdef HAS_XNS43
#include <netns/sp.h>
#endif HAS_XNS43

int	HRPC_LWPcreateSTM(fBptr, STMfBptr, STMpid)
    HRPCBinding *fBptr, **STMfBptr;
    lwpPROCESS *STMpid;
{
    BINDING_DESCR	STMfBD;
    PFI			getProperSTM();
    int			(*HRPC_SpeakTypeMgr) ();
    int			retval;

        /* build binding for STM */
    ConvBindingToBD(fBptr,&STMfBD);
    ConvBDtoBinding(&STMfBD,STMfBptr);
    (*STMfBptr)->transDescr.sockfd = fBptr->transDescr.sockfd;
        /* create STM */
    HRPC_SpeakTypeMgr = getProperSTM(fBptr->speaking);
    retval = (*HRPC_lwpDescr.CreateThread)(HRPC_SpeakTypeMgr, 8192,
			STM_lwp_priority, (char *) *STMfBptr,
			"%%STM%%", STMpid);
    switch ( retval ) {
        case HRPC_LWP_ENOMEM:
	    fatalerr("HRPC_LWPinitSocket: No memory to create STM.\n");
	    break; /* not necessary since fatalerr aborts */
        case HRPC_LWP_EBADPRI:
	    fatalerr("HRPC_LWPinitSocket: Illegal priority for STM.\n");
	    break; /* not necessary since fatalerr aborts */
        case HRPC_LWP_EINIT:
	    fatalerr("HRPC_LWPinitSocket: LWP Support not initialized.\n");
	    break; /* not necessary since fatalerr aborts */
    }
    return(retval);
}

int	HRPC_LWPinitSocket(fBptr, sockfd, blockflag)
    HRPCBinding	*fBptr;
    int		sockfd;
    int		blockflag;	/* passed directly to HRPC_SetSocketAsync */
{
    ConnDescr		*connptr = &connStates[sockfd];
    int			spktyp = (int) fBptr->speaking;
    STMconnDescr	*stmconnptr = &STMconnStates[spktyp];
    HRPCBinding		*STMfBptr;
    extern void		setConnReadProc();
    extern int		HRPC_AddToREADFDS();
    extern int		HRPC_SetSocketAsync();
    lwpPROCESS		STMpid;
    int			sigsheldprevious;

    connptr->selmask = (1 << sockfd);
    DISABLE_SignalHandler
    connptr->masterfd = connptr->connfd = sockfd;
    connptr->connbptr = fBptr;
    setConnReadProc(sockfd,fBptr);
    connptr->connCount = 1;
    ENABLE_SignalHandler
    if ( HRPC_lwpType != SingleThread ) {
	HRPC_SetSocketAsync(sockfd,blockflag);
	if ( stmconnptr->connCount == 0 ) {
	    HRPC_LWPcreateSTM(fBptr, &STMfBptr, &STMpid);
	    stmconnptr->STMpid = STMpid;
		/* sanity checks */
	    if ( stmconnptr->BindingQ != (struct BindingQelement *) 0 ) {
		printf("HRPC_LWPinitSocket: warning non-empty BindingQ\n");
	        stmconnptr->BindingQ = (struct BindingQelement *) 0;
	    }
	    DISABLE_SignalHandler
	    if ( stmconnptr->BufferQ != (struct BufferQelement *) 0 ) {
		printf("HRPC_LWPinitSocket: warning non-empty BufferQ\n");
	        stmconnptr->BufferQ = (struct BufferQelement *) 0;
	    }
	    if ( stmconnptr->TaskQ != (struct PacketQelement *) 0 ) {
		printf("HRPC_LWPinitSocket: warning non-empty TaskQ\n");
	        stmconnptr->TaskQ = (struct PacketQelement *) 0;
	    }
	    stmconnptr->BufferQsize = 0;
	    stmconnptr->STMbptr = STMfBptr;
	    ENABLE_SignalHandler
	}
	DISABLE_SignalHandler
	HRPC_AddToREADFDS(sockfd);
	(stmconnptr->connCount)++;
	ENABLE_SignalHandler
    } else {
	DISABLE_SignalHandler
	if ( stmconnptr->connCount == 0 ) {
		/* sanity check */
	    if ( stmconnptr->BufferQ != (struct BufferQelement *) 0 ) {
                printf("HRPC_LWPinitSocket: warning non-empty BufferQ\n");
	        stmconnptr->BufferQ = (struct BufferQelement *) 0;
	    }
	    stmconnptr->BufferQsize = 0;
            stmconnptr->STMbptr = fBptr;
	}
	(stmconnptr->connCount)++;
        ENABLE_SignalHandler
    }
    fBptr->connState = CONN_IDLE;
    fBptr->transDescr.packetArrived = 0;
    return(0);
}

int	HRPC_LWPcloseSocket(fBptr, sockfd)
    HRPCBinding	*fBptr;
    int		sockfd;
{
    ConnDescr		*connptr = &connStates[sockfd];
    int			spktyp = (int) fBptr->speaking;
    STMconnDescr	*stmconnptr = &STMconnStates[spktyp];
    HRPCBinding		*STMfBptr;
    extern int		HRPC_RmFromREADFDS();
    extern int		FreeConnStateQs();
    extern int		DeallocateBuffer();
    int			sigsheldprevious;

    DISABLE_SignalHandler
    connptr->masterfd = connptr->connfd = connptr->selmask = 0;
    connptr->connbptr = (HRPCBinding *) NULL;
    connptr->ReadProc = 0;
    connptr->connCount = 0;
    ENABLE_SignalHandler
    DeallocateBuffer( fBptr ); /* must be done before killing STM */
    DISABLE_SignalHandler
    --(stmconnptr->connCount);
    ENABLE_SignalHandler
    if ( HRPC_lwpType != SingleThread ) {
	if ( stmconnptr->connCount == 0 ) {
	        /* destroy STM */
	    (*HRPC_lwpDescr.DeleteThread)(stmconnptr->STMpid);
	    stmconnptr->STMpid = 0;
		/* want to CloseHRPCBinding, but that calls CloseLink. So... */
	    if ( (STMfBptr=stmconnptr->STMbptr) == (HRPCBinding *) NULL )
	        fatalerr("HRPC_LWPcloseSocket: NULL STM fBptr.\n");
	    (*STMfBptr->rpcDescr.CloseRpc)( STMfBptr );
	    (*STMfBptr->otwDescr.CloseOtw)( STMfBptr );
	    if ( STMfBptr->transDescr.transInfo != NULL ) {
	        free( STMfBptr->transDescr.transInfo );
	        STMfBptr->transDescr.transInfo = NULL;
	    }
	    DeallocateBuffer( STMfBptr );
	    free ((memory) STMfBptr);
	    FreeConnStateQs(spktyp);
	    DISABLE_SignalHandler
	    stmconnptr->STMbptr = (HRPCBinding *) NULL;
	    stmconnptr->BufferQsize = 0;
	    ENABLE_SignalHandler
	}
    } else {
	if ( stmconnptr->connCount == 0 ) {
	    FreeConnStateQs(spktyp);
	    DISABLE_SignalHandler
            stmconnptr->STMbptr = (HRPCBinding *) NULL;
            stmconnptr->BufferQsize = 0;
            ENABLE_SignalHandler
	}
    }
    fBptr->transDescr.sockfd = 0;
    fBptr->connState = CONN_CLOSED;
    fBptr->transDescr.packetArrived = 0;
    return(0);
}

PFI	getProperSTM(speakType)
    SpeakDefs_Speak speakType;
{
	extern int	COUR_SPP_SpeakTypeMgr();
	extern int	SUN_TCP_SpeakTypeMgr();
	extern int	SUN_UDP_SpeakTypeMgr();
	PFI		retval;

	switch ( speakType ) {
	    case SUN_XDR_UDP:
		retval = SUN_UDP_SpeakTypeMgr;
		break;
	    case SUN_XDR_TCP:
		retval = SUN_TCP_SpeakTypeMgr;
		break;
	    case COURIER_COURIER_SPP:
		retval = COUR_SPP_SpeakTypeMgr;
		break;
	    default:
		fatalerr("getProperSTM: don't have STM for speak type %d\n",
						(int) speakType);
		break;	/* NOTREACHED */
	}

	return(retval);
}

int AllocateBuffer( fBptr )
    register HRPCBinding *fBptr;
{
    memory	newmem;
    int		maxSize;
    extern memory GetFromBufferQ();

    maxSize = (*fBptr->transDescr.MaxBufferSize)(fBptr);
#ifdef HAS_XNS43
    if ( fBptr->transType == XNSTRANSP ) maxSize += sizeof(struct sphdr);
#endif HAS_XNS43

    if ( (fBptr->currentBuffer > 0) && (fBptr->maxBufSize == maxSize) ) {
	/* reuse old buffer */
	newmem = fBptr->currentBuffer;
    } else {
	newmem = GetFromBufferQ(fBptr->speaking);
    }

    fBptr->curBufSize = fBptr->maxBufSize = maxSize;
    fBptr->curBufMark = fBptr->currentBuffer = newmem;
    return(0);
}

int DeallocateBuffer( fBptr )
    register HRPCBinding *fBptr;
{
    AddToBufferQ(fBptr->speaking, fBptr->currentBuffer);

    fBptr->curBufSize = fBptr->maxBufSize = 0;
    fBptr->curBufMark = fBptr->currentBuffer = (memory) -1;
}
