/* File: /u1/oystr/HRPC/LWP/kEvents.h  Date:  20-Aug-1987  */

/*
 * $Header$
 * This file was taken from the set of Eden Kernel .h files.  Various lines
 * (not needed in the current application) have been removed.
 * 
 * $Log$
 *
 *  20-Aug-1987: Initial implementation, Mark Squillante
 */

#ifndef HoldSigs

#ifndef NSIG
#include <signal.h>
#endif

/*
 * HoldSigs, ReleaseSigs
 *
 * Prevents signal handlers from being called.  Signals will be queued
 * up until ReleaseSigs is called.  These are macros, and you must
 * #include ~eden/Source/ProcessA/Events.h to get them.
 */

extern	ReleaseSigs1();
extern	HRPC_RealSigHandler();

#define HoldSigs()	(SigsHeld = 1)
#define ReleaseSigs()   ((SigsHeld = Pending) ? ReleaseSigs1() : 0)

int	SigsHeld;		/* 1 iff signals are to be held. */
int	SigEvent_Ntimes;	/* Incremented every time an HRPC signal occurs */
				/* and these signals are held; set to 0 when */
				/* HRPC handler is called by ReleaseSigs1() */
int	Pending;

#define DISABLE_SignalHandler	if ( SigsHeld ) \
				    sigsheldprevious = 1; \
				else { \
				    sigsheldprevious = 0; \
				    HoldSigs(); \
				}

#define ENABLE_SignalHandler	if ( !sigsheldprevious ) \
				    ReleaseSigs();

#endif
