--
-- Courier description for TCP call interface to BIND.  This is like the
-- UDP interface except (1) It has a different program number, (2) TCP
-- BIND prepends a byte count to the messages (since streams don't preserve
-- record boundaries).  We need to fill in this byte count in In msgs to BIND,
-- but we don't need to look at the byte count for Out msgs because we
-- always use marhsalling procedures that know how many bytes they need:  if
-- not all bytes have been read in when demarshalling occurs, the primitive
-- demarshalling routines call OtwNeedBytes, which reads whatever bytes are
-- still outstanding.  We fill in the In msg byte count in our own
-- USERPROCs, as specified below.
--

TCPBIND : PROGRAM 20191 VERSION 1 =

BEGIN
	DEPENDS UPON BIND_MsgStructs (20190) VERSION 1;

--
-- Types
--
	LookupNameInMsg : TYPE = USERPROC TCPLookupNameInMsgMarshaller
	RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.LookupNameInMsg
	];

	LookupNameOutMsg : TYPE = RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.LookupNameOutMsg
	];

	AddRRInMsg : TYPE = USERPROC TCPAddRRInMsgMarshaller
	RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.AddRRInMsg
	];

	AddRROutMsg : TYPE = RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.AddRROutMsg
	];

	DeleteRRInMsg : TYPE = USERPROC TCPDeleteRRInMsgMarshaller
	RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.DeleteRRInMsg
	];

	DeleteRROutMsg : TYPE = RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.DeleteRROutMsg
	];

	ModifyInMsg : TYPE = USERPROC TCPModifyInMsgMarshaller
	RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.ModifyInMsg
	];

	ModifyOutMsg : TYPE = RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.ModifyOutMsg
	];

	ZoneXferInMsg : TYPE = USERPROC TCPLookupNameInMsgMarshaller
	RECORD [
		MsgByteCount : INTEGER,
		Msg : BIND_MsgStructs.LookupNameInMsg
	];

	-- Need my own USERPROC for the ZoneXferOutMsg record type because
	-- the RRecs that come back aren't demarshaled until they are
	-- interpreted by LookupName.  The definition here doesn't correspond
	-- to what comes back from BIND, since the demarshalling that needs
	-- to be done can't be described in Courier.  Instead, it just contains
	-- a response code.  See the USERPROC for a description of the
	-- demarshalling algorithm.
	ZoneXferOutMsg : TYPE = USERPROC ZoneXferOutMsgMarshaller
	RECORD [
		ResponseCode    : INTEGER
	];


--
-- "Procedural" interfaces.  Note that for the RAW HRPC protocols, the
-- procedure numbers aen't used, but they must be specified here to satisfy
-- the stub generator.
--
	LookupName : PROCEDURE [Input : LookupNameInMsg]
			RETURNS [Output : LookupNameOutMsg] = 1;

	AddRR : PROCEDURE [Input : AddRRInMsg]
			RETURNS [Output : AddRROutMsg] = 1;

	DeleteRR : PROCEDURE [Input : DeleteRRInMsg]
			RETURNS [Output : DeleteRROutMsg] = 1;

	Modify : PROCEDURE [Input : ModifyInMsg]
			RETURNS [Output : ModifyOutMsg] = 1;


	-- Non-standard for BIND clients to use ZoneXfer; I use it for
	-- preloading the cache of HNS data.  Note that BIND only allows
	-- zone transfers for TCP messages.
	ZoneXfer : PROCEDURE [Input : ZoneXferInMsg]
			RETURNS [Output : ZoneXferOutMsg] = 1;
END.
