-- Courier definition for interface to hostname-to-network address translation
-- NSMs.  By Mike Schwartz, 10-21-86.

NameToNetAddr : PROGRAM 411 VERSION 1 =

BEGIN
	DEPENDS UPON Binding(1234) VERSION 1;

	-- Generic address type.  The plan is that this type is longer than
	-- any real address.  This way, we can put any address (currently,
	-- IP and XNS addresses) in here, allowing the interfaces to this
	-- NSM to be the same for any network/name service
	GenericAddress : TYPE = ARRAY 8 OF UNSPECIFIED;

	Inputs : TYPE = RECORD [
		HostName : STRING,	-- E.g., "wally.cs.washington.edu"
					-- for BIND, and "Mizar:CS:UWash"
					-- for Clearinghouse
		NSvcBDList : Binding.BINDING_DESCR_LIST
	];
	Outputs : TYPE = RECORD [
		Status : LONG INTEGER,
		Addresses : SEQUENCE 10 OF GenericAddress	-- Could be on
								-- multiple
								-- networks
	];
END.
