--
-- Courier interface descripion for the HNS.  By Mike Schwartz, 10/86.
--

HNS : PROGRAM 2019 VERSION 1 =

BEGIN

	DEPENDS UPON Binding(1234) VERSION 1;



	-- Note: We refer to parts of the HNS (underlying name servers, NSMs,
	-- and contexts) as HNSComponents (HNSComp for short).  It does not
	-- include, for instance, HCS servers other than name servers.  Note
	-- that an HNSComponent is an individual server (which may be
	-- directly linked or remote) running at a particular node, not the
	-- conglomerate service.  Also, HNSComponents are named hierarchically,
	-- relative to local organizations (e.g.,
	-- "BIND-NameService-HNS.cs.washington.edu"), to allow for a scalable
	-- implementation.

	-- In contrast, we refer to client-level parts as Entities (e.g.,
	-- servers in the case of binding, or mailboxes in the case of mail).
	-- Entites are name with HNS names (defined below).




	------------------------
	-- General HNS types  --
	------------------------

	HNSStatus : TYPE = LONG INTEGER;	-- Among more specific meanings,
						-- zero means success, non-zero
						-- means failure

	HierName : TYPE = STRING;	-- Hierarchical name, e.g.,
					-- "Mailboxes.cs.washington.edu"

	HNSName : TYPE = RECORD [
		Context : HierName,
		Name : HierName
	];


	NSMInfo : TYPE = RECORD [
		NSMName : HierName,
		NSvcName : HierName,	-- The name service whose semantics
					-- this NSM understands
		Operation : HierName,	-- The operation whose semantics this
					-- NSM manages for this name service
		BindingDescr : Binding.BINDING_DESCR_DESCR
	];

	-- The following has to be a RECORD so the stub gen will generate
	-- a marshalling routine for it (since we must refer to that
	-- marshalling routine when calling an HRPC BIND interface routine
	-- with data of this type, e.g., in EnumNSvcs)
	HNSCompListElem : TYPE = RECORD [
		HNSCompName : HierName
	];

	ContextInfo : TYPE = RECORD [
		ContextName : HierName,
		NSvcWhereStored : STRING,
		OpsNeeded : LONG UNSPECIFIED,
		ExpectedSize : LONG CARDINAL,
		ExpectedReadRate : LONG CARDINAL,
		ExpectedWriteRate : LONG CARDINAL
	];



	----------------------------------------------------------
	-- Procedural interfaces, including input/output types	--
	----------------------------------------------------------

	Ping : PROCEDURE = 1;	-- No-op "are you alive?" procedure (only
				-- useful for remote HNS interface)

	EnabBINDCacheInputs : TYPE = RECORD [
		Enable : BOOLEAN
	];
	EnabBINDCache : PROCEDURE [Input : EnabBINDCacheInputs] = 2;
		-- Request HNS to enable/disable its BIND cache
		-- (to measure the effect)

	DumpHNSBINDCache : PROCEDURE = 3; -- Request HNS to dump BIND cache into
					  -- the BIND_CACHE_DBG_FILE (see
					  -- BINDCtrlCache.c)

	-- For Name service, we register BindingDescrs, rather than
	-- BindingDescrDescrs, to avoid infinite recursion
	AddNSvcBDescrInputs : TYPE = RECORD [
		NSvcName : HierName,	-- E.g. "BIND"
		BindingDescr : Binding.BINDING_DESCR
	];
	AddNSvcBDescrOutputs : TYPE = RECORD [
		Status : HNSStatus
	];
	AddNSvcBDescr : PROCEDURE [Input : AddNSvcBDescrInputs]
			RETURNS [Output : AddNSvcBDescrOutputs] = 4;


	DelNSvcBDescrInputs : TYPE = RECORD [
		NSvcName : HierName,	-- E.g. "BIND"
		BindingDescr : Binding.BINDING_DESCR
	];
	DelNSvcBDescrOutputs : TYPE = RECORD [
		Status : HNSStatus
	];
	DelNSvcBDescr : PROCEDURE [Input : DelNSvcBDescrInputs]
			RETURNS [Output : DelNSvcBDescrOutputs] = 5;


	-- Note: the user must deallocate the storage for the HNSCompListElems
	-- and the sequence
	EnumNSvcsOutputs : TYPE = RECORD [
		Status : HNSStatus,
		NSvcNameList : SEQUENCE 1000 OF HNSCompListElem
	];
	EnumNSvcs : PROCEDURE
			RETURNS [Output : EnumNSvcsOutputs] = 6;


	-- Note: the user must deallocate the storage for the sequence (BDList)
	FindNSvcInputs : TYPE = RECORD [
		NSvcName : HierName		-- E.g., "BIND"
	];
	FindNSvcOutputs : TYPE = RECORD [
		Status : HNSStatus,
		BDList : Binding.BINDING_DESCR_LIST
	];
	FindNSvc : PROCEDURE [Input : FindNSvcInputs]
			RETURNS [Output : FindNSvcOutputs] = 7;



	AddNSMBDDescrInputs : TYPE = RECORD [
		OpName : HierName,	-- E.g. "GetMailMsgs"
		NSvcName : HierName,	-- E.g. "BIND"
		BindingDescrDescr : Binding.BINDING_DESCR_DESCR
	];
	AddNSMBDDescrOutputs : TYPE = RECORD [
		Status : HNSStatus
	];
	AddNSMBDDescr : PROCEDURE [Input : AddNSMBDDescrInputs]
			RETURNS [Output : AddNSMBDDescrOutputs] = 8;


	DelNSMBDDescrInputs : TYPE = RECORD [
		OpName : HierName,	-- E.g. "GetMailMsgs"
		NSvcName : HierName,	-- E.g. "BIND"
		BindingDescrDescr : Binding.BINDING_DESCR_DESCR
	];
	DelNSMBDDescrOutputs : TYPE = RECORD [
		Status : HNSStatus
	];
	DelNSMBDDescr : PROCEDURE [Input : DelNSMBDDescrInputs]
			RETURNS [Output : DelNSMBDDescrOutputs] = 9;


	-- Note: the user must deallocate the storage for the HNSCompListElems
	-- and the sequence
	EnumNSMsOutputs : TYPE = RECORD [
		Status : HNSStatus,
		NSMNameList : SEQUENCE 1000 OF HNSCompListElem
	];
	EnumNSMs : PROCEDURE
			RETURNS [Output : EnumNSMsOutputs] = 10;


	GetNSMInfoInputs : TYPE = RECORD [
		OpName : HierName,	-- E.g. "GetMailMsgs"
		NSvcName : HierName	-- E.g. "BIND"
	];
	GetNSMInfoOutputs : TYPE = RECORD [
		Status : HNSStatus,
		NSMBDDList : Binding.BINDING_DESCR_DESCR_LIST
	];
	GetNSMInfo : PROCEDURE [Input : GetNSMInfoInputs]
			RETURNS [Output : GetNSMInfoOutputs] = 11;


	-- The HNS maps an (EntityName, OpName) to an NSM (or set of
	-- NSM servers) as follows:
	--	EntityName.Context -> NSvc;
	--	(NSvc, OpName) -> NSM
	-- Note: the user must deallocate the storage for the sequence (BDList)
	FindNSMInputs : TYPE = RECORD [
		EntityName : HNSName,
		OpName : HierName,
		NeedNSMAddr : BOOLEAN	-- Normally will be true; false in 2
					-- cases: (1) Interface known to be
					-- local, so want to save cost of extra
					-- RPC to do hostname-to-address lookup,
					-- (2) Used by FindNSM to bottom out
					-- recursion
	];
	FindNSMOutputs : TYPE = RECORD [
		Status : HNSStatus,
		NSMName : HierName,	-- May not need this if HRPC becomes
					-- "remoteness transparent"
		NSMBDList : Binding.BINDING_DESCR_LIST,
		-- Also return a BDList for the name service to call, which the
		-- client passes to the NSM, so the NSM can call different
		-- name service instances but share code
		NSvcBDList : Binding.BINDING_DESCR_LIST
	];
	FindNSM : PROCEDURE [ Input : FindNSMInputs ]
			RETURNS [ Output : FindNSMOutputs ] = 12;

	CreateContextInputs : TYPE = ContextInfo;
		-- Note: if NSvcWhereStored is NULL, then the HNS uses
		-- access profile information to decide where to store
		-- the context
	CreateContextOutputs : TYPE = RECORD [
		Status : HNSStatus
	];
	CreateContext : PROCEDURE [Input : CreateContextInputs]
			RETURNS [Output : CreateContextOutputs] = 13;


	DelContextInputs : TYPE = RECORD [
		ContextName : HierName
	];
	DelContextOutputs : TYPE = RECORD [
		Status : HNSStatus
	];
	DelContext : PROCEDURE [Input : DelContextInputs]
			RETURNS [Output : DelContextOutputs] = 14;


	-- Note: the user must deallocate the storage for the HNSCompListElems
	-- and the sequence
	EnumContextsOutputs : TYPE = RECORD [
		Status : HNSStatus,
		ContextNameList : SEQUENCE 1000 OF HNSCompListElem
	];
	EnumContexts : PROCEDURE
			RETURNS [Output : EnumContextsOutputs] = 15;



	GetContextInfoInputs : TYPE = RECORD [
		ContextName : HierName
	];
	GetContextInfoOutputs : TYPE = RECORD [
		Status : HNSStatus,
		Info : ContextInfo
	];
	GetContextInfo : PROCEDURE [Input : GetContextInfoInputs]
			RETURNS [Output : GetContextInfoOutputs] = 16;
END.
